/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface;

import com.mojang.logging.LogUtils;
import com.mrbysco.chunkymcchunkface.blocks.entity.ValidationHelper;
import com.mrbysco.chunkymcchunkface.client.ClientHandler;
import com.mrbysco.chunkymcchunkface.client.KeyHandler;
import com.mrbysco.chunkymcchunkface.commands.ChunkyCommands;
import com.mrbysco.chunkymcchunkface.config.ChunkyConfig;
import com.mrbysco.chunkymcchunkface.handler.PlayerHandler;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketSet;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;

@Mod(value="chunkymcchunkface")
public class ChunkyMcChunkFace {
    public static final String MOD_ID = "chunkymcchunkface";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TicketController CONTROLLER = new TicketController(ResourceLocation.fromNamespaceAndPath((String)"chunkymcchunkface", (String)"default"), (serverLevel, ticketHelper) -> {
        ResourceLocation dimensionLocation = serverLevel.dimension().location();
        for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            LongSet forcedChunks = ((TicketSet)entry.getValue()).normal();
            LongSet tickingForcedChunks = ((TicketSet)entry.getValue()).naturalSpawning();
            ValidationHelper.validateTickets(serverLevel, dimensionLocation, pos, ticketHelper, forcedChunks, false);
            ValidationHelper.validateTickets(serverLevel, dimensionLocation, pos, ticketHelper, tickingForcedChunks, true);
        }
    });

    public ChunkyMcChunkFace(IEventBus eventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChunkyConfig.commonSpec, "ChunkyMcChunkFace-common.toml");
        eventBus.register(ChunkyConfig.class);
        eventBus.addListener(this::registerTicketController);
        eventBus.addListener(this::fillCreativeTab);
        ChunkyRegistry.BLOCKS.register(eventBus);
        ChunkyRegistry.BLOCK_ENTITIES.register(eventBus);
        ChunkyRegistry.ITEMS.register(eventBus);
        NeoForge.EVENT_BUS.register((Object)new PlayerHandler());
        NeoForge.EVENT_BUS.register((Object)new ChunkyCommands());
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::onClientSetup);
            eventBus.addListener(ClientHandler::registerKeyMappings);
            eventBus.addListener(ClientHandler::registerEntityRenders);
            eventBus.addListener(ClientHandler::onRegisterRenderTypes);
            eventBus.addListener(ClientHandler::registerRenderPipeline);
            NeoForge.EVENT_BUS.addListener(KeyHandler::onClientTick);
        }
    }

    private void registerTicketController(RegisterTicketControllersEvent event) {
        event.register(CONTROLLER);
    }

    private void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept((ItemLike)ChunkyRegistry.CHUNK_LOADER.get());
        }
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

