/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.blocks;

import com.mojang.serialization.MapCodec;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.data.ChunkData;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderBlock
extends BaseEntityBlock {
    public static final MapCodec<ChunkLoaderBlock> CODEC = ChunkLoaderBlock.simpleCodec(ChunkLoaderBlock::new);
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public MapCodec<ChunkLoaderBlock> codec() {
        return CODEC;
    }

    public ChunkLoaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENABLED, (Comparable)Boolean.FALSE));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChunkLoaderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : ChunkLoaderBlock.createTickerHelper(blockEntityType, ChunkyRegistry.CHUNK_LOADER_ENTITY.get(), ChunkLoaderBlockEntity::serverTick);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult pHitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.TRUE));
            blockEntity2.addPlayer(player.getUUID());
            blockEntity2.enableChunkLoading();
        }
        return InteractionResult.CONSUME;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState state1, boolean p_60570_) {
        if (!level.isClientSide()) {
            ChunkData data = ChunkData.get(level);
            data.addChunkLoaderPosition(level, pos);
            data.setDirty();
        }
        super.onPlace(state, level, pos, state1, p_60570_);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{ENABLED});
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        BlockEntity blockEntity;
        boolean flag = level.hasNeighborSignal(pos);
        if (flag && ((Boolean)state.getValue((Property)ENABLED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.FALSE));
            blockEntity2.clearPlayerCache();
            blockEntity2.unloadChunks();
        }
    }
}

