/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.blocks.entity;

import com.mojang.serialization.Codec;
import com.mrbysco.chunkymcchunkface.ChunkyMcChunkFace;
import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.config.ChunkyConfig;
import com.mrbysco.chunkymcchunkface.data.ChunkData;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.registry.ChunkyTags;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderBlockEntity
extends BlockEntity {
    private static final int MAX_TIERS = 4;
    private int tier;
    private final List<UUID> playerCache = new ArrayList<UUID>();
    protected final LongSet loadedChunks = new LongOpenHashSet();
    private int cooldown = 0;
    private boolean playerOnline = false;
    private long lastSeen = 0L;

    public ChunkLoaderBlockEntity(BlockPos pos, BlockState state) {
        super(ChunkyRegistry.CHUNK_LOADER_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChunkLoaderBlockEntity blockEntity) {
        int tier;
        if (level.getGameTime() % 80L == 0L && (tier = ChunkLoaderBlockEntity.getUpdatedTier(level, pos)) != blockEntity.tier) {
            ChunkyMcChunkFace.LOGGER.info("ChunkLoader at {} has been updated from tier {} to tier {}", new Object[]{pos, blockEntity.tier, tier});
            blockEntity.tier = tier;
            blockEntity.refreshChunks();
        }
        if (blockEntity.isEnabled() && level.getGameTime() % 20L == 0L) {
            if (blockEntity.playerCache.isEmpty()) {
                blockEntity.disableChunkLoaderState();
                blockEntity.disableChunkLoader();
            } else {
                boolean isPlayerOnline = blockEntity.isPlayerOnline();
                long latestTime = blockEntity.getLastSeen();
                if (!isPlayerOnline) {
                    int configuredTicks = (Integer)ChunkyConfig.COMMON.offlineTime.get();
                    if (configuredTicks != 0 && latestTime > 0L && level.getGameTime() - latestTime > (long)configuredTicks) {
                        ChunkyMcChunkFace.LOGGER.info("ChunkLoader at {} has been disabled due to inactivity of the players {}", (Object)pos, (Object)ChunkyHelper.formatTicks(configuredTicks));
                        blockEntity.disableChunkLoaderState();
                        blockEntity.disableChunkLoader();
                    }
                } else if (level.getGameTime() % 100L == 0L) {
                    blockEntity.loadChunks();
                }
            }
        }
        if (blockEntity.cooldown > 0) {
            --blockEntity.cooldown;
        }
    }

    public long getLastSeen() {
        long latestTime = 0L;
        for (UUID uuid : this.playerCache) {
            Player player = this.level.getPlayerByUUID(uuid);
            ChunkData data = ChunkData.get(this.level);
            long lastSeen = player != null ? this.level.getGameTime() : data.getLastSeen(uuid);
            if (lastSeen <= latestTime) continue;
            latestTime = lastSeen;
        }
        this.lastSeen = latestTime;
        return latestTime;
    }

    public long getLastSeenCache() {
        return this.lastSeen;
    }

    public boolean isPlayerOnline() {
        boolean isPlayerOnline = false;
        for (UUID uuid : this.playerCache) {
            if (this.level.getPlayerByUUID(uuid) == null) continue;
            isPlayerOnline = true;
        }
        this.playerOnline = isPlayerOnline;
        return isPlayerOnline;
    }

    public boolean getPlayerOnlineCache() {
        return this.playerOnline;
    }

    public void disableChunkLoader() {
        this.clearPlayerCache();
        this.unloadChunks();
    }

    public void disableChunkLoaderState() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ChunkLoaderBlock.ENABLED, (Comparable)Boolean.FALSE));
    }

    public void clearPlayerCache() {
        this.playerCache.clear();
    }

    public void enableChunkLoading() {
        if (this.cooldown == 0) {
            this.loadChunks();
            this.cooldown = 20;
        }
    }

    public void unloadChunks() {
        if (this.level != null && !this.level.isClientSide()) {
            long pos2;
            ChunkyMcChunkFace.LOGGER.debug("Attempting to remove {} chunk tickets. pos: {} world: {}", new Object[]{this.loadedChunks.size(), this.worldPosition.toShortString(), this.level.dimension().location()});
            ServerLevel serverLevel = (ServerLevel)this.level;
            ChunkData data = ChunkData.get(this.level);
            long centerChunk = new ChunkPos(this.worldPosition).toLong();
            int range = this.getRange(this.tier);
            LongSet chunkPosList = ChunkyHelper.generateChunkPosList(centerChunk, range);
            List<ChunkPos> loaderList = data.getActiveChunkLoaderChunks(serverLevel);
            loaderList.forEach(pos -> {
                long longPos = pos.toLong();
                chunkPosList.remove(longPos);
                this.loadedChunks.remove(longPos);
            });
            LongIterator longIterator = chunkPosList.iterator();
            while (longIterator.hasNext()) {
                pos2 = (Long)longIterator.next();
                this.loadedChunks.remove(pos2);
                ChunkyHelper.releaseChunkTicket(serverLevel, this.worldPosition, pos2);
            }
            longIterator = this.loadedChunks.iterator();
            while (longIterator.hasNext()) {
                pos2 = (Long)longIterator.next();
                ChunkyHelper.releaseChunkTicket(serverLevel, this.worldPosition, pos2);
            }
            this.loadedChunks.clear();
            this.refreshClient();
            ChunkyHelper.releaseChunkTicket(serverLevel, this.worldPosition, centerChunk);
        }
    }

    public void loadChunks(int tier) {
        if (this.isEnabled() && this.level != null && !this.level.isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level;
            long centerChunk = new ChunkPos(this.worldPosition).toLong();
            int range = this.getRange(tier);
            LongSet chunkPosList = ChunkyHelper.generateChunkPosList(centerChunk, range);
            LongIterator longIterator = chunkPosList.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                this.loadedChunks.add(pos);
                ChunkyHelper.registerChunkTicket(serverLevel, this.worldPosition, pos);
            }
            this.refreshClient();
        }
    }

    public void loadChunks() {
        this.loadChunks(this.getTier());
    }

    public void refreshChunks() {
        if (this.level != null && !this.level.isClientSide() && this.isEnabled()) {
            this.unloadChunks();
            this.loadChunks(this.getTier());
        }
    }

    private static int getUpdatedTier(Level level, BlockPos pos) {
        int k;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int i = 0;
        int j = 1;
        while (j <= 4 && (k = y - j) >= level.getMinY()) {
            boolean flag = true;
            block1: for (int l = x - j; l <= x + j && flag; ++l) {
                for (int i1 = z - j; i1 <= z + j; ++i1) {
                    if (level.getBlockState(new BlockPos(l, k, i1)).is(ChunkyTags.UPGRADE_BLOCKS)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            i = j++;
        }
        return i;
    }

    public int getRange(int tier) {
        return switch (tier) {
            case 1 -> (Integer)ChunkyConfig.COMMON.tier1Range.get();
            case 2 -> (Integer)ChunkyConfig.COMMON.tier2Range.get();
            case 3 -> (Integer)ChunkyConfig.COMMON.tier3Range.get();
            case 4 -> (Integer)ChunkyConfig.COMMON.tier4Range.get();
            default -> (Integer)ChunkyConfig.COMMON.baseRange.get();
        };
    }

    public int getRange() {
        return this.getRange(this.getTier());
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isEnabled() {
        return this.getBlockState().is((Block)ChunkyRegistry.CHUNK_LOADER.get()) && (Boolean)this.getBlockState().getValue((Property)ChunkLoaderBlock.ENABLED) != false;
    }

    public void addPlayer(UUID uuid) {
        if (!this.playerCache.contains(uuid)) {
            this.playerCache.add(uuid);
            this.refreshClient();
        }
    }

    protected void loadAdditional(ValueInput input) {
        ValueInput.TypedInputList chunks;
        super.loadAdditional(input);
        this.tier = input.getIntOr("Levels", 0);
        this.cooldown = input.getIntOr("Cooldown", 0);
        if (!this.loadedChunks.isEmpty()) {
            if (this.hasLevel()) {
                this.unloadChunks();
            } else {
                this.loadedChunks.clear();
            }
        }
        if (!(chunks = input.listOrEmpty("loadedChunks", (Codec)Codec.LONG)).isEmpty()) {
            Iterator iterator = chunks.iterator();
            while (iterator.hasNext()) {
                long chunk = (Long)iterator.next();
                this.loadedChunks.add(chunk);
            }
        }
        ValueInput.TypedInputList cache = input.listOrEmpty("playerCache", UUIDUtil.CODEC);
        cache.forEach(this.playerCache::add);
        this.lastSeen = input.getLongOr("lastSeen", 0L);
        this.playerOnline = input.getBooleanOr("playerOnline", false);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("Levels", this.tier);
        output.putInt("Cooldown", this.cooldown);
        ValueOutput.TypedOutputList loadedList = output.list("loadedChunks", (Codec)Codec.LONG);
        LongIterator longIterator = this.loadedChunks.iterator();
        while (longIterator.hasNext()) {
            long chunk = (Long)longIterator.next();
            loadedList.add((Object)chunk);
        }
        output.putLong("lastSeen", this.lastSeen);
        output.putBoolean("playerOnline", this.playerOnline);
        ValueOutput.TypedOutputList playerCacheList = output.list("playerCache", UUIDUtil.CODEC);
        for (UUID uuid : this.playerCache) {
            playerCacheList.add((Object)uuid);
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.disableChunkLoader();
        ChunkData data = ChunkData.get(this.level);
        data.removeChunkLoaderPosition(this.level, pos);
        data.setDirty();
        super.preRemoveSideEffects(pos, state);
    }

    public void onDataPacket(Connection net, ValueInput valueInput) {
        super.onDataPacket(net, valueInput);
        BlockState state = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag tag = new CompoundTag();
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(ChunkyMcChunkFace.LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)lookupProvider);
            this.saveAdditional((ValueOutput)output);
            tag.merge(output.buildResult());
        }
        return tag;
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(ChunkyMcChunkFace.LOGGER);){
            HolderLookup.Provider lookupProvider = this.level != null ? this.level.registryAccess() : VanillaRegistries.createLookup();
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)lookupProvider);
            this.saveAdditional((ValueOutput)output);
            tag.merge(output.buildResult());
        }
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void refreshClient() {
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
    }
}

