/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.blocks.entity;

import com.mrbysco.chunkymcchunkface.ChunkyMcChunkFace;
import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;

public class ValidationHelper {
    public static void validateTickets(ServerLevel serverLevel, ResourceLocation dimensionLocation, BlockPos pos, TicketHelper ticketHelper, LongSet forcedChunks, boolean ticking) {
        BlockEntity blockEntity;
        int ticketCount = forcedChunks.size();
        if (ticketCount > 0 && (blockEntity = serverLevel.getBlockEntity(pos)) instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
            if (blockEntity2.isEnabled()) {
                LongSet chunks;
                if (!forcedChunks.equals((Object)blockEntity2.loadedChunks)) {
                    ChunkyMcChunkFace.LOGGER.debug("Mismatched chunkSet for chunk loader at position: {} in {}. Correcting.", (Object)pos, (Object)dimensionLocation);
                    blockEntity2.loadedChunks.clear();
                    blockEntity2.loadedChunks.addAll((LongCollection)forcedChunks);
                    blockEntity2.setChanged();
                }
                if ((chunks = ChunkyHelper.generateChunkPosList(new ChunkPos(pos).toLong(), blockEntity2.getTier())).isEmpty()) {
                    ChunkyMcChunkFace.LOGGER.warn("Removing {} chunk tickets as they are no longer valid as this loader does not expect to have any tickets even though it is can operate. Pos: {} World: {}", new Object[]{ticketCount, pos, dimensionLocation});
                    ValidationHelper.releaseAllTickets(blockEntity2, pos, ticketHelper);
                } else {
                    int removed = 0;
                    int added = 0;
                    LongIterator chunkIt = blockEntity2.loadedChunks.iterator();
                    while (chunkIt.hasNext()) {
                        long chunkPos = chunkIt.nextLong();
                        if (chunks.contains(chunkPos) && ticking == blockEntity2.isEnabled()) continue;
                        ticketHelper.removeTicket(pos, chunkPos, ticking);
                        chunkIt.remove();
                        ++removed;
                    }
                    if (removed == 0 && added == 0) {
                        ChunkyMcChunkFace.LOGGER.debug("Chunk tickets for position: {} in {}, successfully validated.", (Object)pos, (Object)dimensionLocation);
                    } else {
                        blockEntity2.setChanged();
                        ChunkyMcChunkFace.LOGGER.info("Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", new Object[]{removed, added, pos, dimensionLocation});
                    }
                }
            } else {
                ChunkyMcChunkFace.LOGGER.info("Removing {} chunk tickets as they are no longer valid. Pos: {} World: {}", new Object[]{ticketCount, pos, dimensionLocation});
                ValidationHelper.releaseAllTickets(blockEntity2, pos, ticketHelper);
            }
        }
    }

    private static void releaseAllTickets(ChunkLoaderBlockEntity blockEntity, BlockPos pos, TicketHelper ticketHelper) {
        ticketHelper.removeAllTickets(pos);
        blockEntity.loadedChunks.clear();
        BlockState state = blockEntity.getBlockState();
        if (state.is((Block)ChunkyRegistry.CHUNK_LOADER.get())) {
            blockEntity.getLevel().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ChunkLoaderBlock.ENABLED, (Comparable)Boolean.FALSE));
        }
        blockEntity.setChanged();
    }
}

