/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.client.ChunkyRenderTypes;
import com.mrbysco.chunkymcchunkface.client.renderer.ChunkLoaderRenderState;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ChunkLoaderBER
implements BlockEntityRenderer<ChunkLoaderBlockEntity, ChunkLoaderRenderState> {
    public static boolean renderChunkRadius = false;
    public final Map<Long, Integer> rangeMap = new HashMap<Long, Integer>();

    public ChunkLoaderBER(BlockEntityRendererProvider.Context context) {
    }

    public void submit(ChunkLoaderRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.getMainHandItem().is((Item)ChunkyRegistry.CHUNK_LOADER_ITEM.get())) {
            this.renderOutline(nodeCollector, renderState, poseStack);
        }
        if (mc.level != null && renderChunkRadius) {
            List<ChunkPos> list;
            BlockPos loaderPos = renderState.blockPos;
            long posLong = loaderPos.asLong();
            long centerChunk = new ChunkPos(loaderPos).toLong();
            int range = renderState.range;
            if (!this.rangeMap.containsKey(posLong)) {
                this.rangeMap.put(posLong, range);
            }
            if ((list = ChunkyHelper.generateChunkPosList(centerChunk, range).longStream().mapToObj(ChunkPos::new).toList()).isEmpty()) {
                return;
            }
            ArrayList<AABB> boxes = new ArrayList<AABB>();
            for (ChunkPos chunkPos : list) {
                AABB box = AABB.of((BoundingBox)new BoundingBox(chunkPos.getMinBlockX(), mc.level.getMinY(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), mc.level.getMaxY(), chunkPos.getMaxBlockZ()));
                box = box.inflate((double)0.01f);
                boxes.add(box);
            }
            AABB box = (AABB)boxes.getFirst();
            for (AABB aabb : boxes) {
                box = box.minmax(aabb);
            }
            AABB aABB = box.inflate((double)0.01f);
            poseStack.pushPose();
            poseStack.translate((float)(-loaderPos.getX()), (float)(-loaderPos.getY()), (float)(-loaderPos.getZ()));
            nodeCollector.submitCustomGeometry(poseStack, ChunkyRenderTypes.CHUNKY_TRANSLUCENT, (pose, vertexConsumer) -> this.renderAABB(vertexConsumer, pose, finalBox));
            poseStack.popPose();
        }
    }

    public void renderAABB(VertexConsumer vertexConsumer, PoseStack.Pose last, AABB box) {
        float red = 1.0f;
        float green = 0.65f;
        float blue = 0.0f;
        float alpha = 0.25f;
        float alphaSide = 0.15f;
        Matrix4f pose = last.pose();
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setNormal(last, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setNormal(last, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setNormal(last, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setNormal(last, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setNormal(last, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setNormal(last, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setNormal(last, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setNormal(last, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setNormal(last, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setNormal(last, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setNormal(last, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setNormal(last, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setNormal(last, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setNormal(last, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setNormal(last, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setNormal(last, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setNormal(last, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setNormal(last, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setNormal(last, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setNormal(last, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setNormal(last, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setNormal(last, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setNormal(last, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setNormal(last, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
    }

    private void renderOutline(SubmitNodeCollector nodeCollector, ChunkLoaderRenderState loaderRenderSTate, PoseStack poseStack) {
        BlockPos loaderPos = loaderRenderSTate.blockPos;
        AABB box = AABB.of((BoundingBox)new BoundingBox(loaderPos));
        box = box.inflate((double)0.01f);
        poseStack.pushPose();
        poseStack.translate((float)(-loaderPos.getX()), (float)(-loaderPos.getY()), (float)(-loaderPos.getZ()));
        float[] onColor = new float[]{1.0f, 0.84313726f, 0.0f, 1.0f};
        float[] offColor = new float[]{0.5f, 0.0f, 0.125f, 1.0f};
        float[] colorToUse = loaderRenderSTate.enabled ? onColor : offColor;
        AABB finalBox = box;
        nodeCollector.submitCustomGeometry(poseStack, ChunkyRenderTypes.CHUNKY_LINE, (pose, vertexConsumer) -> ShapeRenderer.renderLineBox((PoseStack.Pose)pose, (VertexConsumer)vertexConsumer, (AABB)finalBox, (float)colorToUse[0], (float)colorToUse[1], (float)colorToUse[2], (float)colorToUse[3]));
        poseStack.popPose();
    }

    public ChunkLoaderRenderState createRenderState() {
        return new ChunkLoaderRenderState();
    }

    public void extractRenderState(ChunkLoaderBlockEntity blockEntity, ChunkLoaderRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.enabled = blockEntity.isEnabled();
        renderState.range = blockEntity.getRange();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return Minecraft.getInstance().options.getEffectiveRenderDistance() * 16;
    }

    public boolean shouldRender(ChunkLoaderBlockEntity blockEntity, Vec3 pos) {
        return Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)pos.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public AABB getRenderBoundingBox(ChunkLoaderBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

