/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import com.mrbysco.chunkymcchunkface.ChunkyMcChunkFace;
import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class ChunkData
extends SavedData {
    private static final String DATA_NAME = "chunkymcchunkface_data";
    public final Map<ResourceKey<Level>, LongSet> chunkloaderMap = new HashMap<ResourceKey<Level>, LongSet>();
    public final Map<UUID, Long> playerTimeMap;
    public static Codec<LongSet> LONG_SET = Codec.LONG_STREAM.xmap(LongOpenHashSet::toSet, LongCollection::longStream);
    public static final UnboundedMapCodec<ResourceKey<Level>, LongSet> DIMENSION_LOADER_CODEC = Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.DIMENSION), LONG_SET);
    public static final UnboundedMapCodec<UUID, Long> PLAYER_TIME_MAP_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.STRING.xmap(Long::parseLong, String::valueOf));
    public static final Codec<ChunkData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DIMENSION_LOADER_CODEC.fieldOf("ChunkLoaderMap").forGetter(data -> data.chunkloaderMap), (App)PLAYER_TIME_MAP_CODEC.fieldOf("PlayerTimeMap").forGetter(data -> data.playerTimeMap)).apply((Applicative)instance, ChunkData::new));

    public ChunkData(Map<ResourceKey<Level>, LongSet> dimensionLoaderMap, Map<UUID, Long> playerTime) {
        this.chunkloaderMap.putAll(dimensionLoaderMap);
        this.playerTimeMap = new HashMap<UUID, Long>();
        this.playerTimeMap.putAll(playerTime);
    }

    public ChunkData() {
        this(new HashMap<ResourceKey<Level>, LongSet>(), new HashMap<UUID, Long>());
    }

    public void addChunkLoaderPosition(@NotNull Level level, @NotNull BlockPos pos) {
        ResourceKey dimensionLocation = level.dimension();
        LongSet loaderMap = this.chunkloaderMap.getOrDefault(dimensionLocation, (LongSet)new LongOpenHashSet());
        loaderMap.add(pos.asLong());
        this.chunkloaderMap.put((ResourceKey<Level>)dimensionLocation, loaderMap);
        this.setDirty();
    }

    public void removeChunkLoaderPosition(@NotNull Level level, @NotNull BlockPos pos) {
        ResourceKey dimensionLocation = level.dimension();
        LongSet loaderMap = this.chunkloaderMap.getOrDefault(dimensionLocation, (LongSet)new LongOpenHashSet());
        loaderMap.remove(pos.asLong());
        this.chunkloaderMap.put((ResourceKey<Level>)dimensionLocation, loaderMap);
        this.setDirty();
    }

    public List<ChunkPos> getActiveChunkLoaderChunks(@NotNull ServerLevel level) {
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        LongSet loaderPositions = this.chunkloaderMap.getOrDefault(level.dimension(), (LongSet)new LongOpenHashSet());
        LongIterator longIterator = loaderPositions.iterator();
        while (longIterator.hasNext()) {
            BlockState state;
            long posLong = (Long)longIterator.next();
            BlockPos pos = BlockPos.of((long)posLong);
            if (!level.isAreaLoaded(pos, 1) || !(state = level.getBlockState(pos)).is((Block)ChunkyRegistry.CHUNK_LOADER.get()) || !((Boolean)state.getValue((Property)ChunkLoaderBlock.ENABLED)).booleanValue()) continue;
            chunkPosList.add(new ChunkPos(pos));
        }
        return chunkPosList;
    }

    public List<BlockPos> generateList(@NotNull ResourceKey<Level> dimension) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        LongSet chunkLoaderList = this.chunkloaderMap.getOrDefault(dimension, (LongSet)new LongOpenHashSet());
        if (!chunkLoaderList.isEmpty()) {
            chunkLoaderList.forEach(posLong -> positions.add(BlockPos.of((long)posLong)));
        }
        return positions;
    }

    public List<BlockPos> getActivePositions(@NotNull ServerLevel level, @NotNull List<BlockPos> positions) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(positions);
        posList.removeIf(pos -> {
            if (level.isAreaLoaded(pos, 1)) {
                BlockState state = level.getBlockState(pos);
                return !state.is((Block)ChunkyRegistry.CHUNK_LOADER.get()) || (Boolean)state.getValue((Property)ChunkLoaderBlock.ENABLED) == false;
            }
            return true;
        });
        return posList;
    }

    public long getLastSeen(@NotNull UUID uuid) {
        return this.playerTimeMap.getOrDefault(uuid, 0L);
    }

    public void addPlayer(@NotNull UUID uuid, long gameTime) {
        this.playerTimeMap.put(uuid, gameTime);
        this.setDirty();
    }

    public void removePlayer(@NotNull UUID uuid) {
        if (this.playerTimeMap != null) {
            this.playerTimeMap.remove(uuid);
            this.setDirty();
        } else {
            ChunkyMcChunkFace.LOGGER.warn("Attempted to remove a player from the ChunkData, but the playerTimeMap is null.");
        }
    }

    public static SavedDataType<ChunkData> type() {
        return new SavedDataType(DATA_NAME, ChunkData::new, CODEC, null);
    }

    public static ChunkData get(@NotNull Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client level. This is wrong.");
        }
        ServerLevel overworld = level.getServer().overworld();
        DimensionDataStorage storage = overworld.getDataStorage();
        return (ChunkData)storage.computeIfAbsent(ChunkData.type());
    }
}

