/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.client.ChunkyRenderTypes;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ChunkLoaderBER
implements BlockEntityRenderer<ChunkLoaderBlockEntity> {
    public static boolean renderChunkRadius = false;
    public static final int MAX_RENDER_Y = 1024;
    public final Map<Long, Integer> rangeMap = new HashMap<Long, Integer>();

    public ChunkLoaderBER(BlockEntityRendererProvider.Context context) {
    }

    public void render(ChunkLoaderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.getMainHandItem().is((Item)ChunkyRegistry.CHUNK_LOADER_ITEM.get())) {
            this.renderOutline(blockEntity, poseStack, bufferSource);
        }
        if (mc.level != null && renderChunkRadius) {
            List<ChunkPos> list;
            BlockPos loaderPos = blockEntity.getBlockPos();
            long posLong = loaderPos.asLong();
            long centerChunk = new ChunkPos(loaderPos).toLong();
            if (!this.rangeMap.containsKey(posLong)) {
                this.rangeMap.put(posLong, blockEntity.getRange());
            }
            if ((list = ChunkyHelper.generateChunkPosList(centerChunk, blockEntity.getRange()).stream().map(ChunkPos::new).toList()).isEmpty()) {
                return;
            }
            ArrayList<AABB> boxes = new ArrayList<AABB>();
            for (ChunkPos chunkPos : list) {
                AABB box = AABB.of((BoundingBox)new BoundingBox(chunkPos.getMinBlockX(), mc.level.getMinY(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), mc.level.getMaxY(), chunkPos.getMaxBlockZ()));
                box = box.inflate((double)0.01f);
                boxes.add(box);
            }
            AABB box = (AABB)boxes.getFirst();
            for (AABB aabb : boxes) {
                box = box.minmax(aabb);
            }
            box = box.inflate((double)0.01f);
            VertexConsumer vertexConsumer = bufferSource.getBuffer(ChunkyRenderTypes.CHUNKY_TRANSLUCENT);
            poseStack.pushPose();
            poseStack.translate((float)(-loaderPos.getX()), (float)(-loaderPos.getY()), (float)(-loaderPos.getZ()));
            this.renderAABB(vertexConsumer, poseStack, box);
            poseStack.popPose();
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)bufferSource).endBatch();
            }
        }
    }

    public void renderAABB(VertexConsumer vertexConsumer, PoseStack poseStack, AABB box) {
        float red = 1.0f;
        float green = 0.65f;
        float blue = 0.0f;
        float alpha = 0.25f;
        float alphaSide = 0.15f;
        poseStack.pushPose();
        PoseStack.Pose matrixLast = poseStack.last();
        Matrix4f pose = matrixLast.pose();
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setNormal(matrixLast, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setNormal(matrixLast, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setNormal(matrixLast, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setNormal(matrixLast, 0.0f, 1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setNormal(matrixLast, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setNormal(matrixLast, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setNormal(matrixLast, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setNormal(matrixLast, 0.0f, -1.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setNormal(matrixLast, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setNormal(matrixLast, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setNormal(matrixLast, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setNormal(matrixLast, 0.0f, 0.0f, 1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setNormal(matrixLast, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setNormal(matrixLast, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setNormal(matrixLast, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setNormal(matrixLast, 0.0f, 0.0f, -1.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setNormal(matrixLast, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setNormal(matrixLast, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setNormal(matrixLast, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setNormal(matrixLast, 1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setNormal(matrixLast, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setNormal(matrixLast, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setNormal(matrixLast, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        vertexConsumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setNormal(matrixLast, -1.0f, 0.0f, 0.0f).setColor(red, green, blue, alphaSide);
        poseStack.popPose();
    }

    private void renderOutline(ChunkLoaderBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockPos loaderPos = blockEntity.getBlockPos();
        VertexConsumer builder = bufferSource.getBuffer(ChunkyRenderTypes.CHUNKY_LINE);
        AABB box = AABB.of((BoundingBox)new BoundingBox(loaderPos));
        box = box.inflate((double)0.01f);
        poseStack.pushPose();
        poseStack.translate((float)(-loaderPos.getX()), (float)(-loaderPos.getY()), (float)(-loaderPos.getZ()));
        float[] onColor = new float[]{1.0f, 0.84313726f, 0.0f, 1.0f};
        float[] offColor = new float[]{0.5f, 0.0f, 0.125f, 1.0f};
        float[] colorToUse = blockEntity.isEnabled() ? onColor : offColor;
        ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)builder, (AABB)box, (float)colorToUse[0], (float)colorToUse[1], (float)colorToUse[2], (float)colorToUse[3]);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource1 = (MultiBufferSource.BufferSource)bufferSource;
            bufferSource1.endBatch(ChunkyRenderTypes.CHUNKY_LINE);
        }
        poseStack.popPose();
    }

    public boolean shouldRender(ChunkLoaderBlockEntity blockEntity, Vec3 pos) {
        return Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)pos.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(ChunkLoaderBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, 1024.0, (double)pos.getZ() + 1.0);
    }

    public int getViewDistance() {
        return 128;
    }
}

