/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.data.ChunkData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class ChunkyCommands {
    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder root = Commands.literal((String)"chunkymcchunkface");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(source -> source.hasPermission(2))).then(Commands.literal((String)"list").then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> this.generateList((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.literal((String)"enabled").executes(ctx -> this.generateList((CommandContext<CommandSourceStack>)ctx, true)))))).then(Commands.literal((String)"disable").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).suggests((context, builder) -> {
            ServerLevel dimensionLevel = DimensionArgument.getDimension((CommandContext)context, (String)"dimension");
            return SharedSuggestionProvider.suggest(ChunkyCommands.getActivePositions(dimensionLevel), (SuggestionsBuilder)builder);
        }).executes(ChunkyCommands::disableChunkLoader))))).then(Commands.literal((String)"disable_all").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ChunkyCommands::disableAllChunkLoaders)));
        dispatcher.register(root);
    }

    protected static List<String> getActivePositions(ServerLevel dimensionLevel) {
        ResourceKey dimension = dimensionLevel.dimension();
        ChunkData data = ChunkData.get((Level)dimensionLevel);
        List<BlockPos> positions = data.getActivePositions(dimensionLevel, data.generateList((ResourceKey<Level>)dimension));
        return positions.stream().map(pos -> pos.getX() + " " + pos.getY() + " " + pos.getZ()).toList();
    }

    private int generateList(CommandContext<CommandSourceStack> ctx, boolean enabledOnly) throws CommandSyntaxException {
        ServerLevel dimensionLevel = DimensionArgument.getDimension(ctx, (String)"dimension");
        ResourceKey dimension = dimensionLevel.dimension();
        ChunkData data = ChunkData.get((Level)dimensionLevel);
        List<BlockPos> positions = data.generateList((ResourceKey<Level>)dimension);
        if (enabledOnly) {
            positions = data.getActivePositions(dimensionLevel, positions);
        }
        if (positions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"chunkymcchunkface.command.list.empty", (Object[])new Object[]{Component.literal((String)dimension.toString()).withStyle(ChatFormatting.RED)}), true);
        } else {
            MutableComponent formattedComponent = Component.literal((String)"\n");
            MutableComponent component = Component.literal((String)", ").withStyle(ChatFormatting.WHITE);
            for (int i = 0; i < positions.size(); ++i) {
                BlockPos pos = positions.get(i);
                MutableComponent position = ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)pos.toShortString())).withStyle(style -> style.withColor(ChatFormatting.GOLD).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"chat.coordinates.tooltip"))));
                formattedComponent.append((Component)position);
                if (i >= positions.size() - 1) continue;
                formattedComponent.append((Component)component);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"chunkymcchunkface.command.list", (Object[])new Object[]{Component.literal((String)dimension.toString()).withStyle(ChatFormatting.GOLD)}).append((Component)formattedComponent), true);
        }
        return 0;
    }

    private static int disableChunkLoader(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Vec3 pos;
        ServerLevel dimensionLevel = DimensionArgument.getDimension(ctx, (String)"dimension");
        BlockEntity blockEntity = dimensionLevel.getBlockEntity(BlockPos.containing((Position)(pos = Vec3Argument.getVec3(ctx, (String)"position"))));
        if (blockEntity instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity loader = (ChunkLoaderBlockEntity)blockEntity;
            loader.disableChunkLoaderState();
            loader.disableChunkLoader();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"chunkymcchunkface.command.disable", (Object[])new Object[]{pos.x, pos.y, pos.z}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"chunkymcchunkface.command.disable.error", (Object[])new Object[]{pos.x, pos.y, pos.z}), true);
        }
        return 0;
    }

    private static int disableAllChunkLoaders(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel dimensionLevel = DimensionArgument.getDimension(ctx, (String)"dimension");
        ResourceKey dimension = dimensionLevel.dimension();
        ChunkData data = ChunkData.get((Level)dimensionLevel);
        List<BlockPos> positions = data.getActivePositions(dimensionLevel, data.generateList((ResourceKey<Level>)dimension));
        MutableComponent dimensionComponent = Component.literal((String)dimension.toString()).withStyle(ChatFormatting.GOLD);
        if (positions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"chunkymcchunkface.command.disableall.empty", (Object[])new Object[]{dimensionComponent}), true);
        } else {
            for (BlockPos pos : positions) {
                BlockEntity blockEntity = dimensionLevel.getBlockEntity(new BlockPos((Vec3i)pos));
                if (!(blockEntity instanceof ChunkLoaderBlockEntity)) continue;
                ChunkLoaderBlockEntity loader = (ChunkLoaderBlockEntity)blockEntity;
                loader.disableChunkLoaderState();
                loader.disableChunkLoader();
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"chunkymcchunkface.command.disableall", (Object[])new Object[]{dimensionComponent}), true);
        }
        return 0;
    }
}

