/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.compat.jade;

import com.mrbysco.chunkymcchunkface.ChunkyMcChunkFace;
import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.config.ChunkyConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation SHOW_TIME = ChunkyMcChunkFace.modLoc("show_time");

    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(SHOW_TIME, true);
        registration.registerBlockComponent((IComponentProvider)ChunkLoaderTimeProvider.INSTANCE, ChunkLoaderBlock.class);
    }

    public static enum ChunkLoaderTimeProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
            ChunkLoaderBlockEntity blockEntity;
            BlockEntity blockEntity2;
            if (pluginConfig.get(SHOW_TIME) && (blockEntity2 = blockAccessor.getBlockEntity()) instanceof ChunkLoaderBlockEntity && (blockEntity = (ChunkLoaderBlockEntity)blockEntity2).isEnabled()) {
                if (blockEntity.getPlayerOnlineCache()) {
                    tooltip.add((Component)Component.translatable((String)"chunkymcchunkface.waila.time.online"));
                } else {
                    int configuredTicks = (Integer)ChunkyConfig.COMMON.offlineTime.get();
                    if (configuredTicks != 0) {
                        long lastSeen = blockEntity.getLastSeenCache();
                        long ticksActive = blockEntity.getLevel().getGameTime() - lastSeen;
                        int ticksLeft = configuredTicks - (int)ticksActive;
                        int seconds = ticksLeft / 20;
                        tooltip.add((Component)Component.translatable((String)"chunkymcchunkface.waila.time.remaining", (Object[])new Object[]{seconds}));
                    } else {
                        tooltip.add((Component)Component.translatable((String)"chunkymcchunkface.waila.time.disabled"));
                    }
                }
            }
        }

        public ResourceLocation getUid() {
            return SHOW_TIME;
        }
    }
}

