/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.datagen.assets;

import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class ChunkyLanguageProvider
extends LanguageProvider {
    public ChunkyLanguageProvider(PackOutput packOutput) {
        super(packOutput, "chunkymcchunkface", "en_us");
    }

    protected void addTranslations() {
        this.addBlock((Supplier)ChunkyRegistry.CHUNK_LOADER, "Chunky McChunkFace");
        this.add("chunkymcchunkface.command.list", "Chunk loaders in dimension <%s>");
        this.add("chunkymcchunkface.command.list.empty", "No known Chunk loaders located in <%s>");
        this.add("chunkymcchunkface.command.disable", "Disabled chunk loader at position %s %s %s");
        this.add("chunkymcchunkface.command.disable.error", "Something went wrong while disabling the chunk loader at position %s %s %s");
        this.add("chunkymcchunkface.command.disableall", "Disabled all active chunk loaders in dimension <%s>");
        this.add("chunkymcchunkface.command.disableall.empty", "Unable to chunk loaders as there are no known active chunk loaders in dimension <%s>");
        this.add("chunkymcchunkface.shift.text", "Hold SHIFT for more information");
        this.add("chunkymcchunkface.extend.text", "Expand the loaded area by building a pyramid of allowed blocks beneath the chunk loader");
        this.add("chunkymcchunkface.blocks.text", "An example of an allowed block is %s");
        this.add("key.chunkymcchunkface.category", "Chunky McChunkFace");
        this.add("key.chunkymcchunkface.show_bounds", "Show Chunk Loader Radius");
        this.add("config.jade.plugin_chunkymcchunkface.show_time", "Show time left");
        this.add("chunkymcchunkface.waila.time.online", "Player is online, timer is not active");
        this.add("chunkymcchunkface.waila.time.remaining", "Time left: %s second(s)");
        this.add("chunkymcchunkface.waila.time.disabled", "Timer has been disabled in config");
        this.addConfig("Range", "Range", "Range Settings");
        this.addConfig("baseRange", "Base Range", "The base range around the chunk loader that will be loaded (0 = 1 chunk only) [default: 0]");
        this.addConfig("tier1Range", "Tier 1 Range", "The range of a tier 1 chunk loader (1 = 3x3) [default: 1]");
        this.addConfig("tier2Range", "Tier 2 Range", "The range of a tier 2 chunk loader (2 = 5x5) [default: 2]");
        this.addConfig("tier3Range", "Tier 3 Range", "The range of a tier 3 chunk loader (3 = 7x7) [default: 3]");
        this.addConfig("tier4Range", "Tier 4 Range", "The range of a tier 4 chunk loader (4 = 9x9) [default: 4]");
        this.addConfig("time", "Time", "Time Settings");
        this.addConfig("offlineTime", "Offline Time", "The time in ticks that the chunk loader will stay loaded after all players that interacted with it have gone offline (168000 = 7 in-game days worth of time (140 minutes)) [default: 168000]");
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("chunkymcchunkface.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("chunkymcchunkface.configuration." + path + ".tooltip", description);
        }
    }
}

