/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.datagen.data;

import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class ChunkyLootProvider
extends LootTableProvider {
    public ChunkyLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ChunkyBlockLoot::new, LootContextParamSets.BLOCK)), completableFuture);
    }

    protected void validate(WritableRegistry<LootTable> writableRegistry, ValidationContext validationContext, ProblemReporter.Collector collector) {
        super.validate(writableRegistry, validationContext, collector);
    }

    public static class ChunkyBlockLoot
    extends BlockLootSubProvider {
        protected ChunkyBlockLoot(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            this.dropSelf((Block)ChunkyRegistry.CHUNK_LOADER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return ChunkyRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

