/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.item;

import com.mrbysco.chunkymcchunkface.registry.ChunkyTags;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;

public class ChunkLoaderItem
extends BlockItem {
    public ChunkLoaderItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.literal((String)"Chunk Loader").withStyle(ChatFormatting.YELLOW));
        tooltipAdder.accept((Component)Component.literal((String)" "));
        if (Screen.hasShiftDown()) {
            HolderSet.Named tag;
            tooltipAdder.accept((Component)Component.translatable((String)"chunkymcchunkface.extend.text").withStyle(ChatFormatting.GOLD));
            Optional optionalTag = BuiltInRegistries.BLOCK.get(ChunkyTags.UPGRADE_BLOCKS);
            if (optionalTag.isPresent() && (tag = (HolderSet.Named)optionalTag.get()).size() > 0) {
                int index = (int)(System.currentTimeMillis() / 1000L % (long)tag.size());
                Block randomBlock = (Block)((Holder)tag.stream().toList().get(index)).value();
                MutableComponent blockName = Component.translatable((String)randomBlock.getDescriptionId()).withStyle(ChatFormatting.WHITE);
                tooltipAdder.accept((Component)Component.translatable((String)"chunkymcchunkface.blocks.text", (Object[])new Object[]{blockName}).withStyle(ChatFormatting.GREEN));
            }
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"chunkymcchunkface.shift.text").withStyle(ChatFormatting.GRAY));
        }
    }
}

