/*
 * Decompiled with CFR 0.152.
 */
package rats.entity.goal;

import java.util.EnumSet;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import rats.entity.RatEntity;

public class WorkGoal
extends class_1352 {
    private final RatEntity mob;
    private TaskType type;
    private int cooldown;
    private class_2338 target;
    private int tryingTime;

    public WorkGoal(RatEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (--this.cooldown > 0) {
            return false;
        }
        this.cooldown = 200;
        class_1799 stack = this.mob.method_6047();
        if (stack.method_31574(class_1802.field_8825)) {
            this.type = TaskType.FOREST;
        } else if (stack.method_31573(class_3489.field_42614)) {
            this.type = TaskType.MINE;
        } else if (stack.method_7960() || stack.method_31573(RatEntity.EATABLE) && stack.method_7947() < stack.method_7914()) {
            this.type = TaskType.FARM;
        } else {
            return false;
        }
        int maxRadius = this.type == TaskType.MINE ? 16 : 8;
        int minY = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> -1;
            case 2 -> -2;
        };
        int maxY = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 1;
            case 1 -> 5;
            case 2 -> 3;
        };
        for (int r = 1; r <= maxRadius; ++r) {
            for (int y = minY; y <= maxY; ++y) {
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dz = -r; dz <= r; ++dz) {
                        if (Math.abs(dx) != r && Math.abs(dz) != r) continue;
                        this.target = this.mob.method_24515().method_10069(dx, y, dz);
                        if (!this.isValidTarget()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void method_6269() {
        this.tryingTime = -1;
    }

    public boolean method_6266() {
        return this.tryingTime <= 1200 && this.isValidTarget();
    }

    public void method_6268() {
        class_1937 world = this.mob.method_37908();
        class_243 mobPos = this.mob.method_19538();
        if (this.target.method_19770((class_2374)mobPos) > 9.0 || this.type == TaskType.FOREST && this.target.method_10263() == this.mob.method_31477() && this.target.method_10260() == this.mob.method_31479() && Math.abs(this.target.method_10264() - this.mob.method_31478()) < 10) {
            if (this.tryingTime++ % 40 == 0) {
                this.mob.method_5942().method_6337((double)this.target.method_10263() + 0.5, (double)this.target.method_10264(), (double)this.target.method_10260() + 0.5, 1.0);
            }
        } else {
            class_2680 state = world.method_8320(this.target);
            world.method_20290(2001, this.target, class_2248.method_9507((class_2680)state));
            class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)this.target, null, (class_1297)this.mob, (class_1799)this.mob.method_6047());
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 crop = (class_2302)class_22482;
                class_2680 replanted = crop.method_9828(0);
                world.method_8652(this.target, replanted, 3);
                world.method_43276((class_6880)class_5712.field_28733, this.target, class_5712.class_7397.method_43286((class_1297)this.mob, (class_2680)replanted));
            } else {
                this.mob.method_6047().method_7956(1, (class_3218)world, null, item -> this.mob.method_20235((class_1792)item, class_1304.field_6173));
                if (world.method_8652(this.target, class_2246.field_10124.method_9564(), 3)) {
                    world.method_43276((class_6880)class_5712.field_28165, this.target, class_5712.class_7397.method_43286((class_1297)this.mob, (class_2680)state));
                }
                this.target = this.target.method_10084();
            }
            this.cooldown = 0;
            if (this.isValidTarget() || this.method_6264()) {
                this.method_6269();
            } else {
                this.tryingTime = 1200;
            }
        }
    }

    private boolean isValidTarget() {
        class_2680 state = this.mob.method_37908().method_8320(this.target);
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                class_2302 crop;
                class_2248 var3_2 = state.method_26204();
                if (var3_2 instanceof class_2302 && (crop = (class_2302)var3_2).method_9825(state)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (state.method_26164(class_3481.field_15475) && this.isAccessible(this.target)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> state.method_26164(ConventionalBlockTags.ORES) && this.isAccessible(this.target);
        };
    }

    private boolean isAccessible(class_2338 pos) {
        return this.mob.method_5942().method_6348(pos, 3) != null;
    }

    public static enum TaskType {
        FARM,
        FOREST,
        MINE;

    }
}

