/*
 * Decompiled with CFR 0.152.
 */
package com.blockninja.shush.shush;

import com.blockninja.shush.shush.Shush;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class LineInterceptingOutputStream
extends OutputStream {
    private final OutputStream original;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public LineInterceptingOutputStream(OutputStream original) {
        this.original = original;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10) {
            String line = this.buffer.toString(StandardCharsets.UTF_8);
            this.buffer.reset();
            if (!Shush.shouldSuppress(line)) {
                this.original.write(line.getBytes(StandardCharsets.UTF_8));
                this.original.write(10);
            }
        } else {
            this.buffer.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.size() > 0) {
            String line = this.buffer.toString(StandardCharsets.UTF_8);
            this.buffer.reset();
            if (!Shush.shouldSuppress(line)) {
                this.original.write(line.getBytes(StandardCharsets.UTF_8));
                this.original.write(10);
            }
        }
        this.original.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.original.close();
    }
}

