/*
 * Decompiled with CFR 0.152.
 */
package com.blockninja.shush.shush;

import com.blockninja.shush.shush.ConditionalFilter;
import com.blockninja.shush.shush.Config;
import com.blockninja.shush.shush.LineInterceptingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;

@Mod(value="shush")
public class Shush {
    public static final String MODID = "shush";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static PrintStream originalOut;

    public Shush(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::onCommonSetup);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)Config.SPEC);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            LOGGER.info("Adding custom log filter");
            this.registerConsoleAppender();
            LOGGER.info("Finished adding filter");
            LOGGER.info("Adding custom System.out");
            this.registerSystemOutStream();
            LOGGER.info("Finished adding custom System.out");
        });
    }

    private void registerConsoleAppender() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        HashMap appenders = new HashMap(config.getAppenders());
        PatternLayout layout = null;
        for (Appender appender : appenders.values()) {
            PatternLayout patternLayout;
            Layout tempLayout = appender.getLayout();
            if (!(tempLayout instanceof PatternLayout)) continue;
            layout = patternLayout = (PatternLayout)tempLayout;
        }
        ConditionalFilter filter = new ConditionalFilter(layout);
        config.getRootLogger().addFilter((Filter)filter);
        context.updateLoggers();
    }

    private void registerSystemOutStream() {
        originalOut = System.out;
        PrintStream customOut = new PrintStream(new LineInterceptingOutputStream(System.out), true);
        System.setOut(customOut);
    }

    public static boolean shouldSuppress(String message) {
        if (Config.regexPattern == null) {
            return false;
        }
        Matcher matcher = Config.regexPattern.matcher(message);
        return matcher.find();
    }

    public void onConfigLoad(ModConfigEvent event) {
        Config.regexPattern = null;
        if (((List)Config.MATCHED_LOGS.get()).isEmpty() && ((List)Config.BASIC_MATCHED_LOGS.get()).isEmpty()) {
            LOGGER.info("No logs set to intercept");
            return;
        }
        StringBuilder fullRegex = new StringBuilder("(");
        boolean firstTime = true;
        for (String item : (List)Config.MATCHED_LOGS.get()) {
            try {
                Pattern.compile(item);
                if (!firstTime) {
                    fullRegex.append("|(");
                }
                firstTime = false;
                fullRegex.append(item).append(")");
            }
            catch (PatternSyntaxException e) {
                LOGGER.warn("Warning: invalid regex '" + item + "', ignoring. " + e.getMessage());
            }
        }
        for (String basicItem : (List)Config.BASIC_MATCHED_LOGS.get()) {
            String basicItemEscaped = Pattern.quote(basicItem);
            if (!firstTime) {
                fullRegex.append("|(");
            }
            firstTime = false;
            fullRegex.append(basicItemEscaped).append(")");
        }
        String lastChar = fullRegex.substring(fullRegex.toString().length() - 1);
        if (lastChar.equals("(")) {
            return;
        }
        Config.regexPattern = Pattern.compile(fullRegex.toString());
        LOGGER.info("Log filters ready");
    }
}

