/*
 * Decompiled with CFR 0.152.
 */
package com.miningworld;

import com.miningworld.CustomOreConfig;
import com.miningworld.MiningWorld;
import com.miningworld.OreConfigLoader;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GlobalOreFeature
extends Feature<NoneFeatureConfiguration> {
    public static RandomSource random = new LegacyRandomSource(new Random().nextLong());

    public GlobalOreFeature(Codec<NoneFeatureConfiguration> p_65786_) {
        super(p_65786_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.level();
        BlockPos origin = ctx.origin();
        ChunkPos chunkpos = new ChunkPos(origin);
        if (level.getLevel().dimension().location() == MiningWorld.MINING.location()) {
            for (CustomOreConfig config : OreConfigLoader.ORES.values()) {
                if (random.nextDouble() > config.chance()) continue;
                int veins = Mth.nextInt((RandomSource)random, (int)config.minVeins(), (int)config.maxVeins());
                for (int i = 0; i < veins; ++i) {
                    int x = origin.getX() + random.nextInt(16);
                    int y = Mth.nextInt((RandomSource)random, (int)config.minHeight(), (int)config.maxHeight());
                    int z = origin.getZ() + random.nextInt(16);
                    BlockPos pos = new BlockPos(x, y, z);
                    int veinSize = Mth.nextInt((RandomSource)random, (int)config.minVeinSize(), (int)config.maxVeinSize());
                    for (int j = 0; j < veinSize; ++j) {
                        BlockPos target = pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1);
                        BlockState blockstate = level.getBlockState(target);
                        if (!blockstate.is(config.replaceBlock())) continue;
                        level.setBlock(target, config.oreBlock().defaultBlockState(), 3);
                    }
                }
            }
        }
        return true;
    }
}

