/*
 * Decompiled with CFR 0.152.
 */
package com.miningworld;

import com.miningworld.BiomeData;
import com.miningworld.ConfiguredFeaturesGen;
import com.miningworld.GlobalOreFeature;
import com.miningworld.ItemPortalMiningWorld;
import com.miningworld.ModPlacedFeatures;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="miningworld")
public class MiningWorld {
    private static MiningWorld instance;
    public static DeferredRegister<Feature<?>> FEATURES;
    public static DeferredRegister<Item> ITEMS;
    public static final ResourceKey<BiomeModifier> ADD_FEATURES;
    public static final ResourceKey<DimensionType> MINING_DIM_TYPE;
    public static final ResourceKey<Biome> BIOME_KEY;
    public static final ResourceKey<LevelStem> MINING;
    private static final RegistrySetBuilder BUILDER;
    public static DeferredHolder<Feature<?>, GlobalOreFeature> global_ores;
    public static DeferredHolder<Item, ItemPortalMiningWorld> portalItem;
    public static boolean hasFeature;
    public static List<ChunkAccess> chunkAccessList;

    public MiningWorld(ModContainer container, IEventBus eventBus) {
        FEATURES.register(eventBus);
        global_ores = FEATURES.register("global_ores", () -> new GlobalOreFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
        eventBus.addListener(this::gatherData);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ResourceKey dimension = event.getLevel().dimension();
        if (!dimension.location().getNamespace().equals("miningworld")) {
            return;
        }
        int maxPerTick = 4;
        for (int processed = 0; !chunkAccessList.isEmpty() && processed < maxPerTick; ++processed) {
            ChunkAccess chunkAccess = chunkAccessList.removeFirst();
            ChunkGenerator generator = level2.getChunkSource().getGenerator();
            BlockPos pos = new BlockPos(chunkAccess.getPos().x * 16, 50, chunkAccess.getPos().z * 16);
            ((GlobalOreFeature)((Object)global_ores.get())).place((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(null, (WorldGenLevel)level2, generator, event.getLevel().random, pos, null));
        }
    }

    @SubscribeEvent
    public void registerChunks(ChunkEvent.Load event) {
        ResourceKey dimension = event.getChunk().getLevel().dimension();
        if (!dimension.location().getNamespace().equals("miningworld")) {
            return;
        }
        if (event.isNewChunk()) {
            chunkAccessList.add(event.getChunk());
        }
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), BUILDER, Set.of("miningworld")));
    }

    static {
        FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"miningworld");
        ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"miningworld");
        ADD_FEATURES = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"miningworld", (String)"global_ores"));
        MINING_DIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.tryBuild((String)"miningworld", (String)"digging_dimension_type"));
        BIOME_KEY = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.tryBuild((String)"miningworld", (String)"digging_biome"));
        MINING = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ResourceLocation.tryBuild((String)"miningworld", (String)"digging_dimension"));
        BUILDER = new RegistrySetBuilder().add(Registries.DIMENSION_TYPE, ctx -> ctx.register(MINING_DIM_TYPE, (Object)new DimensionType(OptionalLong.empty(), true, false, true, true, 1.0, true, true, -64, 256, 256, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.OVERWORLD_EFFECTS, 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)Optional.of(UniformInt.of((int)0, (int)7)).get(), 0)))).add(Registries.CONFIGURED_FEATURE, ConfiguredFeaturesGen::bootstrap).add(Registries.PLACED_FEATURE, ModPlacedFeatures::bootstrap).add(Registries.BIOME, BiomeData::bootstrap).add(Registries.LEVEL_STEM, ctx -> {
            HolderGetter dimTypes = ctx.lookup(Registries.DIMENSION_TYPE);
            HolderGetter biomes = ctx.lookup(Registries.BIOME);
            HolderGetter features = ctx.lookup(Registries.PLACED_FEATURE);
            Holder.Reference biome = biomes.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.tryBuild((String)"miningworld", (String)"digging_biome")));
            List<Holder.Reference> featureList = List.of(features.getOrThrow(ModPlacedFeatures.GLOBAL_ORES_PLACED));
            FlatLevelGeneratorSettings flatSettings = new FlatLevelGeneratorSettings(Optional.empty(), (Holder)biome, featureList);
            flatSettings.getLayersInfo().add(new FlatLayerInfo(1, Blocks.BEDROCK));
            flatSettings.getLayersInfo().add(new FlatLayerInfo(62, Blocks.DEEPSLATE));
            flatSettings.getLayersInfo().add(new FlatLayerInfo(76, Blocks.STONE));
            flatSettings.getLayersInfo().add(new FlatLayerInfo(1, Blocks.GRASS_BLOCK));
            FlatLevelSource generator = new FlatLevelSource(flatSettings);
            ctx.register(MINING, (Object)new LevelStem((Holder)dimTypes.getOrThrow(MINING_DIM_TYPE), (ChunkGenerator)generator));
        }).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, bootstrap -> {
            HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
            HolderGetter placedFeatures = bootstrap.lookup(Registries.PLACED_FEATURE);
            bootstrap.register(ADD_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.tryBuild((String)"miningworld", (String)"digging_biome")))}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.GLOBAL_ORES_PLACED)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        });
        chunkAccessList = new LinkedList<ChunkAccess>();
    }

    @EventBusSubscriber(modid="miningworld")
    public static class Commands {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"digdim").executes(context -> {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                ResourceKey dimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryBuild((String)"miningworld", (String)"digging_dimension"));
                ServerLevel target = player.getServer().getLevel(dimKey);
                if (target == null) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Dimension not found"));
                    return 0;
                }
                if (player.level().dimension() != dimKey) {
                    player.teleportTo(target, 0.5, 77.0, 0.5, player.getYRot(), player.getXRot());
                } else {
                    target = player.getServer().getLevel(Level.OVERWORLD);
                    int height = target.getHeight(Heightmap.Types.WORLD_SURFACE, 0, 0);
                    player.teleportTo(target, 0.5, (double)height, 0.5, player.getYRot(), player.getXRot());
                }
                return 1;
            }));
        }
    }
}

