/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.custom;

import net.alminoris.aestheticstorage.block.entity.CabinetBlockEntity;
import net.alminoris.aestheticstorage.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CabinetBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public final boolean HAS_FLIP;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);

    public CabinetBlock(BlockBehaviour.Properties properties, boolean hasFlip) {
        super(properties.m_60955_());
        this.HAS_FLIP = hasFlip;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT, OPEN, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CabinetBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return CabinetBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.CABINET_BLOCK_ENTITY.get()), (world, pos, blockState, entity) -> entity.tick(world, pos, blockState));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.updateCabinetVariant(state, level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CabinetBlockEntity) {
                CabinetBlockEntity cabinet = (CabinetBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)cabinet);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
                Variant variant = (Variant)((Object)state.m_61143_(VARIANT));
                if (this.HAS_FLIP) {
                    level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL)), 3);
                } else if (variant == Variant.LEFT) {
                    level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT)), 3);
                } else {
                    level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            Variant variant = (Variant)((Object)state.m_61143_(VARIANT));
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            if (open && !level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof CabinetBlockEntity) {
                    CabinetBlockEntity cabinet = (CabinetBlockEntity)blockEntity;
                    NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)cabinet, (BlockPos)pos);
                }
            }
            boolean bl = open = !open;
            if (this.HAS_FLIP) {
                boolean isLeft;
                boolean isRight = variant == Variant.RIGHT;
                boolean bl2 = isLeft = variant == Variant.LEFT;
                BlockPos otherPos = isRight ? pos.m_142300_(facing.m_122428_()) : (isLeft ? pos.m_142300_(facing.m_122427_()) : pos);
                BlockState otherState = level.m_8055_(otherPos);
                if (otherState.m_60734_() == this && otherState.m_61143_((Property)FACING) == facing && otherState.m_61143_(VARIANT) != variant) {
                    level.m_7731_(otherPos, (BlockState)otherState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        super.m_6807_(state, level, pos, oldState, notify);
        this.updateSurroundingCabinets(level, pos);
    }

    private void updateSurroundingCabinets(Level level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_142300_(dir);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (neighborState.m_60734_() != this) continue;
            level.m_7731_(neighborPos, this.updateCabinetVariant(neighborState, (LevelAccessor)level, neighborPos), 3);
        }
    }

    private BlockState updateCabinetVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_142300_(facing.m_122428_());
        BlockPos rightPos = pos.m_142300_(facing.m_122427_());
        boolean leftConnected = this.isCabinet(world, leftPos, facing);
        boolean rightConnected = this.isCabinet(world, rightPos, facing);
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isCabinet(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

