/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.menu;

import java.util.ArrayList;
import java.util.HashSet;
import net.alminoris.aestheticstorage.block.custom.HalfcupboardBlock;
import net.alminoris.aestheticstorage.block.entity.HalfcupboardBlockEntity;
import net.alminoris.aestheticstorage.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HalfcupboardMenu
extends AbstractContainerMenu {
    private final HalfcupboardBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public HalfcupboardMenu(int containerId, Inventory playerInventory, HalfcupboardBlockEntity blockEntity) {
        super((MenuType)ModMenus.HALFCUPBOARD_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_183503_(), (BlockPos)blockEntity.m_58899_());
        int l = 0;
        for (int i = 1; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.m_38897_(new Slot((Container)blockEntity, l++, 53 + i * 18, 27 + j * 18));
            }
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public HalfcupboardMenu(int containerId, Inventory playerInventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, playerInventory, (HalfcupboardBlockEntity)playerInventory.f_35978_.m_183503_().m_7702_(friendlyByteBuf.m_130135_()));
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity != null && this.blockEntity.m_6542_(player);
    }

    public void m_6877_(Player player) {
        BlockPos startPos;
        super.m_6877_(player);
        if (player.m_183503_().f_46443_) {
            return;
        }
        Level world = player.m_183503_();
        BlockState startState = world.m_8055_(startPos = this.blockEntity.m_58899_());
        if (!(startState.m_60734_() instanceof HalfcupboardBlock)) {
            return;
        }
        Direction facing = (Direction)startState.m_61143_((Property)HalfcupboardBlock.FACING);
        ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.add(startPos);
        while (!stack.isEmpty()) {
            BlockState currentState;
            BlockPos currentPos = (BlockPos)stack.remove(stack.size() - 1);
            if (!visited.add(currentPos) || !((currentState = world.m_8055_(currentPos)).m_60734_() instanceof HalfcupboardBlock) || currentState.m_61143_((Property)HalfcupboardBlock.FACING) != facing) continue;
            HalfcupboardBlock.Variant currentVariant = (HalfcupboardBlock.Variant)((Object)currentState.m_61143_(HalfcupboardBlock.VARIANT));
            if (currentVariant == HalfcupboardBlock.Variant.UP || currentVariant == HalfcupboardBlock.Variant.DOWN || currentVariant == HalfcupboardBlock.Variant.CENTER) {
                if (((Boolean)currentState.m_61143_((Property)HalfcupboardBlock.OPEN)).booleanValue()) {
                    world.m_7731_(currentPos, (BlockState)currentState.m_61124_((Property)HalfcupboardBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                }
                stack.add(currentPos.m_7494_());
                stack.add(currentPos.m_7495_());
                continue;
            }
            if (currentVariant != HalfcupboardBlock.Variant.NORMAL || !((Boolean)currentState.m_61143_((Property)HalfcupboardBlock.OPEN)).booleanValue()) continue;
            world.m_7731_(currentPos, (BlockState)currentState.m_61124_((Property)HalfcupboardBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack original = slot.m_7993_();
            newStack = original.m_41777_();
            int containerSlots = this.blockEntity.m_6643_();
            int totalSlots = this.f_38839_.size();
            if (index < containerSlots ? !this.m_38903_(original, containerSlots, totalSlots, true) : !this.m_38903_(original, 0, containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (original.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

