/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.alminoris.aestheticstorage.block.custom.CupboardBlock;
import net.alminoris.aestheticstorage.block.entity.CupboardBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class CupboardBlockEntityRenderer
implements BlockEntityRenderer<CupboardBlockEntity> {
    public CupboardBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CupboardBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        List<ItemStack> stacks = entity.getRenderStack();
        if (stacks.isEmpty() || entity.m_58904_() == null) {
            return;
        }
        Direction facing = (Direction)entity.m_58900_().m_61143_((Property)CupboardBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        switch (facing) {
            case NORTH: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            }
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        int counter = 0;
        for (ItemStack stack : stacks) {
            poseStack.m_85836_();
            switch (counter) {
                case 0: {
                    poseStack.m_85837_(0.25, (double)0.65f, 0.25);
                    break;
                }
                case 1: {
                    poseStack.m_85837_(0.75, (double)0.65f, 0.25);
                    break;
                }
                case 2: {
                    poseStack.m_85837_(0.25, (double)0.65f, 0.75);
                    break;
                }
                case 3: {
                    poseStack.m_85837_(0.75, (double)0.65f, 0.75);
                    break;
                }
                case 4: {
                    poseStack.m_85837_(0.25, (double)0.2f, 0.25);
                    break;
                }
                case 5: {
                    poseStack.m_85837_(0.75, (double)0.2f, 0.25);
                    break;
                }
                case 6: {
                    poseStack.m_85837_(0.25, (double)0.2f, 0.75);
                    break;
                }
                case 7: {
                    poseStack.m_85837_(0.75, (double)0.2f, 0.75);
                }
            }
            poseStack.m_85841_(0.25f, 0.25f, 0.25f);
            itemRenderer.m_174269_(stack, ItemTransforms.TransformType.GUI, this.getLightLevel(entity.m_58904_(), entity.m_58899_()), OverlayTexture.f_118083_, poseStack, bufferSource, 0);
            poseStack.m_85849_();
            ++counter;
        }
        poseStack.m_85849_();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int blockLight = level.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }
}

