/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.alminoris.aestheticstorage.block.entity.CupboardBlockEntity;
import net.alminoris.aestheticstorage.block.entity.ModBlockEntities;
import net.alminoris.aestheticstorage.menu.CupboardMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CupboardBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_STACK_HEIGHT = 4;
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final BooleanProperty MANUAL_FLIPPED = BooleanProperty.create((String)"manual_flipped");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    public static final MapCodec<CupboardBlock> CODEC = CupboardBlock.simpleCodec(CupboardBlock::new);

    public CupboardBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).setValue((Property)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, VARIANT, OPEN, FLIPPED, MANUAL_FLIPPED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CupboardBlockEntity(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        int countDown;
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction facing = ctx.getHorizontalDirection();
        boolean waterlogged = level.getFluidState(pos).getType() == Fluids.WATER;
        int countUp = this.countConnectedCupboards(level, pos.above(), facing, Direction.UP);
        int totalHeight = countUp + (countDown = this.countConnectedCupboards(level, pos.below(), facing, Direction.DOWN)) + 1;
        if (totalHeight > 4) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private int countConnectedCupboards(Level level, BlockPos pos, Direction facing, Direction dir) {
        BlockState state;
        int count = 0;
        while (count < 4 && (state = level.getBlockState(pos)).getBlock() == this && state.getValue((Property)FACING) == facing) {
            ++count;
            pos = pos.relative(dir);
        }
        return count;
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.updateCupboardVariant(state, level, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CupboardBlockEntity) {
                CupboardBlockEntity cupboard = (CupboardBlockEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)cupboard);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!held.isEmpty()) {
            if (held.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
                boolean newFlipped = (Boolean)state.getValue((Property)FLIPPED) == false;
                Direction facing = (Direction)state.getValue((Property)FACING);
                ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
                HashSet<BlockPos> visited = new HashSet<BlockPos>();
                stack.add(pos);
                while (!stack.isEmpty()) {
                    BlockState currentState;
                    BlockPos current = (BlockPos)stack.removeLast();
                    if (!visited.add(current) || (currentState = level.getBlockState(current)).getBlock() != this || currentState.getValue((Property)FACING) != facing) continue;
                    BlockState newState = (BlockState)((BlockState)currentState.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(newFlipped))).setValue((Property)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(true));
                    level.setBlock(current, newState, 3);
                    stack.add(current.above());
                    stack.add(current.below());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        boolean currentOpen = (Boolean)state.getValue((Property)OPEN);
        if (currentOpen) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!level.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos poss = blockEntity.getBlockPos();
                serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, pl) -> new CupboardMenu(containerId, inventory, (CupboardBlockEntity)blockEntity), (Component)state.getBlock().getName()), poss);
            }
        }
        currentOpen = true;
        Direction facing = (Direction)state.getValue((Property)FACING);
        ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.add(pos);
        while (!stack.isEmpty()) {
            BlockState currentState;
            BlockPos current = (BlockPos)stack.removeLast();
            if (!visited.add(current) || (currentState = level.getBlockState(current)).getBlock() != this || currentState.getValue((Property)FACING) != facing) continue;
            Variant variant = (Variant)((Object)currentState.getValue(VARIANT));
            if (variant == Variant.UP || variant == Variant.DOWN || variant == Variant.CENTER) {
                level.setBlock(current, (BlockState)currentState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
                stack.add(current.above());
                stack.add(current.below());
                continue;
            }
            if (variant != Variant.NORMAL) continue;
            level.setBlock(current, (BlockState)currentState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return CupboardBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.CUPBOARD_BLOCK_ENTITY.get()), (lvl, pos, st, be) -> be.tick(lvl, pos, st));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updateSurroundingVerticalCupboards(level, pos);
    }

    private void updateSurroundingVerticalCupboards(Level level, BlockPos pos) {
        for (Direction dir : new Direction[]{Direction.UP, Direction.DOWN}) {
            BlockPos neighborPos = pos.relative(dir);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (neighborState.getBlock() != this) continue;
            level.setBlock(neighborPos, this.updateCupboardVariant(neighborState, (LevelAccessor)level, neighborPos), 3);
        }
    }

    private BlockState updateCupboardVariant(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos up = pos.above();
        BlockPos down = pos.below();
        boolean upConnected = this.isCupboard(level, up, facing);
        boolean downConnected = this.isCupboard(level, down, facing);
        Variant variant = Variant.NORMAL;
        if (upConnected && downConnected) {
            variant = Variant.CENTER;
        } else if (upConnected) {
            variant = Variant.DOWN;
        } else if (downConnected) {
            variant = Variant.UP;
        }
        BlockPos leftPos = pos.relative(facing.getClockWise());
        boolean autoFlipped = this.isCupboard(level, leftPos, facing);
        boolean manual = (Boolean)state.getValue((Property)MANUAL_FLIPPED);
        boolean flipped = manual ? (Boolean)state.getValue((Property)FLIPPED) : autoFlipped;
        return (BlockState)((BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)variant))).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).setValue((Property)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(manual));
    }

    private boolean isCupboard(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockState state = level.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

