/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import net.alminoris.aestheticstorage.block.entity.HalfcabinetBlockEntity;
import net.alminoris.aestheticstorage.block.entity.ModBlockEntities;
import net.alminoris.aestheticstorage.menu.HalfcabinetMenu;
import net.alminoris.aestheticstorage.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HalfcabinetBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = HalfcabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
    public final boolean HAS_FLIP;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    public static final MapCodec<HalfcabinetBlock> CODEC_WITH_FLIP = HalfcabinetBlock.simpleCodec(properties -> new HalfcabinetBlock((BlockBehaviour.Properties)properties, true));
    public static final MapCodec<HalfcabinetBlock> CODEC_WITHOUT_FLIP = HalfcabinetBlock.simpleCodec(properties -> new HalfcabinetBlock((BlockBehaviour.Properties)properties, false));

    public HalfcabinetBlock(BlockBehaviour.Properties properties, boolean hasFlip) {
        super(properties.noOcclusion());
        this.HAS_FLIP = hasFlip;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(SHAPE.bounds());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    protected VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.getRotatedShape(p_60555_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, OPEN, WATERLOGGED});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.HAS_FLIP ? CODEC_WITH_FLIP : CODEC_WITHOUT_FLIP;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HalfcabinetBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return HalfcabinetBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.HALFCABINET_BLOCK_ENTITY.get()), (world, pos, blockState, entity) -> entity.tick(world, pos, blockState));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.updateCabinetVariant(state, level, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof HalfcabinetBlockEntity) {
                HalfcabinetBlockEntity cabinet = (HalfcabinetBlockEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)cabinet);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            if (player.getItemInHand(InteractionHand.MAIN_HAND).is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
                Variant variant = (Variant)((Object)state.getValue(VARIANT));
                if (this.HAS_FLIP) {
                    level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL)), 3);
                } else if (variant == Variant.LEFT) {
                    level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT)), 3);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            boolean open = (Boolean)state.getValue((Property)OPEN);
            Variant variant = (Variant)((Object)state.getValue(VARIANT));
            Direction facing = (Direction)state.getValue((Property)FACING);
            MenuProvider provider = (MenuProvider)level.getBlockEntity(pos);
            if (open) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!level.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BlockPos poss = blockEntity.getBlockPos();
                    serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, pl) -> new HalfcabinetMenu(containerId, inventory, (HalfcabinetBlockEntity)blockEntity), (Component)state.getBlock().getName()), poss);
                }
            }
            boolean bl = open = !open;
            if (this.HAS_FLIP) {
                boolean isLeft;
                boolean isRight = variant == Variant.RIGHT;
                boolean bl2 = isLeft = variant == Variant.LEFT;
                BlockPos otherPos = isRight ? pos.relative(facing.getCounterClockWise()) : (isLeft ? pos.relative(facing.getClockWise()) : pos);
                BlockState otherState = level.getBlockState(otherPos);
                if (otherState.getBlock() == this && otherState.getValue((Property)FACING) == facing && otherState.getValue(VARIANT) != variant) {
                    level.setBlock(otherPos, (BlockState)otherState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, level, pos, oldState, notify);
        this.updateSurroundingCabinets(level, pos);
    }

    private void updateSurroundingCabinets(Level level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(dir);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (neighborState.getBlock() != this) continue;
            level.setBlock(neighborPos, this.updateCabinetVariant(neighborState, (LevelAccessor)level, neighborPos), 3);
        }
    }

    private BlockState updateCabinetVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        boolean leftConnected = this.isCabinet(world, leftPos, facing);
        boolean rightConnected = this.isCabinet(world, rightPos, facing);
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isCabinet(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

