/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.alminoris.aestheticstorage.block.custom.HalfcupboardBlock;
import net.alminoris.aestheticstorage.block.entity.HalfcupboardBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class HalfcupboardBlockEntityRenderer
implements BlockEntityRenderer<HalfcupboardBlockEntity> {
    public HalfcupboardBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HalfcupboardBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        List<ItemStack> stacks = entity.getRenderStack();
        if (stacks.isEmpty() || entity.getLevel() == null) {
            return;
        }
        Direction facing = (Direction)entity.getBlockState().getValue((Property)HalfcupboardBlock.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        int counter = 0;
        for (ItemStack stack : stacks) {
            poseStack.pushPose();
            switch (counter) {
                case 0: {
                    poseStack.translate(0.25f, 0.65f, 0.25f);
                    break;
                }
                case 1: {
                    poseStack.translate(0.25f, 0.2f, 0.25f);
                    break;
                }
                case 2: {
                    poseStack.translate(0.75f, 0.65f, 0.25f);
                    break;
                }
                case 3: {
                    poseStack.translate(0.75f, 0.2f, 0.25f);
                }
            }
            poseStack.scale(0.25f, 0.25f, 0.25f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, this.getLightLevel(entity.getLevel(), entity.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, bufferSource, entity.getLevel(), 0);
            poseStack.popPose();
            ++counter;
        }
        poseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)blockLight, (int)skyLight);
    }
}

