/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.menu;

import net.alminoris.aestheticstorage.block.custom.HalfcabinetBlock;
import net.alminoris.aestheticstorage.block.entity.HalfcabinetBlockEntity;
import net.alminoris.aestheticstorage.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HalfcabinetMenu
extends AbstractContainerMenu {
    private final HalfcabinetBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public HalfcabinetMenu(int containerId, Inventory playerInventory, HalfcabinetBlockEntity blockEntity) {
        super((MenuType)ModMenus.HALFCABINET_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.create((Level)playerInventory.player.level(), (BlockPos)blockEntity.getBlockPos());
        int l = 0;
        for (int i = 1; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)blockEntity, l++, 53 + i * 18, 27 + j * 18));
            }
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public HalfcabinetMenu(int containerId, Inventory playerInventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, playerInventory, (HalfcabinetBlockEntity)playerInventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()));
    }

    public boolean stillValid(Player player) {
        return this.blockEntity != null && this.blockEntity.stillValid(player);
    }

    public void removed(Player player) {
        BlockState state;
        super.removed(player);
        if (!player.level().isClientSide && (state = player.level().getBlockState(this.blockEntity.getBlockPos())).hasProperty((Property)HalfcabinetBlock.OPEN)) {
            player.level().setBlock(this.blockEntity.getBlockPos(), (BlockState)state.setValue((Property)HalfcabinetBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack original = slot.getItem();
            newStack = original.copy();
            int containerSlots = this.blockEntity.getContainerSize();
            int totalSlots = this.slots.size();
            if (index < containerSlots ? !this.moveItemStackTo(original, containerSlots, totalSlots, true) : !this.moveItemStackTo(original, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (original.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

