/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import net.alminoris.aestheticstorage.block.ModBlocks;
import net.alminoris.aestheticstorage.block.entity.HalfcupboardBlockEntity;
import net.alminoris.aestheticstorage.menu.HalfcupboardMenu;
import net.alminoris.aestheticstorage.util.helper.BlockSetsHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class HalfcupboardScreen
extends AbstractContainerScreen<HalfcupboardMenu> {
    private final String NAME;
    private final ResourceLocation TEXTURE;

    public HalfcupboardScreen(HalfcupboardMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        Block block;
        Container container = ((HalfcupboardMenu)this.menu).getSlot((int)0).container;
        if (container instanceof HalfcupboardBlockEntity) {
            HalfcupboardBlockEntity be = (HalfcupboardBlockEntity)container;
            block = be.getLevel().getBlockState(be.getBlockPos()).getBlock();
        } else {
            block = null;
        }
        this.NAME = BuiltInRegistries.BLOCK.getKey((Object)Objects.requireNonNull(block)).getPath();
        this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aestheticstorage", (String)("textures/gui/" + this.getWoodName() + "_half.png"));
    }

    private String getWoodName() {
        Block block;
        Container container = ((HalfcupboardMenu)this.menu).getSlot((int)0).container;
        if (container instanceof HalfcupboardBlockEntity) {
            HalfcupboardBlockEntity be = (HalfcupboardBlockEntity)container;
            block = be.getLevel().getBlockState(be.getBlockPos()).getBlock();
        } else {
            block = null;
        }
        Block block2 = Objects.requireNonNull(block);
        String value = HalfcupboardScreen.getKeyByValue((Hashtable)ModBlocks.HALFCUPBOARDS, block2);
        if (value != null) {
            return value;
        }
        return "";
    }

    private static String getKeyByValue(Hashtable<String, RegistryObject<Block>> table, Block value) {
        for (Map.Entry<String, RegistryObject<Block>> entry : table.entrySet()) {
            if (!((Block)entry.getValue().get()).equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void init() {
        super.init();
        this.titleLabelY = 10;
        this.titleLabelX = 10;
        this.inventoryLabelX = 10;
        this.inventoryLabelY = 68;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        int color = 0xFFFFFF;
        for (String name : BlockSetsHelper.getWoods()) {
            if (!this.NAME.endsWith("_" + name)) continue;
            color = BlockSetsHelper.WOOD_COLORS.get(name);
        }
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, color, false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, color, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

