/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashSet;
import net.alminoris.aestheticstorage.block.entity.HalfcupboardBlockEntity;
import net.alminoris.aestheticstorage.block.entity.ModBlockEntities;
import net.alminoris.aestheticstorage.util.helper.VoxelShapeHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class HalfcupboardBlock
extends class_2237
implements class_2343 {
    public static final int MAX_STACK_HEIGHT = 4;
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 OPEN = class_2746.method_11825((String)"open");
    public static final class_2746 FLIPPED = class_2746.method_11825((String)"flipped");
    public static final class_2746 MANUAL_FLIPPED = class_2746.method_11825((String)"manual_flipped");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);
    public static final MapCodec<HalfcupboardBlock> CODEC = HalfcupboardBlock.method_54094(HalfcupboardBlock::new);

    public HalfcupboardBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, VARIANT, OPEN, FLIPPED, MANUAL_FLIPPED});
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    private class_265 getRotatedShape(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        boxes.add(SHAPE.method_1107());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    protected class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HalfcupboardBlockEntity(pos, state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        int countDown;
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 facing = ctx.method_8042();
        boolean waterlogged = world.method_8316(pos).method_15772() == class_3612.field_15910;
        int countUp = this.countConnectedCupboards(world, pos.method_10084(), facing, class_2350.field_11036);
        int totalHeight = countUp + (countDown = this.countConnectedCupboards(world, pos.method_10074(), facing, class_2350.field_11033)) + 1;
        if (totalHeight > 4) {
            return null;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private int countConnectedCupboards(class_1937 world, class_2338 pos, class_2350 facing, class_2350 direction) {
        class_2680 state;
        int count = 0;
        while (count < 4 && (state = world.method_8320(pos)).method_26204() == this && state.method_11654((class_2769)FACING) == facing) {
            ++count;
            pos = pos.method_10093(direction);
        }
        return count;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return this.updateCupboardVariant(state, world, pos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof HalfcupboardBlockEntity) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((HalfcupboardBlockEntity)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!player.method_6047().method_7960()) {
            if (player.method_6047().method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"aestheticseating", (String)"wrench")))) {
                boolean newFlipped = (Boolean)state.method_11654((class_2769)FLIPPED) == false;
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                ArrayList<class_2338> stack = new ArrayList<class_2338>();
                HashSet<class_2338> visited = new HashSet<class_2338>();
                stack.add(pos);
                while (!stack.isEmpty()) {
                    class_2680 currentState;
                    class_2338 currentPos = (class_2338)stack.removeLast();
                    if (!visited.add(currentPos) || (currentState = world.method_8320(currentPos)).method_26204() != this || currentState.method_11654((class_2769)FACING) != facing) continue;
                    class_2680 newState = (class_2680)((class_2680)currentState.method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(newFlipped))).method_11657((class_2769)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(true));
                    world.method_8652(currentPos, newState, 3);
                    class_2338 up = currentPos.method_10084();
                    class_2338 down = currentPos.method_10074();
                    if (!visited.contains(up)) {
                        stack.add(up);
                    }
                    if (visited.contains(down)) continue;
                    stack.add(down);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        boolean currentOpen = (Boolean)state.method_11654((class_2769)OPEN);
        HalfcupboardBlockEntity screenHandlerFactory = (HalfcupboardBlockEntity)world.method_8321(pos);
        if (screenHandlerFactory != null && currentOpen) {
            player.method_17355((class_3908)screenHandlerFactory);
        }
        currentOpen = true;
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        ArrayList<class_2338> stack = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        stack.add(pos);
        while (!stack.isEmpty()) {
            class_2680 currentState;
            class_2338 currentPos = (class_2338)stack.removeLast();
            if (!visited.add(currentPos) || (currentState = world.method_8320(currentPos)).method_26204() != this || currentState.method_11654((class_2769)FACING) != facing) continue;
            Variant currentVariant = (Variant)((Object)currentState.method_11654(VARIANT));
            if (currentVariant == Variant.UP || currentVariant == Variant.DOWN || currentVariant == Variant.CENTER) {
                world.method_8652(currentPos, (class_2680)currentState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
                stack.add(currentPos.method_10084());
                stack.add(currentPos.method_10074());
                continue;
            }
            if (currentVariant != Variant.NORMAL) continue;
            world.method_8652(currentPos, (class_2680)currentState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
        }
        return class_1269.field_5812;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return HalfcupboardBlock.method_31618(type, ModBlockEntities.HALFCUPBOARD_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateSurroundingVerticalCupboards(world, pos);
    }

    private void updateSurroundingVerticalCupboards(class_1937 world, class_2338 pos) {
        for (class_2350 direction : new class_2350[]{class_2350.field_11036, class_2350.field_11033}) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_26204() != this) continue;
            world.method_8501(neighborPos, this.updateCupboardVariant(neighborState, (class_1936)world, neighborPos));
        }
    }

    private class_2680 updateCupboardVariant(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 upPos = pos.method_10084();
        class_2338 downPos = pos.method_10074();
        boolean upConnected = this.isCupboard(world, upPos, facing);
        boolean downConnected = this.isCupboard(world, downPos, facing);
        Variant variant = Variant.NORMAL;
        if (upConnected && downConnected) {
            variant = Variant.CENTER;
        } else if (upConnected) {
            variant = Variant.DOWN;
        } else if (downConnected) {
            variant = Variant.UP;
        }
        class_2338 leftPos = pos.method_10093(facing.method_10170());
        boolean autoFlipped = this.isCupboard(world, leftPos, facing);
        boolean manual = (Boolean)state.method_11654((class_2769)MANUAL_FLIPPED);
        boolean flipped = manual ? (Boolean)state.method_11654((class_2769)FLIPPED) : autoFlipped;
        return (class_2680)((class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)variant))).method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(flipped))).method_11657((class_2769)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(manual));
    }

    private boolean isCupboard(class_1936 world, class_2338 pos, class_2350 facing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() == this && state.method_11654((class_2769)FACING) == facing;
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

