/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.datagen;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.alminoris.aestheticstorage.util.helper.BlockSetsHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ModLanguageProviderEnUs
extends LanguageProvider {
    public ModLanguageProviderEnUs(PackOutput output) {
        super(output, "aestheticstorage", "en_us");
    }

    public void addTranslations() {
        for (Block block : BuiltInRegistries.BLOCK) {
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            String pathNew = path = id.getPath();
            pathNew = ModLanguageProviderEnUs.movePrefix(ModLanguageProviderEnUs.movePrefix(path, BlockSetsHelper.getStones()), BlockSetsHelper.getWoods());
            String[] parts = pathNew.split("_");
            String displayName = Arrays.stream(parts).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
            displayName = displayName.replace(" Nss", "");
            this.add("block.aestheticstorage." + path, displayName);
        }
        this.add("item.aestheticstorage.wrench", "Wrench");
        this.add("itemgroup.astrgtab", "Aesthetic Storage");
    }

    public static String movePrefix(String input, String[] arr) {
        String[] sorted = Arrays.copyOf(arr, arr.length);
        Arrays.sort(sorted, (a, b) -> Integer.compare(b.length(), a.length()));
        for (String el : sorted) {
            String suffix = "_" + el;
            if (!input.endsWith(suffix)) continue;
            String base = input.substring(0, input.length() - suffix.length());
            return base.isEmpty() ? el : el + "_" + base;
        }
        return input;
    }
}

