/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.menu;

import net.alminoris.aestheticstorage.block.custom.CabinetBlock;
import net.alminoris.aestheticstorage.block.entity.CabinetBlockEntity;
import net.alminoris.aestheticstorage.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CabinetMenu
extends AbstractContainerMenu {
    private final CabinetBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public CabinetMenu(int containerId, Inventory playerInventory, CabinetBlockEntity blockEntity) {
        super((MenuType)ModMenus.CABINET_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.create((Level)playerInventory.player.level(), (BlockPos)blockEntity.getBlockPos());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)blockEntity, j * 4 + i, 53 + i * 18, 27 + j * 18));
            }
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public CabinetMenu(int containerId, Inventory playerInventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, playerInventory, (CabinetBlockEntity)playerInventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()));
    }

    public boolean stillValid(Player player) {
        return this.blockEntity != null && this.blockEntity.stillValid(player);
    }

    public void removed(Player player) {
        BlockState state;
        super.removed(player);
        if (!player.level().isClientSide && (state = player.level().getBlockState(this.blockEntity.getBlockPos())).hasProperty((Property)CabinetBlock.OPEN)) {
            player.level().setBlock(this.blockEntity.getBlockPos(), (BlockState)state.setValue((Property)CabinetBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack original = slot.getItem();
            newStack = original.copy();
            int containerSlots = this.blockEntity.getContainerSize();
            int totalSlots = this.slots.size();
            if (index < containerSlots ? !this.moveItemStackTo(original, containerSlots, totalSlots, true) : !this.moveItemStackTo(original, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (original.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

