/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.menu;

import java.util.ArrayList;
import java.util.HashSet;
import net.alminoris.aestheticstorage.block.custom.HalfcupboardBlock;
import net.alminoris.aestheticstorage.block.entity.HalfcupboardBlockEntity;
import net.alminoris.aestheticstorage.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HalfcupboardMenu
extends AbstractContainerMenu {
    private final HalfcupboardBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public HalfcupboardMenu(int containerId, Inventory playerInventory, HalfcupboardBlockEntity blockEntity) {
        super((MenuType)ModMenus.HALFCUPBOARD_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.create((Level)playerInventory.player.level(), (BlockPos)blockEntity.getBlockPos());
        int l = 0;
        for (int i = 1; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)blockEntity, l++, 53 + i * 18, 27 + j * 18));
            }
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public HalfcupboardMenu(int containerId, Inventory playerInventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, playerInventory, (HalfcupboardBlockEntity)playerInventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()));
    }

    public boolean stillValid(Player player) {
        return this.blockEntity != null && this.blockEntity.stillValid(player);
    }

    public void removed(Player player) {
        BlockPos startPos;
        super.removed(player);
        if (player.level().isClientSide) {
            return;
        }
        Level world = player.level();
        BlockState startState = world.getBlockState(startPos = this.blockEntity.getBlockPos());
        if (!(startState.getBlock() instanceof HalfcupboardBlock)) {
            return;
        }
        Direction facing = (Direction)startState.getValue((Property)HalfcupboardBlock.FACING);
        ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.add(startPos);
        while (!stack.isEmpty()) {
            BlockState currentState;
            BlockPos currentPos = (BlockPos)stack.removeLast();
            if (!visited.add(currentPos) || !((currentState = world.getBlockState(currentPos)).getBlock() instanceof HalfcupboardBlock) || currentState.getValue((Property)HalfcupboardBlock.FACING) != facing) continue;
            HalfcupboardBlock.Variant currentVariant = (HalfcupboardBlock.Variant)((Object)currentState.getValue(HalfcupboardBlock.VARIANT));
            if (currentVariant == HalfcupboardBlock.Variant.UP || currentVariant == HalfcupboardBlock.Variant.DOWN || currentVariant == HalfcupboardBlock.Variant.CENTER) {
                if (((Boolean)currentState.getValue((Property)HalfcupboardBlock.OPEN)).booleanValue()) {
                    world.setBlock(currentPos, (BlockState)currentState.setValue((Property)HalfcupboardBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                }
                stack.add(currentPos.above());
                stack.add(currentPos.below());
                continue;
            }
            if (currentVariant != HalfcupboardBlock.Variant.NORMAL || !((Boolean)currentState.getValue((Property)HalfcupboardBlock.OPEN)).booleanValue()) continue;
            world.setBlock(currentPos, (BlockState)currentState.setValue((Property)HalfcupboardBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack original = slot.getItem();
            newStack = original.copy();
            int containerSlots = this.blockEntity.getContainerSize();
            int totalSlots = this.slots.size();
            if (index < containerSlots ? !this.moveItemStackTo(original, containerSlots, totalSlots, true) : !this.moveItemStackTo(original, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (original.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

