/*
 * Decompiled with CFR 0.152.
 */
package com.restartannouncer;

import com.restartannouncer.commands.AnnouncerCommand;
import com.restartannouncer.managers.ConfigManager;
import com.restartannouncer.managers.MessageManager;
import com.restartannouncer.managers.RestartManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class RestartAnnouncerPlugin
extends JavaPlugin {
    private static RestartAnnouncerPlugin instance;
    private ConfigManager configManager;
    private RestartManager restartManager;
    private MessageManager messageManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.restartManager = new RestartManager(this);
        this.configManager.loadConfig();
        this.messageManager.loadMessages();
        AnnouncerCommand announcerCommand = new AnnouncerCommand(this);
        this.getCommand("announcer").setExecutor((CommandExecutor)announcerCommand);
        this.getCommand("announcer").setTabCompleter((TabCompleter)announcerCommand);
        this.getLogger().info("RestartAnnouncer has been enabled!");
    }

    public void onDisable() {
        if (this.restartManager != null) {
            this.restartManager.stopRestart();
        }
        this.getLogger().info("RestartAnnouncer has been disabled!");
    }

    public static RestartAnnouncerPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RestartManager getRestartManager() {
        return this.restartManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }
}

