/*
 * Decompiled with CFR 0.152.
 */
package com.restartannouncer.commands;

import com.restartannouncer.RestartAnnouncerPlugin;
import com.restartannouncer.managers.RestartManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AnnouncerCommand
implements CommandExecutor,
TabCompleter {
    private final RestartAnnouncerPlugin plugin;

    public AnnouncerCommand(RestartAnnouncerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.sendHelp((Player)sender);
            } else {
                this.sendConsoleHelp(sender);
            }
            return true;
        }
        String subcommand = args[0].toLowerCase();
        if (subcommand.equals("start")) {
            this.handleStart(sender, args);
            return true;
        }
        if (subcommand.equals("stop")) {
            this.handleStop(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("commands.player-only"));
            return true;
        }
        Player player = (Player)sender;
        switch (subcommand) {
            case "stop": {
                this.handleStop(player);
                break;
            }
            case "status": {
                this.handleStatus(player);
                break;
            }
            case "reload": {
                this.handleReload(player);
                break;
            }
            case "toggle": {
                this.handleToggle(player);
                break;
            }
            case "set": {
                this.handleSet(player, args);
                break;
            }
            case "help": {
                this.sendHelp(player);
                break;
            }
            default: {
                this.plugin.getMessageManager().sendError(player, "Unknown subcommand: " + subcommand);
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void handleStart(CommandSender sender, String[] args) {
        int restartSeconds;
        if (!sender.hasPermission(this.plugin.getConfigManager().getStartPermission())) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "no-permission")));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "usage")));
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "example")));
            return;
        }
        try {
            restartSeconds = RestartManager.parseTime(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "invalid-time")));
            return;
        }
        int intervalSeconds = this.plugin.getConfigManager().getDefaultAnnouncementInterval();
        if (args.length >= 3) {
            try {
                intervalSeconds = RestartManager.parseTime(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "invalid-interval")));
                return;
            }
        }
        String displayType = "chat";
        if (args.length >= 4 && !this.isValidDisplayType(displayType = args[3].toLowerCase())) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "invalid-display")));
            return;
        }
        if (this.plugin.getRestartManager().isRunning()) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "already-running")));
            return;
        }
        if (this.plugin.getRestartManager().startRestart(restartSeconds, intervalSeconds, displayType)) {
            Map<String, String> placeholders = this.plugin.getMessageManager().createPlaceholders("time", this.formatTime(restartSeconds), "interval", this.formatTime(intervalSeconds), "display", displayType);
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "success", placeholders)));
        } else {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("start", "already-running")));
        }
    }

    private boolean isValidDisplayType(String displayType) {
        return displayType.equals("chat") || displayType.equals("bossbar") || displayType.equals("title");
    }

    private void handleStop(CommandSender sender) {
        if (!sender.hasPermission(this.plugin.getConfigManager().getStopPermission())) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("stop", "no-permission")));
            return;
        }
        if (!this.plugin.getRestartManager().isRunning()) {
            sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("stop", "not-running")));
            return;
        }
        this.plugin.getRestartManager().stopRestart();
        sender.sendMessage(this.plugin.getMessageManager().formatMessage(this.plugin.getMessageManager().getCommandMessage("stop", "success")));
    }

    private void handleStop(Player player) {
        if (!player.hasPermission(this.plugin.getConfigManager().getStopPermission())) {
            this.plugin.getMessageManager().sendError(player, this.plugin.getMessageManager().getCommandMessage("stop", "no-permission"));
            return;
        }
        if (!this.plugin.getRestartManager().isRunning()) {
            this.plugin.getMessageManager().sendError(player, this.plugin.getMessageManager().getCommandMessage("stop", "not-running"));
            return;
        }
        this.plugin.getRestartManager().stopRestart();
        this.plugin.getMessageManager().sendSuccess(player, this.plugin.getMessageManager().getCommandMessage("stop", "success"));
    }

    private void handleStatus(Player player) {
        if (!player.hasPermission(this.plugin.getConfigManager().getStatusPermission())) {
            this.plugin.getMessageManager().sendError(player, this.plugin.getMessageManager().getCommandMessage("status", "no-permission"));
            return;
        }
        if (this.plugin.getRestartManager().isRunning()) {
            Map<String, String> placeholders = this.plugin.getMessageManager().createPlaceholders("time", this.plugin.getRestartManager().getTimeRemainingFormatted());
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("status", "running", placeholders));
        } else {
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("status", "not-running"));
        }
    }

    private void handleReload(Player player) {
        if (!player.hasPermission(this.plugin.getConfigManager().getReloadPermission())) {
            this.plugin.getMessageManager().sendError(player, this.plugin.getMessageManager().getCommandMessage("reload", "no-permission"));
            return;
        }
        this.plugin.getConfigManager().reloadConfig();
        this.plugin.getMessageManager().reloadMessages();
        this.plugin.getMessageManager().sendSuccess(player, this.plugin.getMessageManager().getCommandMessage("reload", "success"));
    }

    private void handleToggle(Player player) {
        if (!player.hasPermission(this.plugin.getConfigManager().getReloadPermission())) {
            this.plugin.getMessageManager().sendError(player, this.plugin.getMessageManager().getCommandMessage("reload", "no-permission"));
            return;
        }
        boolean currentSetting = this.plugin.getConfigManager().shouldExecuteShutdown();
        boolean newSetting = !currentSetting;
        this.plugin.getConfig().set("execute-shutdown", (Object)newSetting);
        this.plugin.saveConfig();
        String status = newSetting ? "enabled" : "disabled";
        this.plugin.getMessageManager().sendSuccess(player, "\u00a7aExecute shutdown " + status + ". Run \u00a7e/announcer reload\u00a7a to apply changes.");
    }

    private void handleSet(Player player, String[] args) {
        if (!player.hasPermission(this.plugin.getConfigManager().getReloadPermission())) {
            this.plugin.getMessageManager().sendError(player, this.plugin.getMessageManager().getCommandMessage("reload", "no-permission"));
            return;
        }
        if (args.length < 3) {
            this.plugin.getMessageManager().sendError(player, "\u00a7cUsage: /announcer set message <message>");
            return;
        }
        if (!args[1].equalsIgnoreCase("message")) {
            this.plugin.getMessageManager().sendError(player, "\u00a7cUsage: /announcer set message <message>");
            return;
        }
        String newMessage = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        if (newMessage.trim().isEmpty()) {
            this.plugin.getMessageManager().sendError(player, "\u00a7cMessage cannot be empty!");
            return;
        }
        if (this.plugin.getMessageManager().setRestartMessage(newMessage)) {
            this.plugin.getMessageManager().sendSuccess(player, "\u00a7aRestart message updated successfully!");
            this.plugin.getMessageManager().sendInfo(player, "\u00a77New message: " + this.plugin.getMessageManager().formatMessage(newMessage));
        } else {
            this.plugin.getMessageManager().sendError(player, "\u00a7cFailed to update restart message. Check console for errors.");
        }
    }

    private void sendHelp(Player player) {
        this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "header"));
        if (player.hasPermission(this.plugin.getConfigManager().getStartPermission())) {
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "start"));
        }
        if (player.hasPermission(this.plugin.getConfigManager().getStopPermission())) {
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "stop"));
        }
        if (player.hasPermission(this.plugin.getConfigManager().getStatusPermission())) {
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "status"));
        }
        if (player.hasPermission(this.plugin.getConfigManager().getReloadPermission())) {
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "toggle"));
            this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "set"));
        }
        this.plugin.getMessageManager().sendInfo(player, this.plugin.getMessageManager().getCommandMessage("help", "help"));
    }

    private void sendConsoleHelp(CommandSender sender) {
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "header"));
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "start"));
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "stop"));
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "status"));
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "toggle"));
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "set"));
        sender.sendMessage(this.plugin.getMessageManager().getCommandMessage("help", "help"));
    }

    private String formatTime(int seconds) {
        int hours;
        if (seconds < 60) {
            return seconds + " seconds";
        }
        if (seconds < 3600) {
            int minutes;
            return minutes + " minute" + ((minutes = seconds / 60) != 1 ? "s" : "");
        }
        return hours + " hour" + ((hours = seconds / 3600) != 1 ? "s" : "");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subcommand;
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> subcommands = new ArrayList<String>();
            if (player.hasPermission(this.plugin.getConfigManager().getStartPermission())) {
                subcommands.add("start");
            }
            if (player.hasPermission(this.plugin.getConfigManager().getStopPermission())) {
                subcommands.add("stop");
            }
            if (player.hasPermission(this.plugin.getConfigManager().getStatusPermission())) {
                subcommands.add("status");
            }
            if (player.hasPermission(this.plugin.getConfigManager().getReloadPermission())) {
                subcommands.add("reload");
                subcommands.add("toggle");
                subcommands.add("set");
            }
            subcommands.add("help");
            for (String subcommand2 : subcommands) {
                if (!subcommand2.startsWith(args[0].toLowerCase())) continue;
                completions.add(subcommand2);
            }
        } else if (args.length == 2) {
            String subcommand3 = args[0].toLowerCase();
            if ("start".equals(subcommand3) && player.hasPermission(this.plugin.getConfigManager().getStartPermission())) {
                completions.addAll(Arrays.asList("5m", "10m", "15m", "30m", "1h", "2h"));
            } else if ("set".equals(subcommand3) && player.hasPermission(this.plugin.getConfigManager().getReloadPermission())) {
                completions.add("message");
            }
        } else if (args.length == 3) {
            String currentMessage;
            String subcommand4 = args[0].toLowerCase();
            if ("start".equals(subcommand4) && player.hasPermission(this.plugin.getConfigManager().getStartPermission())) {
                completions.addAll(Arrays.asList("30s", "60s", "2m", "5m"));
            } else if ("set".equals(subcommand4) && player.hasPermission(this.plugin.getConfigManager().getReloadPermission()) && (currentMessage = this.plugin.getMessageManager().getMessage("restart-message")) != null && !currentMessage.isEmpty()) {
                completions.add(currentMessage);
            }
        } else if (args.length == 4 && "start".equals(subcommand = args[0].toLowerCase()) && player.hasPermission(this.plugin.getConfigManager().getStartPermission())) {
            completions.addAll(Arrays.asList("chat", "bossbar", "title"));
        }
        return completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

