/*
 * Decompiled with CFR 0.152.
 */
package com.restartannouncer.managers;

import com.restartannouncer.RestartAnnouncerPlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final RestartAnnouncerPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(RestartAnnouncerPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public int getDefaultRestartTime() {
        return this.config.getInt("defaults.restart-time", 10);
    }

    public int getDefaultAnnouncementInterval() {
        return this.config.getInt("defaults.announcement-interval", 60);
    }

    public String getStartPermission() {
        return this.config.getString("permissions.start", "announcer.start");
    }

    public String getStopPermission() {
        return this.config.getString("permissions.stop", "announcer.stop");
    }

    public String getStatusPermission() {
        return this.config.getString("permissions.status", "announcer.status");
    }

    public String getReloadPermission() {
        return this.config.getString("permissions.reload", "announcer.reload");
    }

    public String getShutdownMethod() {
        return this.config.getString("shutdown-method", "shutdown");
    }

    public boolean shouldExecuteShutdown() {
        return this.config.getBoolean("execute-shutdown", true);
    }
}

