/*
 * Decompiled with CFR 0.152.
 */
package com.restartannouncer.managers;

import com.restartannouncer.RestartAnnouncerPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final RestartAnnouncerPlugin plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(RestartAnnouncerPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    public boolean setRestartMessage(String newMessage) {
        try {
            this.messagesConfig.set("restart-message", (Object)newMessage);
            this.messagesConfig.save(this.messagesFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save restart message: " + e.getMessage());
            return false;
        }
    }

    public String getMessage(String path) {
        return this.getMessage(path, "");
    }

    public String getMessage(String path, String defaultValue) {
        String message = this.messagesConfig.getString(path, defaultValue);
        if (message == null || message.isEmpty()) {
            return defaultValue;
        }
        return message;
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.getMessage(path);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return message;
    }

    public String getCommandMessage(String command, String type) {
        return this.getMessage("commands." + command + "." + type);
    }

    public String getCommandMessage(String command, String type, Map<String, String> placeholders) {
        return this.getMessage("commands." + command + "." + type, placeholders);
    }

    public String getRestartMessage(String timeRemaining) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("time", timeRemaining);
        return this.getMessage("restart-message", placeholders);
    }

    public Map<String, String> createPlaceholders(String ... keyValuePairs) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            if (i + 1 >= keyValuePairs.length) continue;
            placeholders.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return placeholders;
    }

    public void sendMessage(Player player, String message) {
        String formattedMessage = this.formatMessage(message);
        player.sendMessage(formattedMessage);
    }

    public void broadcastMessage(String message) {
        String formattedMessage = this.formatMessage(message);
        Bukkit.broadcastMessage((String)formattedMessage);
    }

    public void sendError(Player player, String message) {
        this.sendMessage(player, message);
    }

    public void sendSuccess(Player player, String message) {
        this.sendMessage(player, message);
    }

    public void sendInfo(Player player, String message) {
        this.sendMessage(player, message);
    }

    public String formatMessage(String message) {
        return message.replace("<red>", "\u00a7c").replace("<dark_red>", "\u00a74").replace("<blue>", "\u00a7b").replace("<dark_blue>", "\u00a71").replace("<aqua>", "\u00a7b").replace("<dark_aqua>", "\u00a73").replace("<green>", "\u00a7a").replace("<dark_green>", "\u00a72").replace("<yellow>", "\u00a7e").replace("<gold>", "\u00a76").replace("<purple>", "\u00a7d").replace("<dark_purple>", "\u00a75").replace("<white>", "\u00a7f").replace("<gray>", "\u00a77").replace("<dark_gray>", "\u00a78").replace("<black>", "\u00a70").replace("<bold>", "\u00a7l").replace("<italic>", "\u00a7o").replace("<underline>", "\u00a7n").replace("<strikethrough>", "\u00a7m").replace("<reset>", "\u00a7r");
    }
}

