/*
 * Decompiled with CFR 0.152.
 */
package com.restartannouncer.managers;

import com.restartannouncer.RestartAnnouncerPlugin;
import com.restartannouncer.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RestartManager {
    private final RestartAnnouncerPlugin plugin;
    private BukkitTask restartTask;
    private BukkitTask announcementTask;
    private int timeRemaining;
    private int initialTimeRemaining;
    private int announcementInterval;
    private String displayType;
    private BossBar bossBar;
    private boolean isRunning;

    public RestartManager(RestartAnnouncerPlugin plugin) {
        this.plugin = plugin;
        this.isRunning = false;
    }

    public boolean startRestart(int totalSeconds, int intervalSeconds, String displayType) {
        if (this.isRunning) {
            return false;
        }
        this.initialTimeRemaining = this.timeRemaining = totalSeconds;
        this.announcementInterval = intervalSeconds;
        this.displayType = displayType;
        this.isRunning = true;
        this.restartTask = new BukkitRunnable(){

            public void run() {
                --RestartManager.this.timeRemaining;
                if (RestartManager.this.timeRemaining <= 0) {
                    RestartManager.this.plugin.getMessageManager().broadcastMessage("\u00a7c\u00a7lServer is restarting now!");
                    if (RestartManager.this.plugin.getConfigManager().shouldExecuteShutdown()) {
                        Bukkit.getScheduler().runTaskLater((Plugin)RestartManager.this.plugin, () -> RestartManager.this.executeShutdown(), 20L);
                    } else {
                        RestartManager.this.plugin.getLogger().info("Restart countdown completed. Server shutdown was disabled in config.");
                    }
                    RestartManager.this.stopRestart();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
        this.startAnnouncements();
        return true;
    }

    private void startAnnouncements() {
        this.sendAnnouncement(this.timeRemaining);
        this.scheduleNextAnnouncement();
    }

    private void scheduleNextAnnouncement() {
        if (!this.isRunning) {
            return;
        }
        int nextInterval = this.getNextAnnouncementInterval(this.timeRemaining);
        if (this.timeRemaining > 60 && nextInterval > this.timeRemaining - 60) {
            nextInterval = Math.max(1, this.timeRemaining - 60);
            this.plugin.getLogger().info("Smart scheduling: adjusted interval to " + nextInterval + "s to ensure emergency countdown activation");
        }
        if (this.timeRemaining % 60 == 0 || this.timeRemaining == 30 || this.timeRemaining == 10) {
            this.plugin.getLogger().info("Scheduling next announcement in " + nextInterval + "s (time remaining: " + this.timeRemaining + "s)");
        }
        this.announcementTask = new BukkitRunnable(){

            public void run() {
                if (!RestartManager.this.isRunning) {
                    return;
                }
                RestartManager.this.sendAnnouncement(RestartManager.this.timeRemaining);
                RestartManager.this.scheduleNextAnnouncement();
            }
        }.runTaskLater((Plugin)this.plugin, (long)nextInterval * 20L);
    }

    private int getNextAnnouncementInterval(int timeLeft) {
        int interval;
        if (timeLeft <= 60) {
            int emergencyInterval = timeLeft <= 10 ? 1 : (timeLeft <= 30 ? 5 : 10);
            interval = Math.min(this.announcementInterval, emergencyInterval);
            if (interval != this.announcementInterval) {
                this.plugin.getLogger().info("Emergency countdown overriding user interval: " + this.announcementInterval + "s -> " + interval + "s at " + timeLeft + "s remaining");
            }
        } else {
            interval = this.announcementInterval;
        }
        return interval;
    }

    private void sendAnnouncement(int timeLeft) {
        String timeString = this.formatTime(timeLeft);
        String message = this.plugin.getMessageManager().getRestartMessage(timeString);
        switch (this.displayType) {
            case "bossbar": {
                this.sendBossBarMessage(message);
                break;
            }
            case "title": {
                this.sendTitleMessage(message);
                break;
            }
            default: {
                this.plugin.getMessageManager().broadcastMessage(message);
            }
        }
    }

    private void sendBossBarMessage(String message) {
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
        String legacyMessage = this.plugin.getMessageManager().formatMessage(message);
        String plainMessage = LegacyComponentSerializer.legacySection().serialize(LegacyComponentSerializer.legacySection().deserialize(legacyMessage));
        this.bossBar = Bukkit.createBossBar((String)plainMessage, (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        double progress = 1.0;
        if (this.initialTimeRemaining > 0) {
            progress = Math.max(0.0, Math.min(1.0, (double)this.timeRemaining / (double)this.initialTimeRemaining));
        }
        this.bossBar.setProgress(progress);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.bossBar.addPlayer(player);
        }
    }

    private void sendTitleMessage(String message) {
        String legacyMessage = this.plugin.getMessageManager().formatMessage(message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendTitle(legacyMessage, "", 10, 60, 10);
        }
    }

    public void stopRestart() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.restartTask != null) {
            this.restartTask.cancel();
            this.restartTask = null;
        }
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
            this.announcementTask = null;
        }
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBar = null;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public String getTimeRemainingFormatted() {
        return this.formatTime(this.timeRemaining);
    }

    private String formatTime(int seconds) {
        if (seconds < 60) {
            return seconds + " seconds";
        }
        if (seconds < 3600) {
            int minutes = seconds / 60;
            int remainingSeconds = seconds % 60;
            if (remainingSeconds == 0) {
                return minutes + " minute" + (minutes != 1 ? "s" : "");
            }
            return minutes + " minute" + (minutes != 1 ? "s" : "") + " " + remainingSeconds + " second" + (remainingSeconds != 1 ? "s" : "");
        }
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        if (minutes == 0) {
            return hours + " hour" + (hours != 1 ? "s" : "");
        }
        return hours + " hour" + (hours != 1 ? "s" : "") + " " + minutes + " minute" + (minutes != 1 ? "s" : "");
    }

    public static int parseTime(String timeString) {
        if ((timeString = timeString.toLowerCase().trim()).endsWith("s")) {
            return Integer.parseInt(timeString.substring(0, timeString.length() - 1));
        }
        if (timeString.endsWith("m")) {
            return Integer.parseInt(timeString.substring(0, timeString.length() - 1)) * 60;
        }
        if (timeString.endsWith("h")) {
            return Integer.parseInt(timeString.substring(0, timeString.length() - 1)) * 3600;
        }
        return Integer.parseInt(timeString) * 60;
    }

    private void executeShutdown() {
        String method = this.plugin.getConfigManager().getShutdownMethod();
        switch (method.toLowerCase()) {
            case "stop": {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"stop");
                break;
            }
            case "restart": {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"restart");
                break;
            }
            default: {
                Bukkit.shutdown();
            }
        }
    }
}

