/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.math;

import alexsocol.asjlib.math.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\bG\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \\2\u00020\u0001:\u0001\\B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0089\u0001\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0015B\u0011\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0017J\u0006\u0010J\u001a\u00020\u0000J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020MJ\u000e\u0010N\u001a\u00020\u00002\u0006\u0010L\u001a\u00020MJ\u0016\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u00052\u0006\u0010Q\u001a\u00020MJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010T\u001a\u00020\u0000J\u0006\u0010U\u001a\u00020\u0000J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u0010\u0010W\u001a\u00020X2\u0006\u0010L\u001a\u00020MH\u0002J\b\u0010Y\u001a\u00020ZH\u0016J\b\u0010[\u001a\u00020XH\u0007R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u001a\u0010)\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u001cR\u001a\u0010,\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010\u001cR\u001a\u0010/\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001a\"\u0004\b1\u0010\u001cR\u001a\u00102\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001a\"\u0004\b4\u0010\u001cR\u001a\u00105\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u001a\"\u0004\b7\u0010\u001cR\u001a\u00108\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010\u001cR\u001a\u0010;\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001a\"\u0004\b=\u0010\u001cR\u001a\u0010>\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u001a\"\u0004\b@\u0010\u001cR\u001a\u0010A\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u001a\"\u0004\bC\u0010\u001cR\u001a\u0010D\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001a\"\u0004\bF\u0010\u001cR\u001a\u0010G\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u001a\"\u0004\bI\u0010\u001c\u00a8\u0006]"}, d2={"Lalexsocol/asjlib/math/Matrix4;", "", "<init>", "()V", "d00", "", "d01", "d02", "d03", "d10", "d11", "d12", "d13", "d20", "d21", "d22", "d23", "d30", "d31", "d32", "d33", "(DDDDDDDDDDDDDDDD)V", "mat", "(Lalexsocol/asjlib/math/Matrix4;)V", "m00", "getM00", "()D", "setM00", "(D)V", "m01", "getM01", "setM01", "m02", "getM02", "setM02", "m03", "getM03", "setM03", "m10", "getM10", "setM10", "m11", "getM11", "setM11", "m12", "getM12", "setM12", "m13", "getM13", "setM13", "m20", "getM20", "setM20", "m21", "getM21", "setM21", "m22", "getM22", "setM22", "m23", "getM23", "setM23", "m30", "getM30", "setM30", "m31", "getM31", "setM31", "m32", "getM32", "setM32", "m33", "getM33", "setM33", "setIdentity", "translate", "vec", "Lalexsocol/asjlib/math/Vector3;", "scale", "rotate", "angle", "axis", "leftMultiply", "multiply", "transpose", "copy", "set", "mult3x3", "", "toString", "", "glApply", "Companion", "1.7.10-ASJCore"})
public final class Matrix4 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double m00;
    private double m01;
    private double m02;
    private double m03;
    private double m10;
    private double m11;
    private double m12;
    private double m13;
    private double m20;
    private double m21;
    private double m22;
    private double m23;
    private double m30;
    private double m31;
    private double m32;
    private double m33;
    private static final DoubleBuffer glBuf = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder()).asDoubleBuffer();

    public final double getM00() {
        return this.m00;
    }

    public final void setM00(double d) {
        this.m00 = d;
    }

    public final double getM01() {
        return this.m01;
    }

    public final void setM01(double d) {
        this.m01 = d;
    }

    public final double getM02() {
        return this.m02;
    }

    public final void setM02(double d) {
        this.m02 = d;
    }

    public final double getM03() {
        return this.m03;
    }

    public final void setM03(double d) {
        this.m03 = d;
    }

    public final double getM10() {
        return this.m10;
    }

    public final void setM10(double d) {
        this.m10 = d;
    }

    public final double getM11() {
        return this.m11;
    }

    public final void setM11(double d) {
        this.m11 = d;
    }

    public final double getM12() {
        return this.m12;
    }

    public final void setM12(double d) {
        this.m12 = d;
    }

    public final double getM13() {
        return this.m13;
    }

    public final void setM13(double d) {
        this.m13 = d;
    }

    public final double getM20() {
        return this.m20;
    }

    public final void setM20(double d) {
        this.m20 = d;
    }

    public final double getM21() {
        return this.m21;
    }

    public final void setM21(double d) {
        this.m21 = d;
    }

    public final double getM22() {
        return this.m22;
    }

    public final void setM22(double d) {
        this.m22 = d;
    }

    public final double getM23() {
        return this.m23;
    }

    public final void setM23(double d) {
        this.m23 = d;
    }

    public final double getM30() {
        return this.m30;
    }

    public final void setM30(double d) {
        this.m30 = d;
    }

    public final double getM31() {
        return this.m31;
    }

    public final void setM31(double d) {
        this.m31 = d;
    }

    public final double getM32() {
        return this.m32;
    }

    public final void setM32(double d) {
        this.m32 = d;
    }

    public final double getM33() {
        return this.m33;
    }

    public final void setM33(double d) {
        this.m33 = d;
    }

    public Matrix4() {
        this.m00 = this.m11 = (this.m22 = (this.m33 = 1.0));
    }

    public Matrix4(double d00, double d01, double d02, double d03, double d10, double d11, double d12, double d13, double d20, double d21, double d22, double d23, double d30, double d31, double d32, double d33) {
        this.m00 = d00;
        this.m01 = d01;
        this.m02 = d02;
        this.m03 = d03;
        this.m10 = d10;
        this.m11 = d11;
        this.m12 = d12;
        this.m13 = d13;
        this.m20 = d20;
        this.m21 = d21;
        this.m22 = d22;
        this.m23 = d23;
        this.m30 = d30;
        this.m31 = d31;
        this.m32 = d32;
        this.m33 = d33;
    }

    public Matrix4(@NotNull Matrix4 mat) {
        Intrinsics.checkNotNullParameter(mat, "mat");
        this.set(mat);
    }

    @NotNull
    public final Matrix4 setIdentity() {
        this.m00 = this.m11 = (this.m22 = (this.m33 = 1.0));
        this.m01 = this.m02 = (this.m03 = (this.m10 = (this.m12 = (this.m13 = (this.m20 = (this.m21 = (this.m23 = (this.m30 = (this.m31 = (this.m32 = 0.0))))))))));
        return this;
    }

    @NotNull
    public final Matrix4 translate(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.m03 += this.m00 * vec.getX() + this.m01 * vec.getY() + this.m02 * vec.getZ();
        this.m13 += this.m10 * vec.getX() + this.m11 * vec.getY() + this.m12 * vec.getZ();
        this.m23 += this.m20 * vec.getX() + this.m21 * vec.getY() + this.m22 * vec.getZ();
        this.m33 += this.m30 * vec.getX() + this.m31 * vec.getY() + this.m32 * vec.getZ();
        return this;
    }

    @NotNull
    public final Matrix4 scale(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.m00 *= vec.getX();
        this.m10 *= vec.getX();
        this.m20 *= vec.getX();
        this.m30 *= vec.getX();
        this.m01 *= vec.getY();
        this.m11 *= vec.getY();
        this.m21 *= vec.getY();
        this.m31 *= vec.getY();
        this.m02 *= vec.getZ();
        this.m12 *= vec.getZ();
        this.m22 *= vec.getZ();
        this.m32 *= vec.getZ();
        return this;
    }

    @NotNull
    public final Matrix4 rotate(double angle, @NotNull Vector3 axis) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double mc = (double)1.0f - c;
        double xy = axis.getX() * axis.getY();
        double yz = axis.getY() * axis.getZ();
        double xz = axis.getX() * axis.getZ();
        double xs = axis.getX() * s;
        double ys = axis.getY() * s;
        double zs = axis.getZ() * s;
        double f00 = axis.getX() * axis.getX() * mc + c;
        double f10 = xy * mc + zs;
        double f20 = xz * mc - ys;
        double f01 = xy * mc - zs;
        double f11 = axis.getY() * axis.getY() * mc + c;
        double f21 = yz * mc + xs;
        double f02 = xz * mc + ys;
        double f12 = yz * mc - xs;
        double f22 = axis.getZ() * axis.getZ() * mc + c;
        double t00 = this.m00 * f00 + this.m01 * f10 + this.m02 * f20;
        double t10 = this.m10 * f00 + this.m11 * f10 + this.m12 * f20;
        double t20 = this.m20 * f00 + this.m21 * f10 + this.m22 * f20;
        double t30 = this.m30 * f00 + this.m31 * f10 + this.m32 * f20;
        double t01 = this.m00 * f01 + this.m01 * f11 + this.m02 * f21;
        double t11 = this.m10 * f01 + this.m11 * f11 + this.m12 * f21;
        double t21 = this.m20 * f01 + this.m21 * f11 + this.m22 * f21;
        double t31 = this.m30 * f01 + this.m31 * f11 + this.m32 * f21;
        this.m02 = this.m00 * f02 + this.m01 * f12 + this.m02 * f22;
        this.m12 = this.m10 * f02 + this.m11 * f12 + this.m12 * f22;
        this.m22 = this.m20 * f02 + this.m21 * f12 + this.m22 * f22;
        this.m32 = this.m30 * f02 + this.m31 * f12 + this.m32 * f22;
        this.m00 = t00;
        this.m10 = t10;
        this.m20 = t20;
        this.m30 = t30;
        this.m01 = t01;
        this.m11 = t11;
        this.m21 = t21;
        this.m31 = t31;
        return this;
    }

    @NotNull
    public final Matrix4 leftMultiply(@NotNull Matrix4 mat) {
        Intrinsics.checkNotNullParameter(mat, "mat");
        double n00 = this.m00 * mat.m00 + this.m10 * mat.m01 + this.m20 * mat.m02 + this.m30 * mat.m03;
        double n01 = this.m01 * mat.m00 + this.m11 * mat.m01 + this.m21 * mat.m02 + this.m31 * mat.m03;
        double n02 = this.m02 * mat.m00 + this.m12 * mat.m01 + this.m22 * mat.m02 + this.m32 * mat.m03;
        double n03 = this.m03 * mat.m00 + this.m13 * mat.m01 + this.m23 * mat.m02 + this.m33 * mat.m03;
        double n10 = this.m00 * mat.m10 + this.m10 * mat.m11 + this.m20 * mat.m12 + this.m30 * mat.m13;
        double n11 = this.m01 * mat.m10 + this.m11 * mat.m11 + this.m21 * mat.m12 + this.m31 * mat.m13;
        double n12 = this.m02 * mat.m10 + this.m12 * mat.m11 + this.m22 * mat.m12 + this.m32 * mat.m13;
        double n13 = this.m03 * mat.m10 + this.m13 * mat.m11 + this.m23 * mat.m12 + this.m33 * mat.m13;
        double n20 = this.m00 * mat.m20 + this.m10 * mat.m21 + this.m20 * mat.m22 + this.m30 * mat.m23;
        double n21 = this.m01 * mat.m20 + this.m11 * mat.m21 + this.m21 * mat.m22 + this.m31 * mat.m23;
        double n22 = this.m02 * mat.m20 + this.m12 * mat.m21 + this.m22 * mat.m22 + this.m32 * mat.m23;
        double n23 = this.m03 * mat.m20 + this.m13 * mat.m21 + this.m23 * mat.m22 + this.m33 * mat.m23;
        double n30 = this.m00 * mat.m30 + this.m10 * mat.m31 + this.m20 * mat.m32 + this.m30 * mat.m33;
        double n31 = this.m01 * mat.m30 + this.m11 * mat.m31 + this.m21 * mat.m32 + this.m31 * mat.m33;
        double n32 = this.m02 * mat.m30 + this.m12 * mat.m31 + this.m22 * mat.m32 + this.m32 * mat.m33;
        double n33 = this.m03 * mat.m30 + this.m13 * mat.m31 + this.m23 * mat.m32 + this.m33 * mat.m33;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m03 = n03;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
        this.m13 = n13;
        this.m20 = n20;
        this.m21 = n21;
        this.m22 = n22;
        this.m23 = n23;
        this.m30 = n30;
        this.m31 = n31;
        this.m32 = n32;
        this.m33 = n33;
        return this;
    }

    @NotNull
    public final Matrix4 multiply(@NotNull Matrix4 mat) {
        Intrinsics.checkNotNullParameter(mat, "mat");
        double n00 = this.m00 * mat.m00 + this.m01 * mat.m10 + this.m02 * mat.m20 + this.m03 * mat.m30;
        double n01 = this.m00 * mat.m01 + this.m01 * mat.m11 + this.m02 * mat.m21 + this.m03 * mat.m31;
        double n02 = this.m00 * mat.m02 + this.m01 * mat.m12 + this.m02 * mat.m22 + this.m03 * mat.m32;
        double n03 = this.m00 * mat.m03 + this.m01 * mat.m13 + this.m02 * mat.m23 + this.m03 * mat.m33;
        double n10 = this.m10 * mat.m00 + this.m11 * mat.m10 + this.m12 * mat.m20 + this.m13 * mat.m30;
        double n11 = this.m10 * mat.m01 + this.m11 * mat.m11 + this.m12 * mat.m21 + this.m13 * mat.m31;
        double n12 = this.m10 * mat.m02 + this.m11 * mat.m12 + this.m12 * mat.m22 + this.m13 * mat.m32;
        double n13 = this.m10 * mat.m03 + this.m11 * mat.m13 + this.m12 * mat.m23 + this.m13 * mat.m33;
        double n20 = this.m20 * mat.m00 + this.m21 * mat.m10 + this.m22 * mat.m20 + this.m23 * mat.m30;
        double n21 = this.m20 * mat.m01 + this.m21 * mat.m11 + this.m22 * mat.m21 + this.m23 * mat.m31;
        double n22 = this.m20 * mat.m02 + this.m21 * mat.m12 + this.m22 * mat.m22 + this.m23 * mat.m32;
        double n23 = this.m20 * mat.m03 + this.m21 * mat.m13 + this.m22 * mat.m23 + this.m23 * mat.m33;
        double n30 = this.m30 * mat.m00 + this.m31 * mat.m10 + this.m32 * mat.m20 + this.m33 * mat.m30;
        double n31 = this.m30 * mat.m01 + this.m31 * mat.m11 + this.m32 * mat.m21 + this.m33 * mat.m31;
        double n32 = this.m30 * mat.m02 + this.m31 * mat.m12 + this.m32 * mat.m22 + this.m33 * mat.m32;
        double n33 = this.m30 * mat.m03 + this.m31 * mat.m13 + this.m32 * mat.m23 + this.m33 * mat.m33;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m03 = n03;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
        this.m13 = n13;
        this.m20 = n20;
        this.m21 = n21;
        this.m22 = n22;
        this.m23 = n23;
        this.m30 = n30;
        this.m31 = n31;
        this.m32 = n32;
        this.m33 = n33;
        return this;
    }

    @NotNull
    public final Matrix4 transpose() {
        double n10 = this.m01;
        double n20 = this.m02;
        double n30 = this.m03;
        double n01 = this.m10;
        double n21 = this.m12;
        double n31 = this.m13;
        double n02 = this.m20;
        double n12 = this.m21;
        double n32 = this.m23;
        double n03 = this.m30;
        double n13 = this.m31;
        double n23 = this.m32;
        this.m01 = n01;
        this.m02 = n02;
        this.m03 = n03;
        this.m10 = n10;
        this.m12 = n12;
        this.m13 = n13;
        this.m20 = n20;
        this.m21 = n21;
        this.m23 = n23;
        this.m30 = n30;
        this.m31 = n31;
        this.m32 = n32;
        return this;
    }

    @NotNull
    public final Matrix4 copy() {
        return new Matrix4(this);
    }

    @NotNull
    public final Matrix4 set(@NotNull Matrix4 mat) {
        Intrinsics.checkNotNullParameter(mat, "mat");
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m03 = mat.m03;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m13 = mat.m13;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        this.m23 = mat.m23;
        this.m30 = mat.m30;
        this.m31 = mat.m31;
        this.m32 = mat.m32;
        this.m33 = mat.m33;
        return this;
    }

    private final void mult3x3(Vector3 vec) {
        double x = this.m00 * vec.getX() + this.m01 * vec.getY() + this.m02 * vec.getZ();
        double y = this.m10 * vec.getX() + this.m11 * vec.getY() + this.m12 * vec.getZ();
        double z = this.m20 * vec.getX() + this.m21 * vec.getY() + this.m22 * vec.getZ();
        vec.setX(x);
        vec.setY(y);
        vec.setZ(z);
    }

    @NotNull
    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(new BigDecimal(this.m00, cont)).append(',').append(new BigDecimal(this.m01, cont)).append(',').append(new BigDecimal(this.m02, cont)).append(',').append(new BigDecimal(this.m03, cont)).append("]\n[").append(new BigDecimal(this.m10, cont)).append(',').append(new BigDecimal(this.m11, cont)).append(',').append(new BigDecimal(this.m12, cont)).append(',').append(new BigDecimal(this.m13, cont)).append("]\n[").append(new BigDecimal(this.m20, cont)).append(',').append(new BigDecimal(this.m21, cont)).append(',').append(new BigDecimal(this.m22, cont)).append(',');
        stringBuilder.append(new BigDecimal(this.m23, cont)).append("]\n[").append(new BigDecimal(this.m30, cont)).append(',').append(new BigDecimal(this.m31, cont)).append(',').append(new BigDecimal(this.m32, cont)).append(',').append(new BigDecimal(this.m33, cont)).append(']');
        return stringBuilder.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public final void glApply() {
        glBuf.put(this.m00).put(this.m10).put(this.m20).put(this.m30).put(this.m01).put(this.m11).put(this.m21).put(this.m31).put(this.m02).put(this.m12).put(this.m22).put(this.m32).put(this.m03).put(this.m13).put(this.m23).put(this.m33);
        glBuf.flip();
        GL11.glMultMatrix((DoubleBuffer)glBuf);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lalexsocol/asjlib/math/Matrix4$Companion;", "", "<init>", "()V", "glBuf", "Ljava/nio/DoubleBuffer;", "kotlin.jvm.PlatformType", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

