/*
 * Decompiled with CFR 0.152.
 */
package com.KAIIIAK.KASMLib.workers;

import alexsocol.patcher.PatcherConfigHandler;
import com.KAIIIAK.KASMLib.KASMWorker;
import com.KAIIIAK.KASMLib.util.KASMUtil;
import com.KAIIIAK.KASMLib.util.ReflectionLikeUtil;
import com.KAIIIAK.nullsafety.Opt;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ReflectionLikeWorker
extends KASMWorker {
    public static KASMWorker inst = (KASMWorker)KASMUtil.inst();
    public String utilClassName = ReflectionLikeUtil.class.getName().replace(".", "/");
    public boolean ignoreClass;

    @Override
    public void workDataStart() {
    }

    @Override
    public void workDataEnd() {
        this.changes = 0L;
        this.ignoreClass = false;
    }

    @Override
    public boolean workClass(ClassNode classNode) {
        for (String ignClassName : Opt.it(PatcherConfigHandler.INSTANCE.getIgnoredClasses())) {
            if (!this.className.contains(ignClassName) && !this.transformedClassName.contains(ignClassName)) continue;
            this.ignoreClass = true;
            break;
        }
        return false;
    }

    @Override
    public boolean workClassVisibleAnnotation(ClassNode classNode, AnnotationNode annotationNode) {
        if (annotationNode.desc.contains("ScalaSignature")) {
            this.ignoreClass = true;
        }
        return false;
    }

    @Override
    public boolean workClassInvisibleAnnotation(ClassNode classNode, AnnotationNode annotationNode) {
        if (annotationNode.desc.contains("ScalaSignature")) {
            this.ignoreClass = true;
        }
        return false;
    }

    @Override
    public boolean workField(ClassNode classNode, FieldNode fieldNode) {
        if (this.ignoreClass) {
            return false;
        }
        if ("__OBFID".equals(fieldNode.name)) {
            return false;
        }
        for (FieldNode fieldN : Opt.it(classNode.fields)) {
            if (!"__TARGET".equals(fieldN.name)) continue;
            return false;
        }
        for (AnnotationNode annotationNode : Opt.it(classNode.visibleAnnotations)) {
            if (!annotationNode.desc.contains("GameRegistry$ObjectHolder")) continue;
            return false;
        }
        if (PatcherConfigHandler.INSTANCE.getAllPublic()) {
            int access = fieldNode.access;
            fieldNode.access |= 1;
            fieldNode.access &= 0xFFFFFFFD;
            fieldNode.access &= 0xFFFFFFFB;
            if (access != fieldNode.access) {
                ++this.changes;
            }
        }
        return false;
    }

    @Override
    public boolean workMethod(ClassNode classNode, MethodNode methodNode) {
        if (this.ignoreClass) {
            return false;
        }
        if (PatcherConfigHandler.INSTANCE.getAllPublic()) {
            int access = methodNode.access;
            methodNode.access |= 1;
            methodNode.access &= 0xFFFFFFFD;
            methodNode.access &= 0xFFFFFFFB;
            if (access != methodNode.access) {
                ++this.changes;
            }
        }
        return false;
    }

    @Override
    public boolean workInstNode(ClassNode classNode, MethodNode methodNode, MethodInsnNode insnNode) {
        if (!insnNode.owner.equals(this.utilClassName)) {
            return false;
        }
        if (this.changeMethodInsnToFieldInsn(methodNode, insnNode, "GETFIELD", 180)) {
            return true;
        }
        if (this.changeMethodInsnToFieldInsn(methodNode, insnNode, "GETSTATICFIELD", 178)) {
            return true;
        }
        if (this.changeMethodInsnToFieldInsn(methodNode, insnNode, "SETFIELD", 181)) {
            return true;
        }
        return this.changeMethodInsnToFieldInsn(methodNode, insnNode, "SETSTATICFIELD", 179);
    }

    boolean changeMethodInsnToFieldInsn(MethodNode methodNode, MethodInsnNode insnNode, String methodMame, int opcode) {
        AbstractInsnNode previousNode;
        if (insnNode.name.equals(methodMame) && (previousNode = insnNode.getPrevious()) instanceof LdcInsnNode) {
            String[] fieldData;
            LdcInsnNode fieldStringDataNode = (LdcInsnNode)previousNode;
            if (fieldStringDataNode.cst instanceof String && (fieldData = ((String)fieldStringDataNode.cst).split("\\.")).length == 3) {
                String fieldOwner = fieldData[0];
                String fieldName = fieldData[1];
                String fieldDesc = fieldData[2];
                FieldInsnNode fieldInsnNode = new FieldInsnNode(opcode, fieldOwner, fieldName, fieldDesc);
                methodNode.instructions.insertBefore((AbstractInsnNode)fieldStringDataNode, (AbstractInsnNode)fieldInsnNode);
                methodNode.instructions.remove((AbstractInsnNode)fieldStringDataNode);
                ++this.changes;
                return true;
            }
        }
        return false;
    }
}

