/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.patcher;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.command.CommandDimInfo;
import alexsocol.asjlib.command.CommandDimTP;
import alexsocol.asjlib.command.CommandExplode;
import alexsocol.asjlib.command.CommandHeal;
import alexsocol.asjlib.command.CommandHookList;
import alexsocol.asjlib.command.CommandKillAll;
import alexsocol.asjlib.command.CommandResources;
import alexsocol.asjlib.command.CommandRtp;
import alexsocol.asjlib.command.CommandSchema;
import alexsocol.asjlib.command.CommandTop;
import alexsocol.asjlib.command.CommandWolkJpeg;
import alexsocol.asjlib.render.ASJShaderHelper;
import alexsocol.patcher.PatcherConfigHandler;
import alexsocol.patcher.asm.ASJHookLoader;
import alexsocol.patcher.asm.hook.NoEntityInteractionHandler;
import alexsocol.patcher.event.ServerStartedEvent;
import alexsocol.patcher.event.ServerStartingEvent;
import alexsocol.patcher.event.ServerStoppedEvent;
import alexsocol.patcher.event.ServerStoppingEvent;
import alexsocol.patcher.handler.PatcherEventHandler;
import alexsocol.patcher.handler.PatcherEventHandlerClient;
import alexsocol.patcher.handler.PlayerReachDistanceHandler;
import cpw.mods.fml.client.config.GuiUtils;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.Facing;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import ru.vamig.worldengine.WE_Biome;

@Mod(modid="asjpatcher", useMetadata=true, modLanguageAdapter="alexsocol.patcher.KotlinAdapter", guiFactory="alexsocol.patcher.client.GUIFactory")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lalexsocol/patcher/PatcherMain;", "", "<init>", "()V", "MODID", "", "meta", "Lcpw/mods/fml/common/ModMetadata;", "getMeta", "()Lcpw/mods/fml/common/ModMetadata;", "setMeta", "(Lcpw/mods/fml/common/ModMetadata;)V", "construct", "", "e", "Lcpw/mods/fml/common/event/FMLConstructionEvent;", "preInit", "Lcpw/mods/fml/common/event/FMLPreInitializationEvent;", "init", "Lcpw/mods/fml/common/event/FMLInitializationEvent;", "postInit", "Lcpw/mods/fml/common/event/FMLPostInitializationEvent;", "onServerStarting", "Lcpw/mods/fml/common/event/FMLServerStartingEvent;", "onServerStarted", "Lcpw/mods/fml/common/event/FMLServerStartedEvent;", "onServerStopping", "Lcpw/mods/fml/common/event/FMLServerStoppingEvent;", "onServerStopped", "Lcpw/mods/fml/common/event/FMLServerStoppedEvent;", "fixGuiColors", "fixPistonsCrash", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nPatcherMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatcherMain.kt\nalexsocol/patcher/PatcherMain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1869#2,2:130\n*S KotlinDebug\n*F\n+ 1 PatcherMain.kt\nalexsocol/patcher/PatcherMain\n*L\n54#1:130,2\n*E\n"})
public final class PatcherMain {
    @NotNull
    public static final PatcherMain INSTANCE = new PatcherMain();
    @NotNull
    public static final String MODID = "asjpatcher";
    @Mod.Metadata(value="asjpatcher")
    public static ModMetadata meta;

    private PatcherMain() {
    }

    @NotNull
    public final ModMetadata getMeta() {
        ModMetadata modMetadata = meta;
        if (modMetadata != null) {
            return modMetadata;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"meta");
        return null;
    }

    public final void setMeta(@NotNull ModMetadata modMetadata) {
        Intrinsics.checkNotNullParameter((Object)modMetadata, (String)"<set-?>");
        meta = modMetadata;
    }

    @Mod.EventHandler
    public final void construct(@NotNull FMLConstructionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PatcherConfigHandler.INSTANCE.registerChangeHandler(MODID);
        this.fixPistonsCrash();
    }

    @Mod.EventHandler
    public final void preInit(@NotNull FMLPreInitializationEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.fixGuiColors();
        Blocks.melon_stem.setBlockName("melonStem");
        Blocks.piston_head.setBlockName("pistonHead");
        Blocks.piston_extension.setBlockName("pistonExtension");
        Blocks.end_portal.setBlockName("endPortal");
        if (!PatcherConfigHandler.INSTANCE.getAddBlocks()) {
            return;
        }
        Object[] objectArray = new Block[]{Blocks.brewing_stand, Blocks.bed, Blocks.nether_wart, Blocks.cauldron, Blocks.flower_pot, Blocks.wheat, Blocks.reeds, Blocks.cake, Blocks.skull, Blocks.piston_head, Blocks.piston_extension, Blocks.lit_redstone_ore, Blocks.powered_repeater, Blocks.pumpkin_stem, Blocks.standing_sign, Blocks.powered_comparator, Blocks.tripwire, Blocks.lit_redstone_lamp, Blocks.melon_stem, Blocks.unlit_redstone_torch, Blocks.unpowered_comparator, Blocks.redstone_wire, Blocks.wall_sign, Blocks.unpowered_repeater, Blocks.iron_door, Blocks.wooden_door};
        HashSet noItems = SetsKt.hashSetOf((Object[])objectArray);
        if (PatcherConfigHandler.INSTANCE.getAddAir()) {
            ((Collection)noItems).add(Blocks.air);
        }
        Iterable $this$forEach$iv = noItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block = (Block)element$iv;
            boolean bl = false;
            GameData.getMain().registerItem((Item)new ItemBlock(block), Block.blockRegistry.getNameForObject((Object)block) + "_item", Block.getIdFromBlock((Block)block));
        }
    }

    @Mod.EventHandler
    public final void init(@NotNull FMLInitializationEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ExtensionsKt.eventFML(ExtensionsKt.eventForge(PatcherEventHandler.INSTANCE));
        ExtensionsKt.eventForge(PlayerReachDistanceHandler.INSTANCE);
        BlockTrapDoor.disableValidation = PatcherConfigHandler.INSTANCE.getFloatingTrapDoors();
        if (ASJUtilities.isClient()) {
            ExtensionsKt.eventFML(NoEntityInteractionHandler.INSTANCE);
            ExtensionsKt.eventForge(PatcherEventHandlerClient.INSTANCE);
            ASJShaderHelper.INSTANCE.registerHandlers$1_7_10_ASJCore();
            if (!ASJHookLoader.Companion.getOBF()) {
                ClientCommandHandler.instance.registerCommand((ICommand)CommandResources.INSTANCE);
            }
        }
    }

    @Mod.EventHandler
    public final void postInit(@NotNull FMLPostInitializationEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Mod.EventHandler
    public final void onServerStarting(@NotNull FMLServerStartingEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.registerServerCommand((ICommand)CommandDimInfo.INSTANCE);
        e.registerServerCommand((ICommand)CommandDimTP.INSTANCE);
        e.registerServerCommand((ICommand)CommandExplode.INSTANCE);
        e.registerServerCommand((ICommand)CommandHeal.INSTANCE);
        e.registerServerCommand((ICommand)CommandHookList.INSTANCE);
        e.registerServerCommand((ICommand)CommandKillAll.INSTANCE);
        e.registerServerCommand((ICommand)CommandRtp.INSTANCE);
        e.registerServerCommand((ICommand)CommandSchema.INSTANCE);
        e.registerServerCommand((ICommand)CommandTop.INSTANCE);
        e.registerServerCommand((ICommand)CommandWolkJpeg.INSTANCE);
        MinecraftForge.EVENT_BUS.post((Event)new ServerStartingEvent(e));
    }

    @Mod.EventHandler
    public final void onServerStarted(@NotNull FMLServerStartedEvent e) {
        BiomeGenBase biomeGenBase;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MinecraftForge.EVENT_BUS.post((Event)new ServerStartedEvent(e));
        HashMap<String, WE_Biome> hashMap = WE_Biome.biomeList;
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"biomeList");
        if (!((Map)hashMap).isEmpty() && (biomeGenBase = BiomeGenBase.getBiome((int)PatcherConfigHandler.INSTANCE.getWEBiomeID())) != null) {
            BiomeGenBase it = biomeGenBase;
            boolean bl = false;
            throw new IllegalArgumentException("[asjpatcher] WEBiomeID is set to " + PatcherConfigHandler.INSTANCE.getWEBiomeID() + " - this ID is occupied with " + it.biomeName + " (" + it.getClass().getName() + "). Change that in configs!");
        }
    }

    @Mod.EventHandler
    public final void onServerStopping(@NotNull FMLServerStoppingEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MinecraftForge.EVENT_BUS.post((Event)new ServerStoppingEvent(e));
    }

    @Mod.EventHandler
    public final void onServerStopped(@NotNull FMLServerStoppedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MinecraftForge.EVENT_BUS.post((Event)new ServerStoppedEvent(e));
    }

    private final void fixGuiColors() {
        int[] colors = GuiUtils.colorCodes;
        colors[0] = 65793;
        colors[16] = 65793;
    }

    private final void fixPistonsCrash() {
        int n;
        Intrinsics.checkNotNullExpressionValue((Object)Facing.oppositeSide, (String)"oppositeSide");
        int n2 = 0;
        int[] nArray = new int[10];
        int[] nArray2 = Facing.oppositeSide;
        while (n2 < 10) {
            n = n2++;
            nArray[n] = 0;
        }
        Facing.oppositeSide = ArraysKt.plus((int[])nArray2, (int[])nArray);
        Intrinsics.checkNotNullExpressionValue((Object)Facing.offsetsXForSide, (String)"offsetsXForSide");
        n2 = 0;
        nArray = new int[10];
        nArray2 = Facing.offsetsXForSide;
        while (n2 < 10) {
            n = n2++;
            nArray[n] = 0;
        }
        Facing.offsetsXForSide = ArraysKt.plus((int[])nArray2, (int[])nArray);
        Intrinsics.checkNotNullExpressionValue((Object)Facing.offsetsYForSide, (String)"offsetsYForSide");
        n2 = 0;
        nArray = new int[10];
        nArray2 = Facing.offsetsYForSide;
        while (n2 < 10) {
            n = n2++;
            nArray[n] = 0;
        }
        Facing.offsetsYForSide = ArraysKt.plus((int[])nArray2, (int[])nArray);
        Intrinsics.checkNotNullExpressionValue((Object)Facing.offsetsZForSide, (String)"offsetsZForSide");
        n2 = 0;
        nArray = new int[10];
        nArray2 = Facing.offsetsZForSide;
        while (n2 < 10) {
            n = n2++;
            nArray[n] = 0;
        }
        Facing.offsetsZForSide = ArraysKt.plus((int[])nArray2, (int[])nArray);
    }
}

