/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.math;

import alexsocol.asjlib.math.Vector3;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004B)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006%"}, d2={"Lalexsocol/asjlib/math/Quaternion;", "", "quat", "<init>", "(Lalexsocol/asjlib/math/Quaternion;)V", "d", "", "d1", "d2", "d3", "(DDDD)V", "x", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "z", "getZ", "setZ", "s", "getS", "setS", "set", "", "multiply", "rightMultiply", "mag", "normalize", "rotate", "vec", "Lalexsocol/asjlib/math/Vector3;", "toString", "", "Companion", "1.7.10-ASJCore"})
public final class Quaternion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;
    private double s;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double getS() {
        return this.s;
    }

    public final void setS(double d) {
        this.s = d;
    }

    public Quaternion(@NotNull Quaternion quat) {
        Intrinsics.checkNotNullParameter(quat, "quat");
        this.s = 1.0;
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.s = quat.s;
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this.s = 1.0;
        this.x = d1;
        this.y = d2;
        this.z = d3;
        this.s = d;
    }

    public final void set(@NotNull Quaternion quat) {
        Intrinsics.checkNotNullParameter(quat, "quat");
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.s = quat.s;
    }

    public final void multiply(@NotNull Quaternion quat) {
        Intrinsics.checkNotNullParameter(quat, "quat");
        double d = this.s * quat.s - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        double d1 = this.s * quat.x + this.x * quat.s - this.y * quat.z + this.z * quat.y;
        double d2 = this.s * quat.y + this.x * quat.z + this.y * quat.s - this.z * quat.x;
        double d3 = this.s * quat.z - this.x * quat.y + this.y * quat.x + this.z * quat.s;
        this.s = d;
        this.x = d1;
        this.y = d2;
        this.z = d3;
    }

    public final void rightMultiply(@NotNull Quaternion quat) {
        Intrinsics.checkNotNullParameter(quat, "quat");
        double d = this.s * quat.s - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        double d1 = this.s * quat.x + this.x * quat.s + this.y * quat.z - this.z * quat.y;
        double d2 = this.s * quat.y - this.x * quat.z + this.y * quat.s + this.z * quat.x;
        double d3 = this.s * quat.z + this.x * quat.y - this.y * quat.x + this.z * quat.s;
        this.s = d;
        this.x = d1;
        this.y = d2;
        this.z = d3;
    }

    public final double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.s * this.s);
    }

    public final void normalize() {
        double d = this.mag();
        if (!(d == 0.0)) {
            d = 1.0 / d;
            this.x *= d;
            this.y *= d;
            this.z *= d;
            this.s *= d;
        }
    }

    public final void rotate(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d = -this.x * vec.getX() - this.y * vec.getY() - this.z * vec.getZ();
        double d1 = this.s * vec.getX() + this.y * vec.getZ() - this.z * vec.getY();
        double d2 = this.s * vec.getY() - this.x * vec.getZ() + this.z * vec.getX();
        double d3 = this.s * vec.getZ() + this.x * vec.getY() - this.y * vec.getX();
        vec.setX(d1 * this.s - d * this.x - d2 * this.z + d3 * this.y);
        vec.setY(d2 * this.s - d * this.y + d1 * this.z - d3 * this.x);
        vec.setZ(d3 * this.s - d * this.z - d1 * this.y + d2 * this.x);
    }

    @NotNull
    public String toString() {
        return "Quaternion: <" + this.s + ' ' + this.x + ' ' + this.y + ' ' + this.z + '>';
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lalexsocol/asjlib/math/Quaternion$Companion;", "", "<init>", "()V", "aroundAxis", "Lalexsocol/asjlib/math/Quaternion;", "ax", "", "ay", "az", "angle", "axis", "Lalexsocol/asjlib/math/Vector3;", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quaternion aroundAxis(double ax, double ay, double az, double angle) {
            double ang = angle;
            double d4 = Math.sin(ang *= 0.5);
            return new Quaternion(Math.cos(ang), ax * d4, ay * d4, az * d4);
        }

        @NotNull
        public final Quaternion aroundAxis(@NotNull Vector3 axis, double angle) {
            Intrinsics.checkNotNullParameter(axis, "axis");
            return this.aroundAxis(axis.getX(), axis.getY(), axis.getZ(), angle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

