/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ(\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u000eJ&\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u0017H\u0007J$\u0010\u001a\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J(\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000bH\u0002J \u0010#\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u00102\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R!\u0010,\u001a\u0012\u0012\u0004\u0012\u00020.0-j\b\u0012\u0004\u0012\u00020.`/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u00064"}, d2={"Lalexsocol/asjlib/render/ASJShaderHelper;", "Lnet/minecraft/client/resources/IResourceManagerReloadListener;", "<init>", "()V", "crashOnError", "", "getCrashOnError", "()Z", "setCrashOnError", "(Z)V", "FRAG", "", "VERT", "registerHandlers", "", "registerHandlers$1_7_10_ASJCore", "useShader", "shaderID", "callback", "Lkotlin/Function1;", "releaseShader", "createProgram", "vertLocation", "", "fragLocation", "modid", "createProgramInner", "createShader", "filename", "shaderType", "manager", "Lnet/minecraft/client/resources/IResourceManager;", "getShaderLogInfo", "obj", "getProgramLogInfo", "readFileAsString", "gameTicks", "total", "", "getTotal", "()F", "clientTickEnd", "event", "Lcpw/mods/fml/common/gameevent/TickEvent$ClientTickEvent;", "shaders", "Ljava/util/HashSet;", "Lalexsocol/asjlib/render/ASJShaderHelper$Shader;", "Lkotlin/collections/HashSet;", "getShaders", "()Ljava/util/HashSet;", "onResourceManagerReload", "Shader", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nASJShaderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASJShaderHelper.kt\nalexsocol/asjlib/render/ASJShaderHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1#2:230\n1869#3,2:231\n*S KotlinDebug\n*F\n+ 1 ASJShaderHelper.kt\nalexsocol/asjlib/render/ASJShaderHelper\n*L\n171#1:231,2\n*E\n"})
public final class ASJShaderHelper
implements IResourceManagerReloadListener {
    @NotNull
    public static final ASJShaderHelper INSTANCE = new ASJShaderHelper();
    private static boolean crashOnError = true;
    private static final int FRAG = 35632;
    private static final int VERT = 35633;
    private static int gameTicks;
    @NotNull
    private static final HashSet<Shader> shaders;

    private ASJShaderHelper() {
    }

    public final boolean getCrashOnError() {
        return crashOnError;
    }

    public final void setCrashOnError(boolean bl) {
        crashOnError = bl;
    }

    public final void registerHandlers$1_7_10_ASJCore() {
        block0: {
            ExtensionsKt.eventFML(this);
            IResourceManager iResourceManager = ExtensionsClientKt.getMc().func_110442_L();
            IReloadableResourceManager iReloadableResourceManager = iResourceManager instanceof IReloadableResourceManager ? (IReloadableResourceManager)iResourceManager : null;
            if (iReloadableResourceManager == null) break block0;
            iReloadableResourceManager.func_110542_a((IResourceManagerReloadListener)this);
        }
    }

    @JvmOverloads
    public final void useShader(int shaderID, @Nullable Function1<? super Integer, Unit> callback) {
        block2: {
            if (!OpenGlHelper.field_148824_g) {
                return;
            }
            GL20.glUseProgram((int)shaderID);
            if (shaderID == 0) break block2;
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shaderID, (CharSequence)"ftime"), (float)(this.getTotal() / 20.0f));
            Function1<? super Integer, Unit> function1 = callback;
            if (function1 != null) {
                function1.invoke((Integer)shaderID);
            }
        }
    }

    public static /* synthetic */ void useShader$default(ASJShaderHelper aSJShaderHelper, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = null;
        }
        aSJShaderHelper.useShader(n, function1);
    }

    public final void releaseShader() {
        ASJShaderHelper.useShader$default(this, 0, null, 2, null);
    }

    @JvmOverloads
    public final int createProgram(@Nullable String vertLocation, @Nullable String fragLocation, @NotNull String modid) {
        int n;
        Intrinsics.checkNotNullParameter(modid, "modid");
        try {
            n = this.createProgramInner(vertLocation, fragLocation, modid);
        }
        catch (Throwable e) {
            if (crashOnError) {
                throw e;
            }
            n = 0;
        }
        return n;
    }

    public static /* synthetic */ int createProgram$default(ASJShaderHelper aSJShaderHelper, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = Loader.instance().activeModContainer().getModId();
        }
        return aSJShaderHelper.createProgram(string, string2, string3);
    }

    private final int createProgramInner(String vertLocation, String fragLocation, String modid) {
        int it;
        String info;
        if (!OpenGlHelper.field_148824_g) {
            return 0;
        }
        int programID = GL20.glCreateProgram();
        if (programID == 0) {
            return 0;
        }
        Shader shader = new Shader(programID, modid, vertLocation, fragLocation);
        Integer vertID = null;
        Integer fragID = null;
        CharSequence charSequence = vertLocation;
        if (!(charSequence == null || charSequence.length() == 0)) {
            IResourceManager iResourceManager = ExtensionsClientKt.getMc().func_110442_L();
            Intrinsics.checkNotNullExpressionValue(iResourceManager, "getResourceManager(...)");
            vertID = this.createShader(vertLocation, 35633, modid, iResourceManager);
            GL20.glAttachShader((int)programID, (int)vertID);
            shader.setVertexID(vertID);
        }
        if (!((charSequence = (CharSequence)fragLocation) == null || charSequence.length() == 0)) {
            IResourceManager iResourceManager = ExtensionsClientKt.getMc().func_110442_L();
            Intrinsics.checkNotNullExpressionValue(iResourceManager, "getResourceManager(...)");
            fragID = this.createShader(fragLocation, 35632, modid, iResourceManager);
            GL20.glAttachShader((int)programID, (int)fragID);
            shader.setFragmentID(fragID);
        }
        GL20.glLinkProgram((int)programID);
        if (GL20.glGetProgrami((int)programID, (int)35714) == 0) {
            int it2;
            info = this.getProgramLogInfo(programID);
            GL20.glDeleteProgram((int)programID);
            Integer n = vertID;
            if (n != null) {
                it2 = ((Number)n).intValue();
                boolean bl = false;
                GL20.glDeleteShader((int)it2);
            }
            Integer n2 = fragID;
            if (n2 != null) {
                it2 = ((Number)n2).intValue();
                boolean bl = false;
                GL20.glDeleteShader((int)it2);
            }
            throw new RuntimeException("Error Linking program [" + vertLocation + " x " + fragLocation + "]: " + info);
        }
        Integer n = vertID;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl = false;
            GL20.glDetachShader((int)programID, (int)it);
            GL20.glDeleteShader((int)it);
        }
        Integer n3 = fragID;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl = false;
            GL20.glDetachShader((int)programID, (int)it);
            GL20.glDeleteShader((int)it);
        }
        GL20.glValidateProgram((int)programID);
        if (GL20.glGetProgrami((int)programID, (int)35715) == 0) {
            int it3;
            info = this.getProgramLogInfo(programID);
            GL20.glDeleteProgram((int)programID);
            Integer n4 = vertID;
            if (n4 != null) {
                it3 = ((Number)n4).intValue();
                boolean bl = false;
                GL20.glDeleteShader((int)it3);
            }
            Integer n5 = fragID;
            if (n5 != null) {
                it3 = ((Number)n5).intValue();
                boolean bl = false;
                GL20.glDeleteShader((int)it3);
            }
            throw new RuntimeException("Error Validating program [" + vertLocation + " x " + fragLocation + "]: " + info);
        }
        ((Collection)shaders).add(shader);
        return programID;
    }

    private final int createShader(String filename, int shaderType, String modid, IResourceManager manager) {
        int shaderID = 0;
        try {
            shaderID = GL20.glCreateShader((int)shaderType);
            if (shaderID == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shaderID, (CharSequence)this.readFileAsString(filename, modid, manager));
            GL20.glCompileShader((int)shaderID);
            if (GL20.glGetShaderi((int)shaderID, (int)35713) == 0) {
                throw new RuntimeException("Error Compiling shader [" + filename + "]: " + this.getShaderLogInfo(shaderID));
            }
            return shaderID;
        }
        catch (Exception e) {
            GL20.glDeleteShader((int)shaderID);
            ASJUtilities.error("Error creating shader.", e);
            return -1;
        }
    }

    private final String getShaderLogInfo(int obj) {
        String string = GL20.glGetShaderInfoLog((int)obj, (int)GL20.glGetShaderi((int)obj, (int)35716));
        Intrinsics.checkNotNullExpressionValue(string, "glGetShaderInfoLog(...)");
        return string;
    }

    private final String getProgramLogInfo(int obj) {
        String string = GL20.glGetProgramInfoLog((int)obj, (int)GL20.glGetProgrami((int)obj, (int)35716));
        Intrinsics.checkNotNullExpressionValue(string, "glGetProgramInfoLog(...)");
        return string;
    }

    private final String readFileAsString(String filename, String modid, IResourceManager manager) throws Exception {
        InputStream inputStream = ExtensionsClientKt.getMc().func_110442_L().func_110536_a(new ResourceLocation(modid, filename)).func_110527_b();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        return StringsKt.decodeToString(ByteStreamsKt.readBytes(inputStream));
    }

    private final float getTotal() {
        return (float)gameTicks + ExtensionsClientKt.getMc().field_71428_T.field_74281_c;
    }

    @SubscribeEvent
    public final void clientTickEnd(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase != TickEvent.Phase.END || ExtensionsClientKt.getMc().func_147113_T()) {
            return;
        }
        int n = gameTicks;
        gameTicks = n + 1;
    }

    @NotNull
    public final HashSet<Shader> getShaders() {
        return shaders;
    }

    public void func_110549_a(@NotNull IResourceManager manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        Iterable $this$forEach$iv = shaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it;
            Integer fragID;
            Integer vertID;
            Integer oldFragmentID;
            Integer oldVertexID;
            Shader shader;
            block15: {
                int it2;
                shader = (Shader)element$iv;
                boolean bl = false;
                int programID = shader.component1();
                String modid = shader.component2();
                String vertLocation = shader.component3();
                String fragLocation = shader.component4();
                oldVertexID = shader.component5();
                oldFragmentID = shader.component6();
                Integer n = oldVertexID;
                if (n != null) {
                    it2 = ((Number)n).intValue();
                    boolean bl2 = false;
                    GL20.glDetachShader((int)programID, (int)it2);
                }
                Integer n2 = oldFragmentID;
                if (n2 != null) {
                    it2 = ((Number)n2).intValue();
                    boolean bl3 = false;
                    GL20.glDetachShader((int)programID, (int)it2);
                }
                vertID = null;
                fragID = null;
                try {
                    int it3;
                    String info;
                    CharSequence bl3 = vertLocation;
                    if (!(bl3 == null || bl3.length() == 0)) {
                        IResourceManager iResourceManager = ExtensionsClientKt.getMc().func_110442_L();
                        Intrinsics.checkNotNullExpressionValue(iResourceManager, "getResourceManager(...)");
                        vertID = INSTANCE.createShader(vertLocation, 35633, modid, iResourceManager);
                        GL20.glAttachShader((int)programID, (int)vertID);
                    }
                    if (!((bl3 = (CharSequence)fragLocation) == null || bl3.length() == 0)) {
                        IResourceManager iResourceManager = ExtensionsClientKt.getMc().func_110442_L();
                        Intrinsics.checkNotNullExpressionValue(iResourceManager, "getResourceManager(...)");
                        fragID = INSTANCE.createShader(fragLocation, 35632, modid, iResourceManager);
                        GL20.glAttachShader((int)programID, (int)fragID);
                    }
                    GL20.glLinkProgram((int)programID);
                    if (GL20.glGetProgrami((int)programID, (int)35714) == 0) {
                        info = INSTANCE.getProgramLogInfo(programID);
                        Integer n3 = vertID;
                        if (n3 != null) {
                            it3 = ((Number)n3).intValue();
                            boolean bl4 = false;
                            GL20.glDeleteShader((int)it3);
                        }
                        Integer n4 = fragID;
                        if (n4 != null) {
                            it3 = ((Number)n4).intValue();
                            boolean bl5 = false;
                            GL20.glDeleteShader((int)it3);
                        }
                        throw new RuntimeException("Error Linking program [" + vertLocation + " x " + fragLocation + "]: " + info);
                    }
                    GL20.glValidateProgram((int)programID);
                    if (GL20.glGetProgrami((int)programID, (int)35715) != 0) break block15;
                    info = INSTANCE.getProgramLogInfo(programID);
                    Integer n5 = vertID;
                    if (n5 != null) {
                        it3 = ((Number)n5).intValue();
                        boolean bl6 = false;
                        GL20.glDeleteShader((int)it3);
                    }
                    Integer n6 = fragID;
                    if (n6 != null) {
                        it3 = ((Number)n6).intValue();
                        boolean bl7 = false;
                        GL20.glDeleteShader((int)it3);
                    }
                    throw new RuntimeException("Error Validating program [" + vertLocation + " x " + fragLocation + "]: " + info);
                }
                catch (RuntimeException e) {
                    int it4;
                    ASJUtilities.error("Exception during shaders reload:", e);
                    Integer n7 = oldVertexID;
                    if (n7 != null) {
                        it4 = ((Number)n7).intValue();
                        boolean bl8 = false;
                        GL20.glAttachShader((int)programID, (int)it4);
                    }
                    Integer n8 = oldFragmentID;
                    if (n8 == null) continue;
                    it4 = ((Number)n8).intValue();
                    boolean bl9 = false;
                    GL20.glAttachShader((int)programID, (int)it4);
                    continue;
                }
            }
            Integer n = oldVertexID;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                GL20.glDeleteShader((int)it);
            }
            Integer n9 = oldFragmentID;
            if (n9 != null) {
                it = ((Number)n9).intValue();
                boolean bl = false;
                GL20.glDeleteShader((int)it);
            }
            shader.setVertexID(vertID);
            shader.setFragmentID(fragID);
        }
    }

    @JvmOverloads
    public final void useShader(int shaderID) {
        ASJShaderHelper.useShader$default(this, shaderID, null, 2, null);
    }

    @JvmOverloads
    public final int createProgram(@Nullable String vertLocation, @Nullable String fragLocation) {
        return ASJShaderHelper.createProgram$default(this, vertLocation, fragLocation, null, 4, null);
    }

    static {
        shaders = new HashSet();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J5\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014\u00a8\u0006%"}, d2={"Lalexsocol/asjlib/render/ASJShaderHelper$Shader;", "", "programId", "", "modid", "", "vertexPath", "fragmentPath", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getProgramId", "()I", "getModid", "()Ljava/lang/String;", "getVertexPath", "getFragmentPath", "vertexID", "getVertexID", "()Ljava/lang/Integer;", "setVertexID", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "fragmentID", "getFragmentID", "setFragmentID", "component5", "component6", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "1.7.10-ASJCore"})
    public static final class Shader {
        private final int programId;
        @NotNull
        private final String modid;
        @Nullable
        private final String vertexPath;
        @Nullable
        private final String fragmentPath;
        @Nullable
        private Integer vertexID;
        @Nullable
        private Integer fragmentID;

        public Shader(int programId, @NotNull String modid, @Nullable String vertexPath, @Nullable String fragmentPath) {
            Intrinsics.checkNotNullParameter(modid, "modid");
            this.programId = programId;
            this.modid = modid;
            this.vertexPath = vertexPath;
            this.fragmentPath = fragmentPath;
        }

        public final int getProgramId() {
            return this.programId;
        }

        @NotNull
        public final String getModid() {
            return this.modid;
        }

        @Nullable
        public final String getVertexPath() {
            return this.vertexPath;
        }

        @Nullable
        public final String getFragmentPath() {
            return this.fragmentPath;
        }

        @Nullable
        public final Integer getVertexID() {
            return this.vertexID;
        }

        public final void setVertexID(@Nullable Integer n) {
            this.vertexID = n;
        }

        @Nullable
        public final Integer getFragmentID() {
            return this.fragmentID;
        }

        public final void setFragmentID(@Nullable Integer n) {
            this.fragmentID = n;
        }

        @Nullable
        public final Integer component5() {
            return this.vertexID;
        }

        @Nullable
        public final Integer component6() {
            return this.fragmentID;
        }

        public final int component1() {
            return this.programId;
        }

        @NotNull
        public final String component2() {
            return this.modid;
        }

        @Nullable
        public final String component3() {
            return this.vertexPath;
        }

        @Nullable
        public final String component4() {
            return this.fragmentPath;
        }

        @NotNull
        public final Shader copy(int programId, @NotNull String modid, @Nullable String vertexPath, @Nullable String fragmentPath) {
            Intrinsics.checkNotNullParameter(modid, "modid");
            return new Shader(programId, modid, vertexPath, fragmentPath);
        }

        public static /* synthetic */ Shader copy$default(Shader shader, int n, String string, String string2, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = shader.programId;
            }
            if ((n2 & 2) != 0) {
                string = shader.modid;
            }
            if ((n2 & 4) != 0) {
                string2 = shader.vertexPath;
            }
            if ((n2 & 8) != 0) {
                string3 = shader.fragmentPath;
            }
            return shader.copy(n, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Shader(programId=" + this.programId + ", modid=" + this.modid + ", vertexPath=" + this.vertexPath + ", fragmentPath=" + this.fragmentPath + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.programId);
            result = result * 31 + this.modid.hashCode();
            result = result * 31 + (this.vertexPath == null ? 0 : this.vertexPath.hashCode());
            result = result * 31 + (this.fragmentPath == null ? 0 : this.fragmentPath.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Shader)) {
                return false;
            }
            Shader shader = (Shader)other;
            if (this.programId != shader.programId) {
                return false;
            }
            if (!Intrinsics.areEqual(this.modid, shader.modid)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.vertexPath, shader.vertexPath)) {
                return false;
            }
            return Intrinsics.areEqual(this.fragmentPath, shader.fragmentPath);
        }
    }
}

