/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.patcher.handler;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.patcher.PatcherConfigHandler;
import alexsocol.patcher.network.MessageUUID;
import alexsocol.patcher.network.NetworkHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.channel.ChannelOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lalexsocol/patcher/handler/PatcherEventHandler;", "", "<init>", "()V", "livingAttackEventHandler", "", "e", "Lnet/minecraftforge/event/entity/living/LivingAttackEvent;", "disableDamageInCreative", "noAttackAfterDeath", "disableExplosions", "Lnet/minecraftforge/event/world/ExplosionEvent$Start;", "fixNaNHealthBug", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "flyingBreakingSpeed", "Lnet/minecraftforge/event/entity/player/PlayerEvent$BreakSpeed;", "assignFoodStatsHost", "Lcpw/mods/fml/common/gameevent/TickEvent$PlayerTickEvent;", "syncXpAndAbsorption", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "setNoTcpDelay", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerLoggedInEvent;", "syncEntityUUID", "Lnet/minecraftforge/event/entity/player/PlayerEvent$StartTracking;", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nPatcherEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatcherEventHandler.kt\nalexsocol/patcher/handler/PatcherEventHandler\n+ 2 Extensions.kt\nalexsocol/asjlib/ExtensionsKt\n*L\n1#1,93:1\n103#2,4:94\n*S KotlinDebug\n*F\n+ 1 PatcherEventHandler.kt\nalexsocol/patcher/handler/PatcherEventHandler\n*L\n84#1:94,4\n*E\n"})
public final class PatcherEventHandler {
    @NotNull
    public static final PatcherEventHandler INSTANCE = new PatcherEventHandler();

    private PatcherEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void livingAttackEventHandler(@NotNull LivingAttackEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.disableDamageInCreative(e);
        this.noAttackAfterDeath(e);
    }

    public final void disableDamageInCreative(@NotNull LivingAttackEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!PatcherConfigHandler.INSTANCE.getCreativeDamage()) {
            Entity entity = e.entity;
            EntityPlayer entityPlayer = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
            boolean bl = entityPlayer != null && (entityPlayer = entityPlayer.field_71075_bZ) != null ? entityPlayer.field_75098_d : false;
            if (bl) {
                e.setCanceled(true);
            }
        }
    }

    public final void noAttackAfterDeath(@NotNull LivingAttackEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Entity entity = e.source.func_76364_f();
        boolean bl = entity != null ? entity.field_70128_L : false;
        if (bl) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void disableExplosions(@NotNull ExplosionEvent.Start e) {
        Intrinsics.checkNotNullParameter(e, "e");
        e.setCanceled(!PatcherConfigHandler.INSTANCE.getExplosions());
    }

    @SubscribeEvent
    public final void fixNaNHealthBug(@NotNull LivingEvent.LivingUpdateEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        EntityLivingBase target = e.entityLiving;
        float max = target.func_110138_aP();
        if (Float.isNaN(max)) {
            max = ExtensionsKt.getF(target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
        }
        if (Float.isNaN(max)) {
            max = ExtensionsKt.getF(target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        }
        if (Float.isNaN(max)) {
            max = 20.0f;
        }
        if (Float.isNaN(target.func_110143_aJ())) {
            target.func_70606_j(max);
        }
        if (Float.isNaN(target.field_70735_aL)) {
            target.field_70735_aL = target.func_110143_aJ();
        }
        if (Float.isNaN(target.field_110153_bc)) {
            target.field_110153_bc = 0.0f;
        }
        if (Float.isNaN(target.func_110139_bj())) {
            target.func_110149_m(0.0f);
        }
        if (target.func_110143_aJ() > max) {
            target.func_70606_j(max);
        }
        if (target.func_110143_aJ() < 0.0f) {
            target.func_70606_j(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void flyingBreakingSpeed(@NotNull PlayerEvent.BreakSpeed e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!PatcherConfigHandler.INSTANCE.getFlyFastDig() || e.entityPlayer.field_70122_E || !e.entityPlayer.field_71075_bZ.field_75100_b && !e.entityPlayer.func_70617_f_()) {
            return;
        }
        e.newSpeed *= 5.0f;
    }

    @SubscribeEvent
    public final void assignFoodStatsHost(@NotNull TickEvent.PlayerTickEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        e.player.func_71024_bL().ASJCore_host = e.player;
    }

    @SubscribeEvent
    public final void syncXpAndAbsorption(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        EntityPlayer entityPlayer = e.player;
        EntityPlayerMP entityPlayerMP = entityPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)entityPlayer : null;
        if (entityPlayerMP == null) {
            return;
        }
        EntityPlayerMP player = entityPlayerMP;
        player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        player.func_70096_w().func_82708_h(17);
    }

    @SubscribeEvent
    public final void setNoTcpDelay(@NotNull PlayerEvent.PlayerLoggedInEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!PatcherConfigHandler.INSTANCE.getTcpNoDelay()) {
            return;
        }
        EntityPlayer entityPlayer = e.player;
        EntityPlayerMP entityPlayerMP = entityPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)entityPlayer : null;
        if (entityPlayerMP == null) {
            return;
        }
        EntityPlayerMP player = entityPlayerMP;
        boolean $i$f$try_ = false;
        try {
            boolean bl = false;
            player.field_71135_a.field_147371_a.channel().config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
        }
        catch (Throwable throwable) {
        }
    }

    @SubscribeEvent
    public final void syncEntityUUID(@NotNull PlayerEvent.StartTracking e) {
        Intrinsics.checkNotNullParameter(e, "e");
        SimpleNetworkWrapper simpleNetworkWrapper = NetworkHandler.INSTANCE.getNetwork();
        int n = e.target.func_145782_y();
        String string = e.target.func_110124_au().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        EntityPlayer entityPlayer = e.entityPlayer;
        EntityPlayerMP entityPlayerMP = entityPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)entityPlayer : null;
        if (entityPlayerMP == null) {
            return;
        }
        simpleNetworkWrapper.sendTo((IMessage)new MessageUUID(n, string), entityPlayerMP);
    }
}

