//package alexsocol.mfa
//
//import alexsocol.asjlib.*
//import alexsocol.asjlib.extendables.ASJConfigHandler
//import alexsocol.asjlib.extendables.block.*
//import alexsocol.asjlib.math.Vector3
//import alexsocol.asjlib.network.ASJPacket
//import alexsocol.patcher.KotlinAdapter
//import cpw.mods.fml.common.Mod
//import cpw.mods.fml.common.event.FMLPreInitializationEvent
//import cpw.mods.fml.common.network.simpleimpl.*
//import cpw.mods.fml.common.registry.GameRegistry
//import cpw.mods.fml.relauncher.*
//import ic2.api.energy.prefab.BasicSink
//import net.minecraft.block.Block
//import net.minecraft.block.material.Material
//import net.minecraft.client.gui.inventory.GuiContainer
//import net.minecraft.client.renderer.texture.IIconRegister
//import net.minecraft.client.resources.I18n
//import net.minecraft.creativetab.CreativeTabs
//import net.minecraft.entity.item.EntityItem
//import net.minecraft.entity.player.*
//import net.minecraft.inventory.*
//import net.minecraft.item.ItemStack
//import net.minecraft.nbt.NBTTagCompound
//import net.minecraft.tileentity.TileEntity
//import net.minecraft.util.*
//import net.minecraft.world.World
//import net.minecraftforge.common.config.Configuration
//import net.minecraftforge.common.util.ForgeDirection
//import net.minecraftforge.fluids.*
//import org.lwjgl.opengl.GL11
//
//const val MODID = "mfa"
//
//@Mod(modid = MODID, name = "Mass Fabricator Aggregator", version = "1", dependencies = "required-after:IC2", modLanguageAdapter = KotlinAdapter.className)
//object MFACore {
//	
//	lateinit var network: SimpleNetworkWrapper
//	lateinit var mfa: Block
//	
//	@Mod.EventHandler
//	fun preInit(event: FMLPreInitializationEvent) {
//		MFAConfigHandler.loadConfig(event.suggestedConfigurationFile)
//		
//		network = SimpleNetworkWrapper(MODID)
//		network.registerMessage(MessageOpenGUI, MessageOpenGUI::class.java, 0, Side.CLIENT)
//		
//		mfa = BlockMFA()
//		GameRegistry.registerTileEntity(TileMFA::class.java, "$MODID.MFA")
//	}
//}
//
//object MFAConfigHandler: ASJConfigHandler() {
//	
//	var capacityEU = 1_000_000_000
//	var capacityMB = 1_000_000
//	var generators = arrayOf("IC2:blockMachine:14")
//	var tier = 1
//	var values: Map<String, Pair<Int, Int>> = HashMap()
//	
//	override fun readProperties() {
//		capacityEU = loadProp(Configuration.CATEGORY_GENERAL, "capacityEU", capacityEU, false, "MFA energy capacity", 1)
//		capacityMB = loadProp(Configuration.CATEGORY_GENERAL, "capacityMB", capacityMB, false, "MFA fluids capacity", 1)
//		generators = loadProp(Configuration.CATEGORY_GENERAL, "generators", generators, false, "Blocks valid for MFA inventory (modid:name:meta)", false)
//		tier = loadProp(Configuration.CATEGORY_GENERAL, "tier", tier, false, "tier", 1)
//		values = loadProp(Configuration.CATEGORY_GENERAL, "values", arrayOf("IC2:blockMachine:14--1000000:1"), false, "Values for mass production (modid:name:meta--cost:volume)", false).associate {
//			val (name, values) = it.split("--")
//			val (cost, volume) = values.split(':')
//			name to (cost.toInt() to volume.toInt())
//		}
//	}
//}
//
//class BlockMFA: BlockModContainerMeta(Material.iron, 1, MODID, "MFA", CreativeTabs.tabRedstone, 3f) {
//	
//	override fun createNewTileEntity(world: World?, meta: Int) = TileMFA()
//	
//	override fun registerBlockIcons(reg: IIconRegister) {
//		icons = Array(6) { reg.registerIcon("$MODID:MFA$it") }
//	}
//	
//	override fun getIcon(side: Int, meta: Int) = icons.safeGet(side)
//	
//	override fun onBlockActivated(world: World, x: Int, y: Int, z: Int, player: EntityPlayer, side: Int, hitX: Float, hitY: Float, hitZ: Float): Boolean {
//		val tile = world.getTileEntity(x, y, z) as? TileMFA ?: return false
//		if (player !is EntityPlayerMP) return true
//		
//		player.getNextWindowId()
//		player.openContainer = ContainerMFA(player.inventory, tile)
//		player.openContainer.windowId = player.currentWindowId
//		player.openContainer.addCraftingToCrafters(player)
//		MFACore.network.sendTo(MessageOpenGUI(player.currentWindowId, x, y, z), player)
//		
//		return true
//	}
//	
//	override fun breakBlock(world: World, x: Int, y: Int, z: Int, block: Block?, meta: Int) {
//		val tile = world.getTileEntity(x, y, z) as? TileMFA ?: return
//		
//		for (stack in tile.inventory)
//			EntityItem(world, x + 0.5, y + 0.5, z + 0.5, stack ?: return).spawn()
//		
//		super.breakBlock(world, x, y, z, block, meta)
//	}
//	
//	override fun hasComparatorInputOverride() = true
//	
//	override fun getComparatorInputOverride(world: World, x: Int, y: Int, z: Int, side: Int) =
//		Container.calcRedstoneFromInventory(world.getTileEntity(x, y, z) as IInventory)
//}
//
//class TileMFA: ASJTile(), IInventory, IFluidHandler {
//	
//	var inventory = arrayOfNulls<ItemStack>(9)
//	var powerHandlerIC2 = IC2EnergyHandler(this, MFAConfigHandler.capacityEU, MFAConfigHandler.tier)
//	val tank = FluidTank(uuStack.copy(), MFAConfigHandler.capacityMB)
//	
//	override fun updateEntity() {
//		powerHandlerIC2.updateEntity()
//		
//		out@ for (stack in inventory) {
//			stack ?: continue
//			val name = GameRegistry.findUniqueIdentifierFor(stack.item)?.toString() ?: continue
//			val (cost, volume) = MFAConfigHandler.values["$name:${stack.meta}"] ?: continue
//			
//			for (c in 0 until stack.stackSize) {
//				val fluid = uuStack.copy()
//				fluid.amount = volume
//				
//				if (tank.fill(fluid, false) != volume) continue@out
//				if (!powerHandlerIC2.consumeEnergy(cost.D)) continue@out
//				
//				tank.fill(fluid, true)
//			}
//		}
//	}
//	
//	override fun onChunkUnload() {
//		powerHandlerIC2.onChunkUnload()
//		super.onChunkUnload()
//	}
//	
//	override fun invalidate() {
//		powerHandlerIC2.invalidate()
//		super.invalidate()
//	}
//	
//	override fun writeCustomNBT(nbt: NBTTagCompound) {
//		nbt.setTag(TAG_ENERGY, NBTTagCompound().apply { powerHandlerIC2.writeToNBT(this) })
//		nbt.setTag(TAG_FLUIDS, NBTTagCompound().apply { tank.writeToNBT(this) })
//		nbt.setTag(TAG_INV, NBTTagCompound().apply {
//			inventory.mapIndexed { id, it ->
//				setTag("$id", NBTTagCompound().apply { it?.writeToNBT(this) })
//			}
//		})
//	}
//	
//	override fun readCustomNBT(nbt: NBTTagCompound) {
//		powerHandlerIC2.readFromNBT(nbt.getCompoundTag(TAG_ENERGY))
//		tank.readFromNBT(nbt.getCompoundTag(TAG_FLUIDS))
//		
//		nbt.getCompoundTag(TAG_INV).apply {
//			repeat(inventory.size) { id ->
//				inventory[id] = ItemStack.loadItemStackFromNBT(getCompoundTag("$id"))
//			}
//		}
//	}
//	
//	override fun getSizeInventory() = inventory.size
//	
//	override fun getStackInSlot(slot: Int) = inventory[slot]
//	
//	override fun decrStackSize(slot: Int, size: Int): ItemStack? {
//		val at = inventory[slot] ?: return null
//		val result: ItemStack
//		
//		if (at.stackSize <= size) {
//			result = at
//			inventory[slot] = null
//		} else {
//			result = at.splitStack(size)
//			
//			if (at.stackSize == 0)
//				inventory[slot] = null
//		}
//		
//		markDirty()
//		return result
//	}
//	
//	override fun getStackInSlotOnClosing(slot: Int): ItemStack? {
//		val at = inventory[slot] ?: return null
//		inventory[slot] = null
//		return at
//	}
//	
//	override fun setInventorySlotContents(slot: Int, stack: ItemStack?) {
//		inventory[slot] = stack
//		
//		if (stack != null && stack.stackSize > inventoryStackLimit)
//			stack.stackSize = inventoryStackLimit
//		
//		markDirty()
//	}
//	
//	override fun getInventoryName() = "inventory.MFA.name"
//	
//	override fun hasCustomInventoryName() = false
//	
//	override fun getInventoryStackLimit() = 64
//	
//	override fun isUseableByPlayer(player: EntityPlayer): Boolean {
//		if (worldObj.getTileEntity(xCoord, yCoord, zCoord) !== this)
//			return false
//		
//		return Vector3.entityTileDistance(player, this) <= 8.0
//	}
//	
//	override fun openInventory() = Unit
//	
//	override fun closeInventory() = Unit
//	
//	override fun isItemValidForSlot(slot: Int, stack: ItemStack?): Boolean {
//		stack ?: return false
//		val name = GameRegistry.findUniqueIdentifierFor(stack.item)?.toString() ?: return false
//		
//		return "$name:${stack.meta}" in MFAConfigHandler.generators
//	}
//	
//	override fun drain(from: ForgeDirection?, resource: FluidStack?, doDrain: Boolean): FluidStack? {
//		if (uuStack.getFluid()!! != resource?.getFluid()) return null
//		
//		return drain(from, resource.amount, doDrain)
//	}
//	
//	override fun drain(from: ForgeDirection?, maxDrain: Int, doDrain: Boolean): FluidStack? = tank.drain(maxDrain, doDrain)
//	override fun fill(from: ForgeDirection?, resource: FluidStack?, doFill: Boolean) = 0
//	override fun canFill(from: ForgeDirection?, fluid: Fluid?) = false
//	override fun canDrain(from: ForgeDirection?, fluid: Fluid?) = true
//	override fun getTankInfo(from: ForgeDirection?) = arrayOf(tank.info)
//	
//	companion object {
//		
//		const val TAG_ENERGY = "energy"
//		const val TAG_FLUIDS = "fluids"
//		const val TAG_INV = "inv"
//		val uuStack by lazy { FluidStack(FluidRegistry.getFluid("ic2uumatter"), 0) }
//	}
//}
//
///**
// * Extra Utilities code
// */
//class IC2EnergyHandler(parent: TileEntity?, capacity: Int, tier: Int) {
//	
//	val ic2EnergySink = BasicSink(parent, capacity, tier)
//	
//	fun updateEntity() = ic2EnergySink.updateEntity()
//	
//	fun consumeEnergy(e: Double) = ic2EnergySink.useEnergy(e)
//	
//	fun onChunkUnload() = ic2EnergySink.onChunkUnload()
//	
//	fun writeToNBT(nbt: NBTTagCompound) = ic2EnergySink.writeToNBT(nbt)
//	
//	fun readFromNBT(nbt: NBTTagCompound) = ic2EnergySink.readFromNBT(nbt)
//	
//	fun invalidate() = ic2EnergySink.invalidate()
//}
//
//class ContainerMFA(playerInventory: IInventory, val mfa: TileMFA): Container() {
//	
//	init {
//		repeat(3) { i ->
//			repeat(3) { j ->
//				addSlotToContainer(SlotMFA(mfa, j + i * 3, 62 + j * 18, 17 + i * 18))
//			}
//		}
//		
//		repeat(3) { i ->
//			repeat(9) { j ->
//				addSlotToContainer(Slot(playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18))
//			}
//		}
//		
//		repeat(9) {
//			addSlotToContainer(Slot(playerInventory, it, 8 + it * 18, 142))
//		}
//	}
//	
//	override fun canInteractWith(player: EntityPlayer) = mfa.isUseableByPlayer(player)
//	
//	// SHIFT+click
//	override fun transferStackInSlot(player: EntityPlayer, index: Int): ItemStack? {
//		var stack: ItemStack? = null
//		val slot = inventorySlots[index] as Slot?
//		
//		if (slot != null && slot.hasStack) {
//			val at = slot.stack
//			stack = at.copy()
//			
//			if (index < 9) {
//				if (!mergeItemStack(at, 9, 45, true)) {
//					return null
//				}
//			} else if (mfa.isItemValidForSlot(0, stack)) {
//				if (!mergeItemStack(at, 0, 9, false)) {
//					return null
//				}
//			}
//			
//			if (at.stackSize == 0) {
//				slot.putStack(null)
//			} else {
//				slot.onSlotChanged()
//			}
//			
//			if (at.stackSize == stack.stackSize)
//				return null
//			
//			slot.onPickupFromSlot(player, at)
//		}
//		
//		return stack
//	}
//}
//
//class SlotMFA(inv: IInventory, index: Int, x: Int, y: Int): Slot(inv, index, x, y) {
//	
//	override fun isItemValid(stack: ItemStack?) = inventory.isItemValidForSlot(slotIndex, stack)
//}
//
//@SideOnly(Side.CLIENT)
//class GuiMFA(inv: InventoryPlayer, var mfa: TileMFA): GuiContainer(ContainerMFA(inv, mfa)) {
//	
//	override fun drawGuiContainerForegroundLayer(p_146979_1_: Int, p_146979_2_: Int) {
//		val name = StatCollector.translateToLocal(mfa.inventoryName)
//		fontRendererObj.drawString(name, xSize / 2 - fontRendererObj.getStringWidth(name) / 2, 6, 4210752)
//		fontRendererObj.drawString(I18n.format("container.inventory"), 8, ySize - 96 + 2, 4210752)
//	}
//	
//	override fun drawGuiContainerBackgroundLayer(ticks: Float, mouseX: Int, mouseY: Int) {
//		GL11.glColor4f(1f, 1f, 1f, 1f)
//		mc.textureManager.bindTexture(textures)
//		val k = (width - xSize) / 2
//		val l = (height - ySize) / 2
//		drawTexturedModalRect(k, l, 0, 0, xSize, ySize)
//	}
//	
//	companion object {
//		
//		val textures = ResourceLocation("textures/gui/container/dispenser.png")
//	}
//}
//
//class MessageOpenGUI(var id: Int, var x: Int, var y: Int, var z: Int): ASJPacket() {
//	
//	companion object: IMessageHandler<MessageOpenGUI, IMessage?> {
//		
//		override fun onMessage(message: MessageOpenGUI, ctx: MessageContext?): IMessage? {
//			val tile = mc.theWorld.getTileEntity(message.x, message.y, message.z) as? TileMFA ?: return null
//			mc.displayGuiScreen(GuiMFA(mc.thePlayer.inventory, tile))
//			mc.thePlayer.openContainer.windowId = message.id
//			return null
//		}
//	}
//}