//@file:Suppress("UNUSED_PARAMETER")
//
//package alexsocol.retranslator
//
//import alexsocol.asjlib.*
//import alexsocol.asjlib.extendables.ASJConfigHandler
//import alexsocol.patcher.KotlinAdapter
//import alexsocol.retranslator.RTMain.MODID
//import alexsocol.retranslator.RTMain.targetLanguage
//import com.google.gson.JsonParser
//import cpw.mods.fml.common.Mod
//import cpw.mods.fml.common.event.*
//import cpw.mods.fml.relauncher.FMLRelaunchLog
//import cpw.mods.fml.relauncher.IFMLLoadingPlugin.MCVersion
//import gloomyfolken.hooklib.asm.*
//import gloomyfolken.hooklib.minecraft.HookLoader
//import net.minecraft.client.resources.*
//import net.minecraft.util.*
//import net.minecraftforge.common.config.Configuration
//import java.io.File
//import java.net.*
//import java.util.*
//import java.util.concurrent.*
//import java.util.regex.*
//
//// alexsocol.retranslator.RTHookLoader
//@MCVersion("1.7.10")
//class RTHookLoader: HookLoader() {
//
//	override fun registerHooks() {
//		FMLRelaunchLog.info("[ReTranslator] Loaded coremod. Registering hooks...")
//
//		registerHookContainer("alexsocol.retranslator.RTHookHandler")
//	}
//}
//
//@Suppress("unused")
//object RTHookHandler {
//
//	@Hook(returnCondition = ReturnCondition.ALWAYS, injectOnExit = true)
//	@JvmStatic
//	fun translateToLocal(static: StatCollector?, key: String, @Hook.ReturnValue result: String): String {
//		if (ASJUtilities.isServer) return result
//
//		return HackI18n.translateToLocal(key, result)
//	}
//
//	@Hook(returnCondition = ReturnCondition.ALWAYS, injectOnExit = true)
//	@JvmStatic
//	fun translateToLocalFormatted(static: StatCollector?, key: String, vararg format: Any, @Hook.ReturnValue result: String): String {
//		if (ASJUtilities.isServer) return result
//
//		return HackI18n.translateToLocalFormatted(key, format, result)
//	}
//
//	@Hook(returnCondition = ReturnCondition.ALWAYS, injectOnExit = true)
//	@JvmStatic
//	fun format(static: I18n?, key: String, vararg format: Any, @Hook.ReturnValue result: String): String {
//		if (ASJUtilities.isServer) return result
//
//		return HackI18n.translateToLocalFormatted(key, format, result)
//	}
//}
//
//object RTConfigHandler: ASJConfigHandler() {
//
//	var ignoreRegex = listOf<Regex>()
//	var threads = 8
//	private var _translator = "GOOGLE"
//	val translator get() = EnumTranslationServiceType.valueOf(_translator)
//	var modMainLanguages = HashMap<String, String>()
//
//	override fun readProperties() {
//		ignoreRegex = loadProp(Configuration.CATEGORY_GENERAL, "ignoreRegex", arrayOf("enchantment\\.level\\.\\d+"), true, "List of regular expressions (https://en.wikipedia.org/wiki/Regular_expression) for keys translation blacklist").map(String::toRegex)
//		loadProp(Configuration.CATEGORY_GENERAL, "modMainLanguages", emptyArray<String>(), true, "Array of mod main languages in for of \"modid:lang\" (example: \"retranslator:en_US\"). If not specified for any mod, defaults to en_US", false).forEach {
//			val (modid, lang) = it.split(":")
//			modMainLanguages[modid] = lang
//		}
//		threads = loadProp(Configuration.CATEGORY_GENERAL, "threads", threads, true, "Number of threads for first init translation")
//		_translator = loadProp(Configuration.CATEGORY_GENERAL, "translator", _translator, true, "Translation service (one of: ${EnumTranslationServiceType.entries.joinToString { it.name }})")
//	}
//}
//
//@Mod(modid = MODID, modLanguageAdapter = KotlinAdapter.className)
//object RTMain {
//
//	const val MODID = "retranslator"
//	lateinit var targetLanguage: String
//
//	@Mod.EventHandler
//	fun construct(e: FMLConstructionEvent) {
//		targetLanguage = mc.gameSettings.language
//	}
//	
//	@Mod.EventHandler
//	fun preInit(e: FMLPreInitializationEvent) {
//		RTConfigHandler.loadConfig(e.suggestedConfigurationFile)
//		ASJUtilities.log("Found main mod lang overrides for next domains: [${RTConfigHandler.modMainLanguages.entries.joinToString { (k, v) -> "$k -> $v" }}]")
//
//		HackI18n.init()
//	}
//	
//	@Mod.EventHandler
//	fun postInit(e: FMLLoadCompleteEvent) {
//		HackI18n.await()
//	}
//}
//
//object HackI18n {
//
//	val keysMap = ConcurrentHashMap<String, String>()
//	var initialized = false
//	
//	private lateinit var executorService: ExecutorService
//	private lateinit var futures: ArrayList<CompletableFuture<Void>>
//
//	fun init() {
//		executorService = Executors.newFixedThreadPool(RTConfigHandler.threads)
//		futures = ArrayList<CompletableFuture<Void>>()
//		
//		mc.resourceManager.resourceDomains.forEach { domain ->
//			domain as String
//
//			try_ {
//				ASJUtilities.log("Parsing target $targetLanguage lang for $domain")
//
//				mc.resourceManager.getAllResources(ResourceLocation(domain, "lang/$targetLanguage.lang")).forEach { res ->
//					res as IResource
//					try_ {
//						val tempMap = HashMap<String, String>()
//						CacheHandler.readLangFromLinesToMap(res.inputStream.reader().readLines(), tempMap)
//
//						tempMap.forEach { (key, value) ->
//							keysMap[key] = value
//						}
//					}
//				}
//			}
//
//			try_ {
//				val modMainLang = RTConfigHandler.modMainLanguages[domain] ?: "en_US"
//
//				ASJUtilities.log("Parsing main $modMainLang lang for $domain")
//
//				val resources = mc.resourceManager.getAllResources(ResourceLocation(domain, "lang/$modMainLang.lang"))
//				resources.forEachIndexed { id, res -> res as IResource
//					try_ {
//						val tempMap = HashMap<String, String>()
//						CacheHandler.readLangFromLinesToMap(res.inputStream.reader().readLines(), tempMap)
//
//						var parsed = 0
//						var enqueued = 0
//
//						tempMap.forEach { (key, value) ->
//							if (!keysMap.containsKey(key) || keysMap[key] == value)
//								if (modMainLang == targetLanguage)
//									keysMap[key] = value
//								else {
//									enqueue {
//										keysMap[key] = translate(key, value, modMainLang) ?: value
//									}
//									enqueued++
//								}
//
//							if (++parsed % 100 == 0)
//								ASJUtilities.log("Parsed $parsed/${tempMap.size} entries ($enqueued enqueued for translation) in $id/${resources.size} resource...")
//						}
//						
//						ASJUtilities.log("Parsed $parsed/${tempMap.size} entries ($enqueued enqueued for translation) in $id/${resources.size} resource...")
//					}
//				}
//			}
//		}
//	}
//	
//	private fun enqueue(task: Runnable) {
//		val future = CompletableFuture.runAsync(task, executorService)
//		futures.add(future)
//	}
//	
//	fun await() {
//		ASJUtilities.log("Awaiting executor to finish translations")
//		
//		try {
//			CompletableFuture.allOf(*futures.toTypedArray<CompletableFuture<*>>()).join()
//		} catch (e: Exception) {
//			e.printStackTrace()
//		} finally {
//			executorService.shutdown()
//			futures.clear()
//			initialized = true
//		}
//	}
//
//	fun translateToLocal(key: String, result: String): String {
//		if (!initialized || keysMap[key] == result) return result
//
//		return translate(key) ?: result
//	}
//
//	fun translateToLocalFormatted(key: String, format: Array<out Any>, result: String): String {
//		if (!initialized || keysMap[key]?.safeFormat(*format) == result) return result
//
//		return translate(key)?.safeFormat(*format) ?: result
//	}
//
//	private fun translate(key: String, value: String? = null, sourceLang: String? = null): String? {
//		CacheHandler[key]?.let { return it }
//		if (RTConfigHandler.ignoreRegex.any(key::matches)) {
//			CacheHandler[key] = value ?: keysMap[key] ?: ""
//			return CacheHandler[key]
//		}
//		
//		val toTranslate = (value ?: keysMap[key]) ?: return null
//		val translated = RTConfigHandler.translator.ts.translate(toTranslate, sourceLang) ?: return null
//
//		CacheHandler[key] = translated
//		return translated
//	}
//
//	private fun String.safeFormat(vararg args: Any?): String {
//		return if (args.isEmpty()) this else try {
//			java.lang.String.format(this, *args)
//		} catch (e: IllegalFormatException) {
//			this
//		}
//	}
//}
//
//object CacheHandler {
//
//	val cacheMaps = HashMap<String, HashMap<String, String>>()
//	val cacheFiles = HashMap<String, File>()
//	val cacheFile: File
//		get() = cacheFiles.computeIfAbsent(targetLanguage) {
//			val f = File("ReTranslatorCache/${targetLanguage}.lang")
//			if (f.exists())
//				return@computeIfAbsent f
//			
//			f.parentFile.mkdirs()
//			f.createNewFile()
//			f
//		}
//	
//	/** Pattern that matches numeric variable placeholders in a resource string, such as "%d", "%3$d", "%.2f" */
//	// this piece of crap from net.minecraft.util.StringTranslate to (partially) fix minecraft sources having shitcode all over the place
//	private val numericVariablePattern: Pattern = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]")
//
//	init {
//		// Load cache from file into memory during initialization
//		ASJUtilities.log("Initializing cache handler, reading cache file ${cacheFile.name}")
//		readLangFromLinesToMap(cacheFile.readLines(), cacheMaps.computeIfAbsent(targetLanguage) { HashMap() })
//	}
//
//	operator fun get(key: String): String? {
//		val cacheMap = cacheMaps.computeIfAbsent(targetLanguage) { HashMap() }
//
//		// Check if the key exists in RAM cache
//		if (cacheMap.containsKey(key)) {
//			return cacheMap[key]
//		}
//
//		return null
//	}
//
//	operator fun set(key: String, value: String) {
//		// Update RAM cache
//		cacheMaps.computeIfAbsent(targetLanguage) { HashMap() }[key] = value
//		// Update cache file
//		cacheFile.appendText("$key=$value\n")
//	}
//
//	fun readLangFromLinesToMap(lines: List<String>, map: HashMap<String, String>) {
//		lines.forEach { line ->
//			if (line.startsWith("#") || line.isEmpty()) return@forEach
//			val splitted = line.split("=", limit = 2)
//			if (splitted.size != 2) return@forEach
//
//			map[splitted[0]] = numericVariablePattern.matcher(splitted[1]).replaceAll("%$1s")
//		}
//	}
//}
//
//enum class EnumTranslationServiceType(val ts: TranslationService) {
//	GOOGLE(GoogleTranslationService);
//}
//
//abstract class TranslationService {
//
//	val parser = JsonParser()
//
//	abstract fun translate(text: String, sourceLang: String?): String?
//}
//
//object GoogleTranslationService: TranslationService() {
//
//	const val URL = "https://translate.googleapis.com/translate_a/single?client=gtx&sl=%s&tl=%s&dt=t&dt=bd&dj=1&q=%s&&ie=UTF-8&oe=UTF-8"
//
//	override fun translate(text: String, sourceLang: String?): String? {
//		return try {
//			parser.parse(URL(URL.format(sourceLang ?: "auto", targetLanguage, URLEncoder.encode(text, "UTF-8").replace("+", "%20"))).openStream().use { it.readBytes().toString(Charsets.UTF_8) }).asJsonObject["sentences"].asJsonArray.joinToString("") { it.asJsonObject["trans"].asString }.replace("\u200B", "")
//		} catch (e: Throwable) {
//			null
//		}
//	}
//}