//package alexsocol.rubedo.smartass
//
//import alexsocol.asjlib.ASJUtilities
//import alexsocol.patcher.KotlinAdapter
//import alexsocol.rubedo.smartass.SmartAssociate.MODID
//import cpw.mods.fml.common.Mod
//import cpw.mods.fml.common.event.FMLServerStartingEvent
//import net.minecraft.command.*
//import net.minecraft.server.MinecraftServer
//import java.io.*
//import java.util.*
//
//@Mod(modid = MODID, name = "Smart Associate", version = "1", modLanguageAdapter = KotlinAdapter.className, acceptableRemoteVersions = "*")
//object SmartAssociate {
//	
//	const val MODID = "smartass"
//	
//	@Mod.EventHandler
//	fun onServerStarting(e: FMLServerStartingEvent) {
//		e.registerServerCommand(CommandSA)
//		CommandSA.readCommands()
//	}
//}
//
//object CommandSA: CommandBase() {
//	
//	val commandsFile get() = File("${MinecraftServer.getServer().entityWorld.saveHandler.worldDirectory.absolutePath}/data/$MODID/commands")
//	
//	val cm get() = MinecraftServer.getServer().commandManager as CommandHandler
//	
//	val commands = HashSet<CommandAlias>()
//	
//	init {
//		readCommands()
//	}
//	
//	override fun getCommandName() = "smartassociate"
//	
//	override fun getCommandUsage(sender: ICommandSender?) = "/$commandName <add|remove> <alias> <command> [args]"
//	
//	override fun processCommand(sender: ICommandSender, args: Array<out String>) {
//		if (args.isEmpty()) return
//		
//		when (args[0]) {
//			"add" -> {
//				if (args.size < 3)
//					throw WrongUsageException("You need to specify command alias and command itself")
//				
//				val alias = args[1]
//				if (cm.commands.containsKey(alias)) 
//					throw WrongUsageException("You already have a command with the specified name")
//				
//				val command = args[2]
//				if (!cm.commands.containsKey(command))
//					throw WrongUsageException("Command $command does not exist")
//				
//				val arguments = ArrayList<String>()
//				repeat(args.size - 3) {
//					arguments += args[it + 3]
//				}
//				
//				add(CommandAlias(alias, command, arguments), true)
//				
//				ASJUtilities.say(sender, "$alias associated to command $command")
//			}
//			
//			"remove" -> {
//				val alias = args.getOrNull(1) ?: throw WrongUsageException("You need to specify command to remove")
//				
//				if (commands.none { it.alias == alias })
//					throw WrongUsageException("Command association $alias does not exist")
//				
//				remove(alias)
//				
//				ASJUtilities.say(sender, "Removed $alias command")
//			}
//		}
//	}
//	
//	override fun addTabCompletionOptions(sender: ICommandSender?, args: Array<out String>): MutableList<Any?>? {
//		return when (args.size) {
//			1 -> getListOfStringsMatchingLastWord(args, "add", "remove")
//			2 -> if (args[0] == "remove") getListOfStringsFromIterableMatchingLastWord(args, commands.map(CommandAlias::alias)) else null
//			3 -> if (args[0] == "add") getListOfStringsFromIterableMatchingLastWord(args, cm.commands.keys) else null
//			else -> null
//		}
//	}
//	
//	@Suppress("UNCHECKED_CAST")
//	fun readCommands() {
//		val file = commandsFile
//		if (!file.exists())
//			return
//		
//		ObjectInputStream(FileInputStream(file)).use {
//			val read = it.readObject() as HashSet<CommandAlias>
//			read.forEach(::add)
//		}
//	}
//	
//	fun writeCommands() {
//		val file = commandsFile
//		if (!file.exists()) {
//			file.parentFile.mkdirs()
//			file.createNewFile()
//		}
//		
//		ObjectOutputStream(FileOutputStream(file)).use {
//			it.writeObject(commands)
//		}
//	}
//	
//	fun add(ca: CommandAlias, write: Boolean = false) {
//		commands += ca
//		cm.registerCommand(ca)
//		if (write) writeCommands()
//	}
//	
//	fun remove(alias: String) {
//		commands.removeAll { it.alias == alias }
//		cm.commands.remove(alias)
//		writeCommands()
//	}
//}
//
//class CommandAlias(val alias: String, val command: String, val arguments: ArrayList<String>): CommandBase(), Serializable {
//	
//	override fun getCommandName() = alias
//	
//	override fun getCommandUsage(sender: ICommandSender?) = "/$commandName"
//	
//	override fun processCommand(sender: ICommandSender?, args: Array<out String>) {
//		var i = 0
//		
//		val line = arguments.fold("") { acc, it ->
//			val arg = if (it == TEMPLATE)
//				args.getOrElse(i++) { throw WrongUsageException("Argument at pos $i is required") }
//			else if (it.startsWith("$TEMPLATE{") && it.endsWith('}'))
//				args.getOrNull(i++) ?: it.substring(2, it.length - 1)
//			else
//				it
//			
//			"$acc $arg"
//		}
//		
//		CommandSA.cm.executeCommand(sender, "$command ${line.trim()}")
//	}
//	
//	override fun addTabCompletionOptions(sender: ICommandSender?, args: Array<out String>): MutableList<Any?>? {
//		val command = CommandSA.cm.commands[command] as ICommand
//		
//		val mapped = ArrayList<String>()
//		
//		var missed = 0
//		var i = 0
//		
//		while (missed < args.size && i < arguments.size) {
//			var v = arguments[i++]
//			
//			if (v == TEMPLATE || v.startsWith("$TEMPLATE{") && v.endsWith('}'))
//				v = args[missed++]
//			
//			mapped += v
//		}
//		
//		return command.addTabCompletionOptions(sender, mapped.toTypedArray())
//	}
//	
//	override fun getRequiredPermissionLevel(): Int {
//		val command = CommandSA.cm.commands[command] as CommandBase
//		return command.requiredPermissionLevel
//	}
//	
//	override fun canCommandSenderUseCommand(sender: ICommandSender?): Boolean {
//		val command = CommandSA.cm.commands[command] as ICommand
//		return command.canCommandSenderUseCommand(sender)
//	}
//	
//	override fun isUsernameIndex(args: Array<out String>?, i: Int): Boolean {
//		val command = CommandSA.cm.commands[command] as ICommand
//		return command.isUsernameIndex(args, i)
//	}
//	
//	override fun equals(other: Any?): Boolean {
//		if (this === other) return true
//		if (other !is CommandAlias) return false
//		
//		if (alias != other.alias) return false
//		if (command != other.command) return false
//		return arguments == other.arguments
//	}
//	
//	override fun hashCode() = Objects.hash(alias, command, arguments)
//	
//	companion object {
//		const val TEMPLATE = "$"
//		private const val serialVersionUID = 1L
//	}
//}