package com.KAIIIAK.superwrapper;

import java.lang.annotation.*;

/**
 * Эта аннотация сгенерирует новый метод в целевом классе, который будет вызывать
 * метод конкретно целевого класса (игнорируя переопределение в классах-наследниках)
 * если {@link SuperWrapper#callThis() callThis}=true, иначе игнорирования не будет
 * <br>
 * Целевой класс указывается первым аргументом метода с этой аннотацией, остальные
 * аргументы должны совпадать со списком и порядком аргументов вызываемого метода
 * <br>
 * Метод с аннотацией обязательно должен быть <i>static</i>
 * а его содержимое будет заменено вызовом сгенерированного метода.
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface SuperWrapper {
	
	/**
	 * Имя целевого метода, который будет вызван<br>
	 * Если не указан, будет идентичен имени метода с этой аннотацией
	 */
	String targetMethod() default "";
	
	/**
	 * Префикс в названии генерируемого метода<br>
	 * Если не указан, будет "Super__"
	 */
	String methodNamePrefix() default "";
	
	/**
	 * Префикс в названии генерируемого метода<br>
	 * Если не указан, будет "__Wrapper"
	 */
	String methodNamePostfix() default "";
	
	/**
	 * Список исключений, которые могут быть выброшены при вызове метода<br>
	 * Иными словами, список того, что пишется после throws<br>
	 * Если не указан, будет идентичен списку throws метода с этой аннотацией
	 */
	String[] exceptions() default {};
	
	/**
	 * Сигнатура генерируемого метода<br>
	 * Если не указана, будет идентична сигнатуре метода с этой аннотацией
	 */
	String signature() default "";
	
	/**
	 * Игнорировать ли переопределение в классах-наследниках<br>
	 * Если не указано, будет вызывать метод конкретно целевого класса,
	 * иначе будет вызывать @Override-метод (при наличии) для подклассов
	 * <br><br>
	 * Пример:<pre>{@code
	 * class Bar {
	 *     protected void foo() { ... }
	 * }
	 *
	 * class Baz extends Bar {
	 *     @Override protected void foo() { ... }
	 * }
	 *
	 * ...
	 *
	 * thisFooSuperWrapper(baz) // <- Вызовет именно Bar#foo, хотя foo переопределён
	 * notThisFooSuperWrapper(baz) // <- Вызовет Baz#foo, т.е. с учётом переопределения
	 * }</pre>
	 */
	boolean callThis() default true;
 
}
