/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib;

import alexsocol.asjlib.BlockElement;
import alexsocol.asjlib.LocationElement;
import alexsocol.asjlib.StringBlockElement;
import alexsocol.patcher.PatcherConfigHandler;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u0014J;\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\u001eJX\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00062(\b\u0002\u0010 \u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0010\u0018\u00010!Je\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00072(\b\u0002\u0010 \u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0010\u0018\u00010!H\u0000\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006J\r\u0010$\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b%J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010'\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b(J#\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b*J,\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070,2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019H\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Lalexsocol/asjlib/SchemaUtils;", "", "<init>", "()V", "cache", "Ljava/util/HashMap;", "", "", "Lalexsocol/asjlib/BlockElement;", "Lkotlin/collections/HashMap;", "type", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "getType", "()Ljava/lang/reflect/Type;", "generate", "", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "path", "doCache", "", "hasRotations", "fourRotations", "rotation", "arr", "generate$1_7_10_ASJCore", "checkStructure", "onFail", "Lkotlin/Function4;", "checkStructure$1_7_10_ASJCore", "uncache", "clearCache", "clearCache$1_7_10_ASJCore", "parseText", "schemaText", "parseText$1_7_10_ASJCore", "loadStructure", "loadStructure$1_7_10_ASJCore", "loadStructureWithRotations", "", "allFour", "rotate", "schema", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nSchemaUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaUtils.kt\nalexsocol/asjlib/SchemaUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1563#2:175\n1634#2,3:176\n1563#2:180\n1634#2,3:181\n1#3:179\n*S KotlinDebug\n*F\n+ 1 SchemaUtils.kt\nalexsocol/asjlib/SchemaUtils\n*L\n86#1:175\n86#1:176,3\n131#1:180\n131#1:181,3\n*E\n"})
public final class SchemaUtils {
    @NotNull
    public static final SchemaUtils INSTANCE = new SchemaUtils();
    @NotNull
    private static final HashMap<String, List<BlockElement>> cache = new HashMap();
    private static final Type type = new TypeToken<List<? extends StringBlockElement>>(){}.getType();

    private SchemaUtils() {
    }

    public final Type getType() {
        return type;
    }

    public final void generate(@NotNull World world, int x, int y, int z, @NotNull String path, boolean doCache, boolean hasRotations, boolean fourRotations, int rotation) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<BlockElement> schema = hasRotations ? this.loadStructureWithRotations(path, doCache, fourRotations).get(rotation) : this.loadStructure$1_7_10_ASJCore(path, doCache);
        this.generate$1_7_10_ASJCore(world, x, y, z, schema);
    }

    public static /* synthetic */ void generate$default(SchemaUtils schemaUtils, World world, int n, int n2, int n3, String string, boolean bl, boolean bl2, boolean bl3, int n4, int n5, Object object) {
        if ((n5 & 0x40) != 0) {
            bl2 = false;
        }
        if ((n5 & 0x80) != 0) {
            bl3 = true;
        }
        if ((n5 & 0x100) != 0) {
            n4 = 0;
        }
        schemaUtils.generate(world, n, n2, n3, string, bl, bl2, bl3, n4);
    }

    public final void generate$1_7_10_ASJCore(@NotNull World world, int x, int y, int z, @NotNull List<BlockElement> arr) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        world.setBlock(x, y, z, Blocks.air, 0, 4);
        for (BlockElement ele : arr) {
            if (ele.getBlock() == null) continue;
            for (LocationElement loc : ele.getLocation()) {
                TileEntity tile;
                Block block;
                world.setBlock(x + loc.getX(), y + loc.getY(), z + loc.getZ(), block, loc.getMeta(), 3);
                if (loc.getNbt() == null) continue;
                NBTBase nBTBase = JsonToNBT.func_150315_a((String)loc.getNbt());
                Intrinsics.checkNotNull((Object)nBTBase, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
                if (TileEntity.createAndLoadEntity((NBTTagCompound)((NBTTagCompound)nBTBase)) == null) continue;
                tile.xCoord = x + loc.getX();
                tile.yCoord = y + loc.getY();
                tile.zCoord = z + loc.getZ();
                world.setTileEntity(x + loc.getX(), y + loc.getY(), z + loc.getZ(), tile);
            }
        }
    }

    public final boolean checkStructure(@NotNull World world, int x, int y, int z, @NotNull String path, @Nullable Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> onFail) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.checkStructure$1_7_10_ASJCore(world, x, y, z, this.loadStructure$1_7_10_ASJCore(path, true), onFail);
    }

    public static /* synthetic */ boolean checkStructure$default(SchemaUtils schemaUtils, World world, int n, int n2, int n3, String string, Function4 function4, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            function4 = null;
        }
        return schemaUtils.checkStructure(world, n, n2, n3, string, (Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit>)function4);
    }

    public final boolean checkStructure$1_7_10_ASJCore(@NotNull World world, int x, int y, int z, @NotNull List<BlockElement> arr, @Nullable Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> onFail) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        for (BlockElement ele : arr) {
            for (LocationElement loc : ele.getLocation()) {
                int k;
                int j;
                int i2 = x + loc.getX();
                if (SchemaUtils.checkStructure$check(world, i2, j = y + loc.getY(), k = z + loc.getZ(), ele, loc)) continue;
                Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> function4 = onFail;
                if (function4 != null) {
                    function4.invoke((Object)world.provider.dimensionId, (Object)i2, (Object)j, (Object)k);
                }
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean checkStructure$1_7_10_ASJCore$default(SchemaUtils schemaUtils, World world, int n, int n2, int n3, List list, Function4 function4, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            function4 = null;
        }
        return schemaUtils.checkStructure$1_7_10_ASJCore(world, n, n2, n3, list, (Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit>)function4);
    }

    public final void uncache(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        cache.remove(path);
    }

    public final void clearCache$1_7_10_ASJCore() {
        cache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BlockElement> parseText$1_7_10_ASJCore(@NotNull String schemaText) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schemaText, (String)"schemaText");
        Object object = new Gson().fromJson(schemaText, type);
        Intrinsics.checkNotNull((Object)object);
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StringBlockElement stringBlockElement = (StringBlockElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BlockElement(Block.getBlockFromName((String)it.getBlock()), it.getLocation()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<BlockElement> loadStructure$1_7_10_ASJCore(@NotNull String path, boolean doCache) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (((Map)cache).containsKey(path)) {
            List<BlockElement> list = cache.get(path);
            Intrinsics.checkNotNull(list);
            return list;
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/assets/" + path);
        Intrinsics.checkNotNull((Object)inputStream);
        Closeable closeable = inputStream;
        SchemaUtils schemaUtils = this;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            string = StringsKt.decodeToString((byte[])ByteStreamsKt.readBytes((InputStream)it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List<BlockElement> schema = schemaUtils.parseText$1_7_10_ASJCore(string);
        if (PatcherConfigHandler.INSTANCE.getCacheSchemas() && doCache) {
            ((Map)cache).put(path, schema);
        }
        return schema;
    }

    private final List<List<BlockElement>> loadStructureWithRotations(String path, boolean doCache, boolean allFour) {
        if (((Map)cache).containsKey(path)) {
            Object[] objectArray = new List[2];
            Intrinsics.checkNotNull(cache.get(path));
            Intrinsics.checkNotNull(cache.get(path + '-'));
            List list = CollectionsKt.mutableListOf((Object[])objectArray);
            if (allFour) {
                List list2 = cache.computeIfAbsent(path + "--", arg_0 -> SchemaUtils.loadStructureWithRotations$lambda$3(arg_0 -> SchemaUtils.loadStructureWithRotations$lambda$2(list, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"computeIfAbsent(...)");
                list.add(list2);
                List list3 = cache.computeIfAbsent(path + "---", arg_0 -> SchemaUtils.loadStructureWithRotations$lambda$5(arg_0 -> SchemaUtils.loadStructureWithRotations$lambda$4(list, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"computeIfAbsent(...)");
                list.add(list3);
            }
            return list;
        }
        List<BlockElement> schema = this.loadStructure$1_7_10_ASJCore(path, doCache);
        Object[] objectArray = new List[]{schema};
        List list = CollectionsKt.mutableListOf((Object[])objectArray);
        list.add(this.rotate((List)CollectionsKt.last((List)list)));
        if (allFour) {
            list.add(this.rotate((List)CollectionsKt.last((List)list)));
            list.add(this.rotate((List)CollectionsKt.last((List)list)));
        }
        if (PatcherConfigHandler.INSTANCE.getCacheSchemas() && doCache) {
            ((Map)cache).put(path, list.get(0));
            ((Map)cache).put(path + '-', list.get(1));
            if (allFour) {
                ((Map)cache).put(path + "--", list.get(2));
                ((Map)cache).put(path + "---", list.get(3));
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BlockElement> rotate(List<BlockElement> schema) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = schema;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            BlockElement blockElement = (BlockElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it.getLocation();
            Block block = it.getBlock();
            boolean $i$f$map2 = false;
            void var14_14 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                int n;
                void loc;
                LocationElement locationElement = (LocationElement)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                if (it.getBlock() instanceof BlockStairs) {
                    switch (loc.getMeta()) {
                        case 0: {
                            n = 2;
                            break;
                        }
                        case 1: {
                            n = 3;
                            break;
                        }
                        case 2: {
                            n = 1;
                            break;
                        }
                        case 3: {
                            n = 0;
                            break;
                        }
                        case 4: {
                            n = 6;
                            break;
                        }
                        case 5: {
                            n = 7;
                            break;
                        }
                        case 6: {
                            n = 5;
                            break;
                        }
                        case 7: {
                            n = 4;
                            break;
                        }
                        case 8: {
                            n = 10;
                            break;
                        }
                        case 9: {
                            n = 11;
                            break;
                        }
                        case 10: {
                            n = 9;
                            break;
                        }
                        case 11: {
                            n = 8;
                            break;
                        }
                        case 12: {
                            n = 14;
                            break;
                        }
                        case 13: {
                            n = 15;
                            break;
                        }
                        case 14: {
                            n = 13;
                            break;
                        }
                        case 15: {
                            n = 12;
                            break;
                        }
                        default: {
                            n = loc.getMeta();
                            break;
                        }
                    }
                } else {
                    n = loc.getMeta();
                }
                int meta = n;
                collection2.add(new LocationElement(-loc.getZ(), loc.getY(), loc.getX(), meta, loc.getNbt()));
            }
            List list = (List)destination$iv$iv2;
            Block block2 = block;
            collection.add(new BlockElement(block2, list));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean checkStructure$check(World $world, int i2, int j, int k, BlockElement ele, LocationElement loc) {
        if (!Intrinsics.areEqual((Object)$world.getBlock(i2, j, k), (Object)ele.getBlock()) || $world.getBlockMetadata(i2, j, k) != loc.getMeta()) {
            return false;
        }
        if (loc.getNbt() == null) {
            return true;
        }
        NBTBase nBTBase = JsonToNBT.func_150315_a((String)loc.getNbt());
        Intrinsics.checkNotNull((Object)nBTBase, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        NBTTagCompound locNBT = (NBTTagCompound)nBTBase;
        TileEntity tileEntity = $world.getTileEntity(i2, j, k);
        if (tileEntity == null) {
            return false;
        }
        TileEntity tile = tileEntity;
        NBTTagCompound landNBT = new NBTTagCompound();
        tile.writeToNBT(landNBT);
        Map map = locNBT.tagMap;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"tagMap");
        for (Map.Entry entry : map.entrySet()) {
            if (Intrinsics.areEqual(entry.getValue(), landNBT.tagMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static final List loadStructureWithRotations$lambda$2(List $list, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.rotate((List)CollectionsKt.last((List)$list));
    }

    private static final List loadStructureWithRotations$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List loadStructureWithRotations$lambda$4(List $list, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.rotate((List)CollectionsKt.last((List)$list));
    }

    private static final List loadStructureWithRotations$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

