/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.extendables;

import alexsocol.asjlib.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0014J\u0012\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0014J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020\u0019H\u0014J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010&\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020\u0013H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lalexsocol/asjlib/extendables/EntityRidable;", "Lnet/minecraft/entity/EntityCreature;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "rider", "Lnet/minecraft/entity/player/EntityPlayer;", "getRider", "()Lnet/minecraft/entity/player/EntityPlayer;", "setRider", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "walkSpeed", "", "getWalkSpeed", "()D", "setWalkSpeed", "(D)V", "attackEntityFrom", "", "src", "Lnet/minecraft/util/DamageSource;", "dmg", "", "applyEntityAttributes", "", "onLivingUpdate", "canBeCollidedWith", "canBePushed", "getShadowSize", "canDespawn", "interact", "player", "moveEntityWithHeading", "mS", "mF", "jump", "mount", "shouldDismountInWater", "Lnet/minecraft/entity/Entity;", "isSprinting", "1.7.10-ASJCore"})
public abstract class EntityRidable
extends EntityCreature {
    @Nullable
    private EntityPlayer rider;
    private double walkSpeed;

    public EntityRidable(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.walkSpeed = 0.25;
    }

    @Nullable
    public final EntityPlayer getRider() {
        return this.rider;
    }

    public final void setRider(@Nullable EntityPlayer entityPlayer) {
        this.rider = entityPlayer;
    }

    public final double getWalkSpeed() {
        return this.walkSpeed;
    }

    public final void setWalkSpeed(double d) {
        this.walkSpeed = d;
    }

    public boolean attackEntityFrom(@NotNull DamageSource src, float dmg) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.rider != null && src.getEntity() == this.rider ? false : super.attackEntityFrom(src, dmg);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(36.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(this.walkSpeed);
    }

    public void onLivingUpdate() {
        EntityPlayer entityPlayer;
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer) {
            Entity entity = this.riddenByEntity;
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            entityPlayer = (EntityPlayer)entity;
        } else {
            entityPlayer = this.rider = null;
        }
        if (this.rider != null) {
            EntityPlayer entityPlayer2 = this.rider;
            Intrinsics.checkNotNull((Object)entityPlayer2);
            if (entityPlayer2.isJumping) {
                this.getJumpHelper().setJumping();
            }
        }
        super.onLivingUpdate();
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public boolean canBePushed() {
        return this.riddenByEntity == null;
    }

    public float getShadowSize() {
        return 0.0f;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected boolean interact(@Nullable EntityPlayer player) {
        boolean bl;
        if (this.worldObj.isRemote || player == null) {
            return false;
        }
        if (this.rider == null) {
            this.mount(player);
            if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer) {
                Entity entity = this.riddenByEntity;
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                this.rider = (EntityPlayer)entity;
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    public void moveEntityWithHeading(float mS, float mF) {
        float par1 = mS;
        float par2 = mF;
        if (this.rider != null) {
            EntityPlayer entityPlayer = this.rider;
            Intrinsics.checkNotNull((Object)entityPlayer);
            this.prevRotationYaw = this.rotationYaw = entityPlayer.rotationYaw;
            EntityPlayer entityPlayer2 = this.rider;
            Intrinsics.checkNotNull((Object)entityPlayer2);
            this.rotationPitch = entityPlayer2.rotationPitch * 0.5f;
            this.setRotation(this.rotationYaw, this.rotationPitch);
            this.rotationYawHead = this.renderYawOffset = this.rotationYaw;
            EntityPlayer entityPlayer3 = this.rider;
            Intrinsics.checkNotNull((Object)entityPlayer3);
            par1 = entityPlayer3.moveStrafing * 0.5f;
            EntityPlayer entityPlayer4 = this.rider;
            Intrinsics.checkNotNull((Object)entityPlayer4);
            par2 = entityPlayer4.moveForward;
            if (!this.worldObj.isRemote) {
                this.setAIMoveSpeed(ExtensionsKt.getF(this.walkSpeed));
                super.moveEntityWithHeading(par1, par2);
            } else {
                super.moveEntityWithHeading(par1, par2);
            }
            this.prevLimbSwingAmount = this.limbSwingAmount;
            double d0 = this.posX - this.prevPosX;
            double d1 = this.posZ - this.prevPosZ;
            float f4 = ExtensionsKt.getF(Math.sqrt(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.limbSwingAmount += (f4 - this.limbSwingAmount) * 0.4f;
            this.limbSwing += this.limbSwingAmount;
        } else {
            super.moveEntityWithHeading(par1, par2);
        }
    }

    protected void jump() {
        this.motionY = 0.5;
        PotionEffect potionEffect = ExtensionsKt.getActivePotionEffect((EntityLivingBase)this, Potion.jump.id);
        if (potionEffect != null) {
            PotionEffect it = potionEffect;
            boolean bl = false;
            this.motionY += (double)(it.amplifier + 1) * 0.1;
        }
        this.isAirBorne = true;
        ForgeHooks.onLivingJump((EntityLivingBase)((EntityLivingBase)this));
    }

    public void mount(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.rotationYaw = this.rotationYaw;
        player.rotationPitch = this.rotationPitch;
        if (!this.worldObj.isRemote) {
            player.mountEntity((Entity)this);
        }
    }

    public boolean shouldDismountInWater(@Nullable Entity rider) {
        return false;
    }

    public boolean isSprinting() {
        boolean bl;
        if (this.rider == null) {
            bl = false;
        } else {
            EntityPlayer entityPlayer = this.rider;
            Intrinsics.checkNotNull((Object)entityPlayer);
            bl = entityPlayer.moveForward > 0.5f;
        }
        return bl;
    }
}

