/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.extendables;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.EntityRidable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0014J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lalexsocol/asjlib/extendables/EntityRidableFlying;", "Lalexsocol/asjlib/extendables/EntityRidable;", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "flySpeed", "", "getFlySpeed", "()F", "setFlySpeed", "(F)V", "fall", "", "f", "moveEntityWithHeading", "mS", "mF", "1.7.10-ASJCore"})
public abstract class EntityRidableFlying
extends EntityRidable {
    private float flySpeed;

    public EntityRidableFlying(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.flySpeed = 0.85f;
    }

    public final float getFlySpeed() {
        return this.flySpeed;
    }

    public final void setFlySpeed(float f) {
        this.flySpeed = f;
    }

    protected void fall(float f) {
    }

    @Override
    public void moveEntityWithHeading(float mS, float mF) {
        boolean bl = this.onGround = !this.worldObj.isAirBlock(ExtensionsKt.mfloor(this.posX), MathHelper.ceiling_double_int((double)(this.posY - 1.0)), ExtensionsKt.mfloor(this.posZ));
        if (this.getRider() != null) {
            this.prevRotationYaw = this.rotationYaw = this.riddenByEntity.rotationYaw;
            this.rotationPitch = this.riddenByEntity.rotationPitch * 0.5f;
            this.setRotation(this.rotationYaw, this.rotationPitch);
            this.rotationYawHead = this.renderYawOffset = this.rotationYaw;
            if (this.onGround && !this.isJumping) {
                if (!this.worldObj.isRemote) {
                    super.moveEntityWithHeading(mS, mF);
                }
            } else if (this.riddenByEntity instanceof EntityLivingBase) {
                Entity entity = this.riddenByEntity;
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.entity.EntityLivingBase");
                float par2 = ((EntityLivingBase)entity).moveForward;
                this.setAIMoveSpeed(this.flySpeed);
                if (!this.worldObj.isRemote) {
                    if (this.isJumping) {
                        this.motionY = (double)this.flySpeed * 0.5;
                    } else if (!this.onGround) {
                        this.motionY = 0.0;
                    }
                    if (!(par2 == 0.0f) && !this.isJumping) {
                        EntityPlayer entityPlayer = this.getRider();
                        Intrinsics.checkNotNull((Object)entityPlayer);
                        double rad = Math.toRadians(ExtensionsKt.getD(Float.valueOf(entityPlayer.rotationPitch)));
                        this.motionY = -Math.sin(rad) * (double)this.flySpeed;
                        par2 = ExtensionsKt.getF(Math.abs(Math.cos(rad))) * this.flySpeed;
                        if ((double)par2 < 0.05) {
                            par2 = 0.0f;
                        }
                    }
                    float f2 = this.flySpeed;
                    float f3 = 0.1627714f / (f2 * f2 * f2);
                    this.moveFlying(0.0f, par2, this.onGround ? 0.1f * f3 : 0.085f);
                    this.moveEntity(this.motionX, this.motionY, this.motionZ);
                    this.motionX *= (double)f2;
                    this.motionY *= (double)f2;
                    this.motionZ *= (double)f2;
                }
            }
        } else if (!this.worldObj.isRemote) {
            super.moveEntityWithHeading(mS, mF);
        }
        this.prevLimbSwingAmount = this.limbSwingAmount;
        double var10 = this.posX - this.prevPosX;
        double var9 = this.posZ - this.prevPosZ;
        float var7 = ExtensionsKt.getF(Math.sqrt(var10 * var10 + var9 * var9)) * 4.0f;
        if (var7 > 1.0f) {
            var7 = 1.0f;
        }
        this.limbSwingAmount += (var7 - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }
}

