/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.math;

import alexsocol.asjlib.ExtensionsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J(\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J0\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013J\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013J&\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013J*\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\b\b\u0002\u0010 \u001a\u00020\u001aH\u0002R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lalexsocol/asjlib/math/NoiseSimplex;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "grad3", "Lalexsocol/asjlib/math/NoiseSimplex$Grad;", "[Lalexsocol/asjlib/math/NoiseSimplex$Grad;", "grad4", "p", "", "perm", "permMod12", "F2", "", "G2", "F3", "G3", "F4", "G4", "fastfloor", "", "x", "dot", "g", "y", "z", "w", "noise", "Grad", "1.7.10-ASJCore"})
public final class NoiseSimplex {
    @NotNull
    public static final NoiseSimplex INSTANCE;
    @NotNull
    private static final Grad[] grad3;
    @NotNull
    private static final Grad[] grad4;
    @NotNull
    private static final short[] p;
    @NotNull
    private static final short[] perm;
    @NotNull
    private static final short[] permMod12;
    private static final double F2;
    private static final double G2;
    private static final double F3 = 0.3333333333333333;
    private static final double G3 = 0.16666666666666666;
    private static final double F4;
    private static final double G4;

    private NoiseSimplex() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = Arrays.toString(perm);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        System.out.println((Object)string2);
        String string3 = Arrays.toString(permMod12);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        string2 = string3;
        System.out.println((Object)string2);
    }

    private final int fastfloor(double x) {
        int xi = ExtensionsKt.getI(x);
        return x < (double)xi ? xi - 1 : xi;
    }

    private final double dot(Grad g, double x, double y) {
        return g.getX() * x + g.getY() * y;
    }

    private final double dot(Grad g, double x, double y, double z) {
        return g.getX() * x + g.getY() * y + g.getZ() * z;
    }

    private final double dot(Grad g, double x, double y, double z, double w) {
        return g.getX() * x + g.getY() * y + g.getZ() * z + g.getW() * w;
    }

    public final double noise(double x, double y) {
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        double s = (x + y) * F2;
        int i2 = this.fastfloor(x + s);
        int j = this.fastfloor(y + s);
        double t = (double)(i2 + j) * G2;
        double X0 = (double)i2 - t;
        double Y0 = (double)j - t;
        double x0 = x - X0;
        double y0 = t - Y0;
        int i1 = 0;
        int j1 = 0;
        if (x0 > y0) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double y1 = y0 - (double)j1 + G2;
        double x2 = x0 - 1.0 + 2.0 * G2;
        double y2 = y0 - 1.0 + 2.0 * G2;
        int ii = i2 & 0xFF;
        int jj = j & 0xFF;
        int gi0 = ExtensionsKt.getI(permMod12[ii + perm[jj]]);
        int gi1 = ExtensionsKt.getI(permMod12[ii + i1 + perm[jj + j1]]);
        int gi2 = ExtensionsKt.getI(permMod12[ii + 1 + perm[jj + 1]]);
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * this.dot(grad3[gi0], x0, y0);
        }
        double t1 = 0.5 - x1 * x1 - y1 * y1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * this.dot(grad3[gi1], x1, y1);
        }
        double t2 = 0.5 - x2 * x2 - y2 * y2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * this.dot(grad3[gi2], x2, y2);
        }
        return 70.0 * (n0 + n1 + n2);
    }

    public final double noise(double x, double y, double z) {
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        double n3 = 0.0;
        double s = (x + y + z) * 0.3333333333333333;
        int i2 = this.fastfloor(x + s);
        int j = this.fastfloor(y + s);
        int k = this.fastfloor(z + s);
        double t = (double)(i2 + j + k) * 0.16666666666666666;
        double X0 = (double)i2 - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int i22 = 0;
        int j2 = 0;
        int k2 = 0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i22 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i22 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i22 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i22 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i22 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i22 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i22 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 - 1.0 + 0.5;
        double y3 = y0 - 1.0 + 0.5;
        double z3 = z0 - 1.0 + 0.5;
        int ii = i2 & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        int gi0 = ExtensionsKt.getI(permMod12[ii + perm[jj + perm[kk]]]);
        int gi1 = ExtensionsKt.getI(permMod12[ii + i1 + perm[jj + j1 + perm[kk + k1]]]);
        int gi2 = ExtensionsKt.getI(permMod12[ii + i22 + perm[jj + j2 + perm[kk + k2]]]);
        int gi3 = ExtensionsKt.getI(permMod12[ii + 1 + perm[jj + 1 + perm[kk + 1]]]);
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * this.dot(grad3[gi0], x0, y0, z0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * this.dot(grad3[gi1], x1, y1, z1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * this.dot(grad3[gi2], x2, y2, z2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * this.dot(grad3[gi3], x3, y3, z3);
        }
        return 32.0 * (n0 + n1 + n2 + n3);
    }

    public final double noise(double x, double y, double z, double w) {
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        double n3 = 0.0;
        double n4 = 0.0;
        double s = (x + y + z + w) * F4;
        int i2 = this.fastfloor(x + s);
        int j = this.fastfloor(y + s);
        int k = this.fastfloor(z + s);
        int l = this.fastfloor(w + s);
        double t = (double)(i2 + j + k + l) * G4;
        double X0 = (double)i2 - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double W0 = (double)l - t;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        double w0 = w - W0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        int n = x0 > y0 ? rankx++ : ranky++;
        int n5 = x0 > z0 ? rankx++ : rankz++;
        int n6 = x0 > w0 ? rankx++ : rankw++;
        int n7 = y0 > z0 ? ranky++ : rankz++;
        int n8 = y0 > w0 ? ranky++ : rankw++;
        int n9 = z0 > w0 ? rankz++ : rankw++;
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int l1 = 0;
        int i22 = 0;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        int i3 = 0;
        int j3 = 0;
        int k3 = 0;
        int l3 = 0;
        i1 = rankx >= 3 ? 1 : 0;
        j1 = ranky >= 3 ? 1 : 0;
        k1 = rankz >= 3 ? 1 : 0;
        l1 = rankw >= 3 ? 1 : 0;
        i22 = rankx >= 2 ? 1 : 0;
        j2 = ranky >= 2 ? 1 : 0;
        k2 = rankz >= 2 ? 1 : 0;
        l2 = rankw >= 2 ? 1 : 0;
        i3 = rankx >= 1 ? 1 : 0;
        j3 = ranky >= 1 ? 1 : 0;
        k3 = rankz >= 1 ? 1 : 0;
        l3 = rankw >= 1 ? 1 : 0;
        double x1 = x0 - (double)i1 + G4;
        double y1 = y0 - (double)j1 + G4;
        double z1 = z0 - (double)k1 + G4;
        double w1 = w0 - (double)l1 + G4;
        double x2 = x0 - (double)i22 + 2.0 * G4;
        double y2 = y0 - (double)j2 + 2.0 * G4;
        double z2 = z0 - (double)k2 + 2.0 * G4;
        double w2 = w0 - (double)l2 + 2.0 * G4;
        double x3 = x0 - (double)i3 + 3.0 * G4;
        double y3 = y0 - (double)j3 + 3.0 * G4;
        double z3 = z0 - (double)k3 + 3.0 * G4;
        double w3 = w0 - (double)l3 + 3.0 * G4;
        double x4 = x0 - 1.0 + 4.0 * G4;
        double y4 = y0 - 1.0 + 4.0 * G4;
        double z4 = z0 - 1.0 + 4.0 * G4;
        double w4 = w0 - 1.0 + 4.0 * G4;
        int ii = i2 & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        int ll = l & 0xFF;
        int gi0 = perm[ii + perm[jj + perm[kk + perm[ll]]]] % 32;
        int gi1 = perm[ii + i1 + perm[jj + j1 + perm[kk + k1 + perm[ll + l1]]]] % 32;
        int gi2 = perm[ii + i22 + perm[jj + j2 + perm[kk + k2 + perm[ll + l2]]]] % 32;
        int gi3 = perm[ii + i3 + perm[jj + j3 + perm[kk + k3 + perm[ll + l3]]]] % 32;
        int gi4 = perm[ii + 1 + perm[jj + 1 + perm[kk + 1 + perm[ll + 1]]]] % 32;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * this.dot(grad4[gi0], x0, y0, z0, w0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * this.dot(grad4[gi1], x1, y1, z1, w1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * this.dot(grad4[gi2], x2, y2, z2, w2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * this.dot(grad4[gi3], x3, y3, z3, w3);
        }
        double t4 = 0.6 - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
        if (t4 < 0.0) {
            n4 = 0.0;
        } else {
            t4 *= t4;
            n4 = t4 * t4 * this.dot(grad4[gi4], x4, y4, z4, w4);
        }
        return 27.0 * (n0 + n1 + n2 + n3 + n4);
    }

    private final Grad Grad(int x, int y, int z, int w) {
        return new Grad(ExtensionsKt.getD(x), ExtensionsKt.getD(y), ExtensionsKt.getD(z), ExtensionsKt.getD(w));
    }

    static /* synthetic */ Grad Grad$default(NoiseSimplex noiseSimplex, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return noiseSimplex.Grad(n, n2, n3, n4);
    }

    static {
        int n;
        INSTANCE = new NoiseSimplex();
        Object[] objectArray = new Grad[]{NoiseSimplex.Grad$default(INSTANCE, 1, 1, 0, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, -1, 1, 0, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 1, -1, 0, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, -1, -1, 0, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 1, 0, 1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, -1, 0, 1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 1, 0, -1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, -1, 0, -1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 0, 1, 1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 0, -1, 1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 0, 1, -1, 0, 8, null), NoiseSimplex.Grad$default(INSTANCE, 0, -1, -1, 0, 8, null)};
        grad3 = objectArray;
        objectArray = new Grad[]{INSTANCE.Grad(0, 1, 1, 1), INSTANCE.Grad(0, 1, 1, -1), INSTANCE.Grad(0, 1, -1, 1), INSTANCE.Grad(0, 1, -1, -1), INSTANCE.Grad(0, -1, 1, 1), INSTANCE.Grad(0, -1, 1, -1), INSTANCE.Grad(0, -1, -1, 1), INSTANCE.Grad(0, -1, -1, -1), INSTANCE.Grad(1, 0, 1, 1), INSTANCE.Grad(1, 0, 1, -1), INSTANCE.Grad(1, 0, -1, 1), INSTANCE.Grad(1, 0, -1, -1), INSTANCE.Grad(-1, 0, 1, 1), INSTANCE.Grad(-1, 0, 1, -1), INSTANCE.Grad(-1, 0, -1, 1), INSTANCE.Grad(-1, 0, -1, -1), INSTANCE.Grad(1, 1, 0, 1), INSTANCE.Grad(1, 1, 0, -1), INSTANCE.Grad(1, -1, 0, 1), INSTANCE.Grad(1, -1, 0, -1), INSTANCE.Grad(-1, 1, 0, 1), INSTANCE.Grad(-1, 1, 0, -1), INSTANCE.Grad(-1, -1, 0, 1), INSTANCE.Grad(-1, -1, 0, -1), INSTANCE.Grad(1, 1, 1, 0), INSTANCE.Grad(1, 1, -1, 0), INSTANCE.Grad(1, -1, 1, 0), INSTANCE.Grad(1, -1, -1, 0), INSTANCE.Grad(-1, 1, 1, 0), INSTANCE.Grad(-1, 1, -1, 0), INSTANCE.Grad(-1, -1, 1, 0), INSTANCE.Grad(-1, -1, -1, 0)};
        grad4 = objectArray;
        objectArray = new short[256];
        objectArray[0] = (Grad)151;
        objectArray[1] = (Grad)160;
        objectArray[2] = (Grad)137;
        objectArray[3] = (Grad)91;
        objectArray[4] = (Grad)90;
        objectArray[5] = (Grad)15;
        objectArray[6] = (Grad)131;
        objectArray[7] = (Grad)13;
        objectArray[8] = (Grad)201;
        objectArray[9] = (Grad)95;
        objectArray[10] = (Grad)96;
        objectArray[11] = (Grad)53;
        objectArray[12] = (Grad)194;
        objectArray[13] = (Grad)233;
        objectArray[14] = (Grad)7;
        objectArray[15] = (Grad)225;
        objectArray[16] = (Grad)140;
        objectArray[17] = (Grad)36;
        objectArray[18] = (Grad)103;
        objectArray[19] = (Grad)30;
        objectArray[20] = (Grad)69;
        objectArray[21] = (Grad)142;
        objectArray[22] = (Grad)8;
        objectArray[23] = (Grad)99;
        objectArray[24] = (Grad)37;
        objectArray[25] = (Grad)240;
        objectArray[26] = (Grad)21;
        objectArray[27] = (Grad)10;
        objectArray[28] = (Grad)23;
        objectArray[29] = (Grad)190;
        objectArray[30] = (Grad)6;
        objectArray[31] = (Grad)148;
        objectArray[32] = (Grad)247;
        objectArray[33] = (Grad)120;
        objectArray[34] = (Grad)234;
        objectArray[35] = (Grad)75;
        objectArray[36] = (Grad)false;
        objectArray[37] = (Grad)26;
        objectArray[38] = (Grad)197;
        objectArray[39] = (Grad)62;
        objectArray[40] = (Grad)94;
        objectArray[41] = (Grad)252;
        objectArray[42] = (Grad)219;
        objectArray[43] = (Grad)203;
        objectArray[44] = (Grad)117;
        objectArray[45] = (Grad)35;
        objectArray[46] = (Grad)11;
        objectArray[47] = (Grad)32;
        objectArray[48] = (Grad)57;
        objectArray[49] = (Grad)177;
        objectArray[50] = (Grad)33;
        objectArray[51] = (Grad)88;
        objectArray[52] = (Grad)237;
        objectArray[53] = (Grad)149;
        objectArray[54] = (Grad)56;
        objectArray[55] = (Grad)87;
        objectArray[56] = (Grad)174;
        objectArray[57] = (Grad)20;
        objectArray[58] = (Grad)125;
        objectArray[59] = (Grad)136;
        objectArray[60] = (Grad)171;
        objectArray[61] = (Grad)168;
        objectArray[62] = (Grad)68;
        objectArray[63] = (Grad)175;
        objectArray[64] = (Grad)74;
        objectArray[65] = (Grad)165;
        objectArray[66] = (Grad)71;
        objectArray[67] = (Grad)134;
        objectArray[68] = (Grad)139;
        objectArray[69] = (Grad)48;
        objectArray[70] = (Grad)27;
        objectArray[71] = (Grad)166;
        objectArray[72] = (Grad)77;
        objectArray[73] = (Grad)146;
        objectArray[74] = (Grad)158;
        objectArray[75] = (Grad)231;
        objectArray[76] = (Grad)83;
        objectArray[77] = (Grad)111;
        objectArray[78] = (Grad)229;
        objectArray[79] = (Grad)122;
        objectArray[80] = (Grad)60;
        objectArray[81] = (Grad)211;
        objectArray[82] = (Grad)133;
        objectArray[83] = (Grad)230;
        objectArray[84] = (Grad)220;
        objectArray[85] = (Grad)105;
        objectArray[86] = (Grad)92;
        objectArray[87] = (Grad)41;
        objectArray[88] = (Grad)55;
        objectArray[89] = (Grad)46;
        objectArray[90] = (Grad)245;
        objectArray[91] = (Grad)40;
        objectArray[92] = (Grad)244;
        objectArray[93] = (Grad)102;
        objectArray[94] = (Grad)143;
        objectArray[95] = (Grad)54;
        objectArray[96] = (Grad)65;
        objectArray[97] = (Grad)25;
        objectArray[98] = (Grad)63;
        objectArray[99] = (Grad)161;
        objectArray[100] = (Grad)true;
        objectArray[101] = (Grad)216;
        objectArray[102] = (Grad)80;
        objectArray[103] = (Grad)73;
        objectArray[104] = (Grad)209;
        objectArray[105] = (Grad)76;
        objectArray[106] = (Grad)132;
        objectArray[107] = (Grad)187;
        objectArray[108] = (Grad)208;
        objectArray[109] = (Grad)89;
        objectArray[110] = (Grad)18;
        objectArray[111] = (Grad)169;
        objectArray[112] = (Grad)200;
        objectArray[113] = (Grad)196;
        objectArray[114] = (Grad)135;
        objectArray[115] = (Grad)130;
        objectArray[116] = (Grad)116;
        objectArray[117] = (Grad)188;
        objectArray[118] = (Grad)159;
        objectArray[119] = (Grad)86;
        objectArray[120] = (Grad)164;
        objectArray[121] = (Grad)100;
        objectArray[122] = (Grad)109;
        objectArray[123] = (Grad)198;
        objectArray[124] = (Grad)173;
        objectArray[125] = (Grad)186;
        objectArray[126] = (Grad)3;
        objectArray[127] = (Grad)64;
        objectArray[128] = (Grad)52;
        objectArray[129] = (Grad)217;
        objectArray[130] = (Grad)226;
        objectArray[131] = (Grad)250;
        objectArray[132] = (Grad)124;
        objectArray[133] = (Grad)123;
        objectArray[134] = (Grad)5;
        objectArray[135] = (Grad)202;
        objectArray[136] = (Grad)38;
        objectArray[137] = (Grad)147;
        objectArray[138] = (Grad)118;
        objectArray[139] = (Grad)126;
        objectArray[140] = (Grad)255;
        objectArray[141] = (Grad)82;
        objectArray[142] = (Grad)85;
        objectArray[143] = (Grad)212;
        objectArray[144] = (Grad)207;
        objectArray[145] = (Grad)206;
        objectArray[146] = (Grad)59;
        objectArray[147] = (Grad)227;
        objectArray[148] = (Grad)47;
        objectArray[149] = (Grad)16;
        objectArray[150] = (Grad)58;
        objectArray[151] = (Grad)17;
        objectArray[152] = (Grad)182;
        objectArray[153] = (Grad)189;
        objectArray[154] = (Grad)28;
        objectArray[155] = (Grad)42;
        objectArray[156] = (Grad)223;
        objectArray[157] = (Grad)183;
        objectArray[158] = (Grad)170;
        objectArray[159] = (Grad)213;
        objectArray[160] = (Grad)119;
        objectArray[161] = (Grad)248;
        objectArray[162] = (Grad)152;
        objectArray[163] = (Grad)2;
        objectArray[164] = (Grad)44;
        objectArray[165] = (Grad)154;
        objectArray[166] = (Grad)163;
        objectArray[167] = (Grad)70;
        objectArray[168] = (Grad)221;
        objectArray[169] = (Grad)153;
        objectArray[170] = (Grad)101;
        objectArray[171] = (Grad)155;
        objectArray[172] = (Grad)167;
        objectArray[173] = (Grad)43;
        objectArray[174] = (Grad)172;
        objectArray[175] = (Grad)9;
        objectArray[176] = (Grad)129;
        objectArray[177] = (Grad)22;
        objectArray[178] = (Grad)39;
        objectArray[179] = (Grad)253;
        objectArray[180] = (Grad)19;
        objectArray[181] = (Grad)98;
        objectArray[182] = (Grad)108;
        objectArray[183] = (Grad)110;
        objectArray[184] = (Grad)79;
        objectArray[185] = (Grad)113;
        objectArray[186] = (Grad)224;
        objectArray[187] = (Grad)232;
        objectArray[188] = (Grad)178;
        objectArray[189] = (Grad)185;
        objectArray[190] = (Grad)112;
        objectArray[191] = (Grad)104;
        objectArray[192] = (Grad)218;
        objectArray[193] = (Grad)246;
        objectArray[194] = (Grad)97;
        objectArray[195] = (Grad)228;
        objectArray[196] = (Grad)251;
        objectArray[197] = (Grad)34;
        objectArray[198] = (Grad)242;
        objectArray[199] = (Grad)193;
        objectArray[200] = (Grad)238;
        objectArray[201] = (Grad)210;
        objectArray[202] = (Grad)144;
        objectArray[203] = (Grad)12;
        objectArray[204] = (Grad)191;
        objectArray[205] = (Grad)179;
        objectArray[206] = (Grad)162;
        objectArray[207] = (Grad)241;
        objectArray[208] = (Grad)81;
        objectArray[209] = (Grad)51;
        objectArray[210] = (Grad)145;
        objectArray[211] = (Grad)235;
        objectArray[212] = (Grad)249;
        objectArray[213] = (Grad)14;
        objectArray[214] = (Grad)239;
        objectArray[215] = (Grad)107;
        objectArray[216] = (Grad)49;
        objectArray[217] = (Grad)192;
        objectArray[218] = (Grad)214;
        objectArray[219] = (Grad)31;
        objectArray[220] = (Grad)181;
        objectArray[221] = (Grad)199;
        objectArray[222] = (Grad)106;
        objectArray[223] = (Grad)157;
        objectArray[224] = (Grad)184;
        objectArray[225] = (Grad)84;
        objectArray[226] = (Grad)204;
        objectArray[227] = (Grad)176;
        objectArray[228] = (Grad)115;
        objectArray[229] = (Grad)121;
        objectArray[230] = (Grad)50;
        objectArray[231] = (Grad)45;
        objectArray[232] = (Grad)127;
        objectArray[233] = (Grad)4;
        objectArray[234] = (Grad)150;
        objectArray[235] = (Grad)254;
        objectArray[236] = (Grad)138;
        objectArray[237] = (Grad)236;
        objectArray[238] = (Grad)205;
        objectArray[239] = (Grad)93;
        objectArray[240] = (Grad)222;
        objectArray[241] = (Grad)114;
        objectArray[242] = (Grad)67;
        objectArray[243] = (Grad)29;
        objectArray[244] = (Grad)24;
        objectArray[245] = (Grad)72;
        objectArray[246] = (Grad)243;
        objectArray[247] = (Grad)141;
        objectArray[248] = (Grad)128;
        objectArray[249] = (Grad)195;
        objectArray[250] = (Grad)78;
        objectArray[251] = (Grad)66;
        objectArray[252] = (Grad)215;
        objectArray[253] = (Grad)61;
        objectArray[254] = (Grad)156;
        objectArray[255] = (Grad)180;
        p = (short[])objectArray;
        int n2 = 0;
        short[] sArray = new short[512];
        while (n2 < 512) {
            n = n2++;
            sArray[n] = p[n & 0xFF];
        }
        perm = sArray;
        n2 = 0;
        sArray = new short[512];
        while (n2 < 512) {
            n = n2++;
            sArray[n] = (short)(perm[n] % 12);
        }
        permMod12 = sArray;
        F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
        G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
        F4 = (Math.sqrt(5.0) - 1.0) / 4.0;
        G4 = (5.0 - Math.sqrt(5.0)) / 20.0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"Lalexsocol/asjlib/math/NoiseSimplex$Grad;", "", "x", "", "y", "z", "w", "<init>", "(DDDD)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "getW", "setW", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "1.7.10-ASJCore"})
    private static final class Grad {
        private double x;
        private double y;
        private double z;
        private double w;

        public Grad(double x, double y, double z, double w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        public /* synthetic */ Grad(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                d4 = 0.0;
            }
            this(d, d2, d3, d4);
        }

        public final double getX() {
            return this.x;
        }

        public final void setX(double d) {
            this.x = d;
        }

        public final double getY() {
            return this.y;
        }

        public final void setY(double d) {
            this.y = d;
        }

        public final double getZ() {
            return this.z;
        }

        public final void setZ(double d) {
            this.z = d;
        }

        public final double getW() {
            return this.w;
        }

        public final void setW(double d) {
            this.w = d;
        }

        public final double component1() {
            return this.x;
        }

        public final double component2() {
            return this.y;
        }

        public final double component3() {
            return this.z;
        }

        public final double component4() {
            return this.w;
        }

        @NotNull
        public final Grad copy(double x, double y, double z, double w) {
            return new Grad(x, y, z, w);
        }

        public static /* synthetic */ Grad copy$default(Grad grad, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = grad.x;
            }
            if ((n & 2) != 0) {
                d2 = grad.y;
            }
            if ((n & 4) != 0) {
                d3 = grad.z;
            }
            if ((n & 8) != 0) {
                d4 = grad.w;
            }
            return grad.copy(d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "Grad(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.x);
            result = result * 31 + Double.hashCode(this.y);
            result = result * 31 + Double.hashCode(this.z);
            result = result * 31 + Double.hashCode(this.w);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Grad)) {
                return false;
            }
            Grad grad = (Grad)other;
            if (Double.compare(this.x, grad.x) != 0) {
                return false;
            }
            if (Double.compare(this.y, grad.y) != 0) {
                return false;
            }
            if (Double.compare(this.z, grad.z) != 0) {
                return false;
            }
            return Double.compare(this.w, grad.w) == 0;
        }
    }
}

