/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020/H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u00104\u001a\u00020/JB\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00069"}, d2={"Lalexsocol/asjlib/render/ModelBipedNew;", "Lnet/minecraft/client/model/ModelBase;", "<init>", "()V", "head", "Lnet/minecraft/client/model/ModelRenderer;", "getHead", "()Lnet/minecraft/client/model/ModelRenderer;", "hair", "getHair", "body", "getBody", "chest", "getChest", "rightarm", "getRightarm", "rightglove", "getRightglove", "leftarm", "getLeftarm", "leftglove", "getLeftglove", "rightleg", "getRightleg", "rightboot", "getRightboot", "leftleg", "getLeftleg", "leftboot", "getLeftboot", "heldItemRight", "", "getHeldItemRight", "()I", "setHeldItemRight", "(I)V", "aimedBow", "", "getAimedBow", "()Z", "setAimedBow", "(Z)V", "render", "", "entity", "Lnet/minecraft/entity/Entity;", "time", "", "amplitude", "ticksExisted", "yawHead", "pitchHead", "size", "setRotationAngles", "limbSwing", "limbAmpl", "Companion", "1.7.10-ASJCore"})
public class ModelBipedNew
extends ModelBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelRenderer head;
    @NotNull
    private final ModelRenderer hair;
    @NotNull
    private final ModelRenderer body;
    @NotNull
    private final ModelRenderer chest;
    @NotNull
    private final ModelRenderer rightarm;
    @NotNull
    private final ModelRenderer rightglove;
    @NotNull
    private final ModelRenderer leftarm;
    @NotNull
    private final ModelRenderer leftglove;
    @NotNull
    private final ModelRenderer rightleg;
    @NotNull
    private final ModelRenderer rightboot;
    @NotNull
    private final ModelRenderer leftleg;
    @NotNull
    private final ModelRenderer leftboot;
    private int heldItemRight;
    private boolean aimedBow;
    @NotNull
    private static final ModelBipedNew INSTANCE = new ModelBipedNew();

    public ModelBipedNew() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.isChild = false;
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.addBox(-4.0f, -8.001f, -4.0f, 8, 8, 8);
        this.head.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.hair = new ModelRenderer((ModelBase)this, 32, 0);
        this.hair.addBox(-4.0f, -8.001f, -4.0f, 8, 8, 8, 0.5f);
        this.head.addChild(this.hair);
        this.body = new ModelRenderer((ModelBase)this, 16, 16);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.chest = new ModelRenderer((ModelBase)this, 16, 32);
        this.chest.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, 0.5f);
        this.body.addChild(this.chest);
        this.rightarm = new ModelRenderer((ModelBase)this, 40, 16);
        this.rightarm.addBox(-3.001f, -2.0f, -2.0f, 4, 12, 4);
        this.rightarm.setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.rightglove = new ModelRenderer((ModelBase)this, 40, 32);
        this.rightglove.addBox(-3.001f, -2.0f, -2.0f, 4, 12, 4, 0.5f);
        this.rightarm.addChild(this.rightglove);
        this.leftarm = new ModelRenderer((ModelBase)this, 32, 48);
        this.leftarm.addBox(-1.001f, -2.0f, -2.0f, 4, 12, 4);
        this.leftarm.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.leftglove = new ModelRenderer((ModelBase)this, 48, 48);
        this.leftglove.addBox(-1.001f, -2.0f, -2.0f, 4, 12, 4, 0.5f);
        this.leftarm.addChild(this.leftglove);
        this.rightleg = new ModelRenderer((ModelBase)this, 0, 16);
        this.rightleg.addBox(-2.0f, 0.001f, -2.0f, 4, 12, 4);
        this.rightleg.setRotationPoint(-2.0f, 12.0f, 0.0f);
        this.rightboot = new ModelRenderer((ModelBase)this, 0, 32);
        this.rightboot.addBox(-2.0f, 0.001f, -2.0f, 4, 12, 4, 0.5f);
        this.rightleg.addChild(this.rightboot);
        this.leftleg = new ModelRenderer((ModelBase)this, 16, 48);
        this.leftleg.addBox(-2.0f, 0.001f, -2.0f, 4, 12, 4);
        this.leftleg.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.leftboot = new ModelRenderer((ModelBase)this, 0, 48);
        this.leftboot.addBox(-2.0f, 0.001f, -2.0f, 4, 12, 4, 0.5f);
        this.leftleg.addChild(this.leftboot);
    }

    @NotNull
    public final ModelRenderer getHead() {
        return this.head;
    }

    @NotNull
    public final ModelRenderer getHair() {
        return this.hair;
    }

    @NotNull
    public final ModelRenderer getBody() {
        return this.body;
    }

    @NotNull
    public final ModelRenderer getChest() {
        return this.chest;
    }

    @NotNull
    public final ModelRenderer getRightarm() {
        return this.rightarm;
    }

    @NotNull
    public final ModelRenderer getRightglove() {
        return this.rightglove;
    }

    @NotNull
    public final ModelRenderer getLeftarm() {
        return this.leftarm;
    }

    @NotNull
    public final ModelRenderer getLeftglove() {
        return this.leftglove;
    }

    @NotNull
    public final ModelRenderer getRightleg() {
        return this.rightleg;
    }

    @NotNull
    public final ModelRenderer getRightboot() {
        return this.rightboot;
    }

    @NotNull
    public final ModelRenderer getLeftleg() {
        return this.leftleg;
    }

    @NotNull
    public final ModelRenderer getLeftboot() {
        return this.leftboot;
    }

    public final int getHeldItemRight() {
        return this.heldItemRight;
    }

    public final void setHeldItemRight(int n) {
        this.heldItemRight = n;
    }

    public final boolean getAimedBow() {
        return this.aimedBow;
    }

    public final void setAimedBow(boolean bl) {
        this.aimedBow = bl;
    }

    public void render(@NotNull Entity entity, float time, float amplitude, float ticksExisted, float yawHead, float pitchHead, float size) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.setRotationAngles(time, amplitude, ticksExisted, yawHead, pitchHead, size, entity);
        if (this.isChild) {
            GL11.glPushMatrix();
            ExtensionsClientKt.glScaled(0.5);
            GL11.glTranslatef((float)0.0f, (float)(24.0f * size), (float)0.0f);
        }
        this.render(size);
        if (this.isChild) {
            GL11.glPopMatrix();
        }
    }

    public final void render(float size) {
        GL11.glDisable((int)2884);
        this.head.render(size);
        this.body.render(size);
        this.rightarm.render(size);
        this.leftarm.render(size);
        this.rightleg.render(size);
        this.leftleg.render(size);
        GL11.glEnable((int)2884);
    }

    public void setRotationAngles(float limbSwing, float limbAmpl, float ticksExisted, float yawHead, float pitchHead, float size, @Nullable Entity entity) {
        float f7;
        this.head.rotateAngleY = yawHead / (180.0f / ExtensionsKt.getF(Math.PI));
        this.head.rotateAngleX = pitchHead / (180.0f / ExtensionsKt.getF(Math.PI));
        this.rightarm.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f + ExtensionsKt.getF(Math.PI))) * 2.0f * limbAmpl * 0.5f;
        this.leftarm.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbAmpl * 0.5f;
        this.rightarm.rotateAngleZ = 0.0f;
        this.leftarm.rotateAngleZ = 0.0f;
        this.rightleg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbAmpl;
        this.leftleg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f + ExtensionsKt.getF(Math.PI))) * 1.4f * limbAmpl;
        this.rightleg.rotateAngleY = 0.0f;
        this.leftleg.rotateAngleY = 0.0f;
        Entity entity2 = entity;
        boolean bl = entity2 != null ? entity2.isRiding() : false;
        if (bl) {
            ModelRenderer modelRenderer = this.rightarm;
            modelRenderer.rotateAngleX += -(ExtensionsKt.getF(Math.PI) / 5.0f);
            modelRenderer = this.leftarm;
            modelRenderer.rotateAngleX += -(ExtensionsKt.getF(Math.PI) / 5.0f);
            this.rightleg.rotateAngleX = -(ExtensionsKt.getF(Math.PI) * 2.0f / 5.0f);
            this.leftleg.rotateAngleX = -(ExtensionsKt.getF(Math.PI) * 2.0f / 5.0f);
            this.rightleg.rotateAngleY = ExtensionsKt.getF(Math.PI) / 10.0f;
            this.leftleg.rotateAngleY = -(ExtensionsKt.getF(Math.PI) / 10.0f);
        }
        if (this.heldItemRight != 0) {
            this.rightarm.rotateAngleX = this.rightarm.rotateAngleX * 0.5f - ExtensionsKt.getF(Math.PI) / 10.0f * (float)this.heldItemRight;
        }
        this.rightarm.rotateAngleY = 0.0f;
        this.leftarm.rotateAngleY = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.body.rotateAngleY = MathHelper.sin((float)((float)Math.sqrt(f6) * ExtensionsKt.getF(Math.PI) * 2.0f)) * 0.2f;
            this.rightarm.rotationPointZ = MathHelper.sin((float)this.body.rotateAngleY) * 5.0f;
            this.rightarm.rotationPointX = -MathHelper.cos((float)this.body.rotateAngleY) * 5.0f;
            this.leftarm.rotationPointZ = -MathHelper.sin((float)this.body.rotateAngleY) * 5.0f;
            this.leftarm.rotationPointX = MathHelper.cos((float)this.body.rotateAngleY) * 5.0f;
            ModelRenderer modelRenderer = this.rightarm;
            modelRenderer.rotateAngleY += this.body.rotateAngleY;
            modelRenderer = this.leftarm;
            modelRenderer.rotateAngleY += this.body.rotateAngleY;
            modelRenderer = this.leftarm;
            modelRenderer.rotateAngleX += this.body.rotateAngleY;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            f7 = MathHelper.sin((float)(f6 * ExtensionsKt.getF(Math.PI)));
            float f8 = MathHelper.sin((float)(this.onGround * ExtensionsKt.getF(Math.PI))) * -(this.head.rotateAngleX - 0.7f) * 0.75f;
            this.rightarm.rotateAngleX = ExtensionsKt.getF(ExtensionsKt.getD(Float.valueOf(this.rightarm.rotateAngleX)) - (ExtensionsKt.getD(Float.valueOf(f7)) * 1.2 + ExtensionsKt.getD(Float.valueOf(f8))));
            ModelRenderer modelRenderer2 = this.rightarm;
            modelRenderer2.rotateAngleY += this.body.rotateAngleY * 2.0f;
            this.rightarm.rotateAngleZ = MathHelper.sin((float)(this.onGround * ExtensionsKt.getF(Math.PI))) * -0.4f;
        }
        Entity entity3 = entity;
        boolean bl2 = entity3 != null ? entity3.isSneaking() : false;
        if (bl2) {
            this.body.rotateAngleX = 0.5f;
            ModelRenderer f6 = this.rightarm;
            f6.rotateAngleX += 0.4f;
            f6 = this.leftarm;
            f6.rotateAngleX += 0.4f;
            this.rightleg.rotationPointZ = 4.0f;
            this.leftleg.rotationPointZ = 4.0f;
            this.rightleg.rotationPointY = 9.0f;
            this.leftleg.rotationPointY = 9.0f;
            this.head.rotationPointY = 1.0f;
            this.hair.rotationPointY = 1.0f;
        } else {
            this.body.rotateAngleX = 0.0f;
            this.rightleg.rotationPointZ = 0.1f;
            this.leftleg.rotationPointZ = 0.1f;
            this.rightleg.rotationPointY = 12.0f;
            this.leftleg.rotationPointY = 12.0f;
            this.head.rotationPointY = 0.0f;
            this.hair.rotationPointY = 0.0f;
        }
        ModelRenderer f6 = this.rightarm;
        f6.rotateAngleZ += MathHelper.cos((float)(ticksExisted * 0.09f)) * 0.05f + 0.05f;
        f6 = this.leftarm;
        f6.rotateAngleZ -= MathHelper.cos((float)(ticksExisted * 0.09f)) * 0.05f + 0.05f;
        f6 = this.rightarm;
        f6.rotateAngleX += MathHelper.sin((float)(ticksExisted * 0.067f)) * 0.05f;
        f6 = this.leftarm;
        f6.rotateAngleX -= MathHelper.sin((float)(ticksExisted * 0.067f)) * 0.05f;
        if (this.aimedBow) {
            float f62 = 0.0f;
            f7 = 0.0f;
            this.rightarm.rotateAngleZ = 0.0f;
            this.leftarm.rotateAngleZ = 0.0f;
            this.rightarm.rotateAngleY = -(0.1f - f62 * 0.6f) + this.head.rotateAngleY;
            this.leftarm.rotateAngleY = 0.1f - f62 * 0.6f + this.head.rotateAngleY + 0.4f;
            this.rightarm.rotateAngleX = -1.5707964f + this.head.rotateAngleX;
            this.leftarm.rotateAngleX = -1.5707964f + this.head.rotateAngleX;
            ModelRenderer modelRenderer = this.rightarm;
            modelRenderer.rotateAngleX -= f62 * 1.2f - f7 * 0.4f;
            modelRenderer = this.leftarm;
            modelRenderer.rotateAngleX -= f62 * 1.2f - f7 * 0.4f;
            modelRenderer = this.rightarm;
            modelRenderer.rotateAngleZ += MathHelper.cos((float)(ticksExisted * 0.09f)) * 0.05f + 0.05f;
            modelRenderer = this.leftarm;
            modelRenderer.rotateAngleZ -= MathHelper.cos((float)(ticksExisted * 0.09f)) * 0.05f + 0.05f;
            modelRenderer = this.rightarm;
            modelRenderer.rotateAngleX += MathHelper.sin((float)(ticksExisted * 0.067f)) * 0.05f;
            modelRenderer = this.leftarm;
            modelRenderer.rotateAngleX -= MathHelper.sin((float)(ticksExisted * 0.067f)) * 0.05f;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lalexsocol/asjlib/render/ModelBipedNew$Companion;", "", "<init>", "()V", "INSTANCE", "Lalexsocol/asjlib/render/ModelBipedNew;", "getINSTANCE", "()Lalexsocol/asjlib/render/ModelBipedNew;", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelBipedNew getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

