/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.render.ASJShaderHelper;
import alexsocol.asjlib.render.ResourceLocationAnimated;
import alexsocol.asjlib.render.ShadedObject;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fJ\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0006\u0010\u001b\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lalexsocol/asjlib/render/RenderPostShaders;", "", "<init>", "()V", "allowShaders", "", "getAllowShaders", "()Z", "setAllowShaders", "(Z)V", "shaders", "Ljava/util/ArrayList;", "Lalexsocol/asjlib/render/ShadedObject;", "Lkotlin/collections/ArrayList;", "getShaders", "()Ljava/util/ArrayList;", "renderObjectMaterialID", "", "nextAvailableRenderObjectMaterialID", "getNextAvailableRenderObjectMaterialID", "()I", "registerShadedObject", "", "renobj", "onWorldLastRender", "e", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "dispatchObjects", "1.7.10-ASJCore"})
public final class RenderPostShaders {
    @NotNull
    public static final RenderPostShaders INSTANCE = new RenderPostShaders();
    private static boolean allowShaders = true;
    @NotNull
    private static final ArrayList<ShadedObject> shaders = new ArrayList();
    private static int renderObjectMaterialID;

    private RenderPostShaders() {
    }

    public final boolean getAllowShaders() {
        return allowShaders;
    }

    public final void setAllowShaders(boolean bl) {
        allowShaders = bl;
    }

    @NotNull
    public final ArrayList<ShadedObject> getShaders() {
        return shaders;
    }

    public final int getNextAvailableRenderObjectMaterialID() {
        int n = renderObjectMaterialID;
        renderObjectMaterialID = n + 1;
        return n;
    }

    public final void registerShadedObject(@NotNull ShadedObject renobj) {
        Intrinsics.checkNotNullParameter((Object)renobj, (String)"renobj");
        shaders.add(renobj);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void onWorldLastRender(@NotNull RenderWorldLastEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.dispatchObjects();
    }

    public final void dispatchObjects() {
        if (shaders.isEmpty()) {
            return;
        }
        CollectionsKt.sort((List)shaders);
        boolean post = false;
        int prevShader = 0;
        int prevMaterial = -1;
        ShadedObject shadedObject = shaders.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)shadedObject, (String)"get(...)");
        ShadedObject prevObj = shadedObject;
        ResourceLocation pt = prevObj.getTexture();
        if (pt != null) {
            if (pt instanceof ResourceLocationAnimated) {
                ((ResourceLocationAnimated)pt).bind();
            } else {
                Minecraft.getMinecraft().renderEngine.bindTexture(pt);
            }
        }
        Iterator<ShadedObject> iterator = shaders.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ShadedObject> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ResourceLocation ot;
            ShadedObject obj;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (obj.getTranslations().isEmpty()) continue;
            if (post && obj.getMaterialID() != prevObj.getMaterialID()) {
                prevObj.postRender();
            }
            if (obj.getShaderID() != prevShader) {
                if (allowShaders) {
                    ASJShaderHelper.useShader$default(ASJShaderHelper.INSTANCE, obj.getShaderID(), null, 2, null);
                }
                prevShader = obj.getShaderID();
            }
            if (obj.getMaterialID() != prevMaterial) {
                obj.preRender();
            }
            if ((ot = obj.getTexture()) != null && ot != prevObj.getTexture()) {
                if (ot instanceof ResourceLocationAnimated) {
                    ((ResourceLocationAnimated)ot).bind();
                } else {
                    Minecraft.getMinecraft().renderEngine.bindTexture(ot);
                }
            }
            obj.doRender();
            obj.getTranslations().clear();
            prevObj = obj;
            post = true;
        }
        if (post) {
            prevObj.postRender();
        }
        if (allowShaders) {
            ASJShaderHelper.INSTANCE.releaseShader();
        }
    }

    static {
        ExtensionsKt.eventForge(INSTANCE);
    }
}

